/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.api.menu;

import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.api.AccessoriesAPI;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.AccessoriesContainer;
import io.wispforest.accessories.api.Accessory;
import io.wispforest.accessories.api.events.AllowEntityModificationCallback;
import io.wispforest.accessories.api.slot.SlotReference;
import io.wispforest.accessories.api.slot.SlotType;
import io.wispforest.accessories.data.EntitySlotLoader;
import io.wispforest.accessories.impl.ExpandedSimpleContainer;
import io.wispforest.accessories.menu.SlotTypeAccessible;
import io.wispforest.accessories.pond.AccessoriesLivingEntityExtension;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class AccessoriesBasedSlot
extends Slot
implements SlotTypeAccessible {
    private static final Logger LOGGER = LogUtils.getLogger();
    public final LivingEntity entity;
    public final AccessoriesContainer accessoriesContainer;

    public AccessoriesBasedSlot(AccessoriesContainer accessoriesContainer, ExpandedSimpleContainer container, int slot, int x, int y) {
        super((Container)container, slot, x, y);
        this.accessoriesContainer = accessoriesContainer;
        this.entity = accessoriesContainer.capability().entity();
    }

    @Nullable
    public static AccessoriesBasedSlot of(LivingEntity livingEntity, SlotType slotType, int x, int y) {
        return AccessoriesBasedSlot.of(livingEntity, slotType, 0, x, y);
    }

    @Nullable
    public static AccessoriesBasedSlot of(LivingEntity livingEntity, SlotType slotType, int slot, int x, int y) {
        AccessoriesCapability capability = livingEntity.accessoriesCapability();
        if (capability == null) {
            LOGGER.error("Unable to locate a capability for the given livingEntity meaning it does not have a valid Accessory Inventory [EntityType: {}]", (Object)livingEntity.getType());
            return null;
        }
        Map<String, SlotType> validEntitySlots = EntitySlotLoader.getEntitySlots(livingEntity);
        if (!validEntitySlots.containsKey(slotType.name())) {
            LOGGER.error("Unable to create Accessory Slot due to the given LivingEntity not having the given SlotType bound to it! [EntityType: {}, SlotType: {}]", (Object)livingEntity.getType(), (Object)slotType.name());
            return null;
        }
        AccessoriesContainer container = capability.getContainer(slotType);
        if (container == null) {
            LOGGER.error("Unable to locate the given container for the passed slotType. [SlotType:{}]", (Object)slotType.name());
            return null;
        }
        return new AccessoriesBasedSlot(container, container.getAccessories(), slot, x, y);
    }

    @Override
    public String slotName() {
        return this.accessoriesContainer.getSlotName();
    }

    @Override
    public SlotType slotType() {
        return this.accessoriesContainer.slotType();
    }

    @Override
    public AccessoriesContainer getContainer() {
        return this.accessoriesContainer;
    }

    @Deprecated
    public int getMaxStackSize() {
        return super.getMaxStackSize();
    }

    public int getMaxStackSize(ItemStack stack) {
        Accessory accessory = AccessoriesAPI.getOrDefaultAccessory(stack);
        return accessory.maxStackSize(stack);
    }

    public void set(ItemStack stack) {
        super.set(stack);
    }

    public void setByPlayer(ItemStack newStack, ItemStack oldStack) {
        ((AccessoriesLivingEntityExtension)this.entity).onEquipItem(this.accessoriesContainer.createReference(this.getContainerSlot()), oldStack, newStack);
        super.setByPlayer(newStack, oldStack);
    }

    public boolean mayPlace(ItemStack stack) {
        return AccessoriesAPI.canInsertIntoSlot(stack, SlotReference.of(this.entity, this.accessoriesContainer.getSlotName(), this.getContainerSlot()));
    }

    public boolean mayPickup(Player player) {
        if (!this.entity.equals((Object)player)) {
            SlotReference ref = this.accessoriesContainer.createReference(this.getContainerSlot());
            TriState result = ((AllowEntityModificationCallback)AllowEntityModificationCallback.EVENT.invoker()).allowModifications(this.entity, player, ref);
            if (!result.orElse(false)) {
                return false;
            }
        }
        return AccessoriesAPI.canUnequip(this.getItem(), SlotReference.of(this.entity, this.accessoriesContainer.getSlotName(), this.getContainerSlot()));
    }

    protected ResourceLocation icon() {
        SlotType slotType = this.accessoriesContainer.slotType();
        return slotType != null ? slotType.icon() : SlotType.EMPTY_SLOT_ICON;
    }

    public List<Component> getTooltipData() {
        ArrayList<Component> tooltipData = new ArrayList<Component>();
        SlotType slotType = this.accessoriesContainer.slotType();
        tooltipData.add((Component)Component.translatable((String)Accessories.translationKey("slot.tooltip.singular")).withStyle(ChatFormatting.GRAY).append((Component)Component.translatable((String)slotType.translation()).withStyle(ChatFormatting.BLUE)));
        return tooltipData;
    }

    @Nullable
    public Pair<ResourceLocation, ResourceLocation> getNoItemIcon() {
        return new Pair((Object)ResourceLocation.withDefaultNamespace((String)"textures/atlas/blocks.png"), (Object)this.icon());
    }
}

