/*
 * Decompiled with CFR 0.152.
 */
package net.commoble.entitydetectors.registrables;

import net.commoble.entitydetectors.EntityDetectors;
import net.commoble.entitydetectors.registrables.MobDetectorBlockEntity;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;

public class MobDetectorItemHandler
implements IItemHandler {
    public final MobDetectorBlockEntity mobDetector;

    public static boolean isItemValidFilter(ItemStack stack) {
        return stack.is(EntityDetectors.Tags.Items.MOB_DETECTOR_FILTERS);
    }

    public MobDetectorItemHandler(MobDetectorBlockEntity mobDetector) {
        this.mobDetector = mobDetector;
    }

    public int getSlots() {
        return 1;
    }

    public ItemStack getStackInSlot(int slot) {
        return this.mobDetector.getSlimeStack();
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        ItemStack existingStack = this.mobDetector.getSlimeStack();
        if (existingStack.getCount() > 0) {
            return stack.copy();
        }
        if (!simulate) {
            ItemStack newStackInInventory = stack.copy();
            newStackInInventory.setCount(1);
            this.mobDetector.setSlimeStack(newStackInInventory);
        }
        ItemStack remainder = stack.copy();
        remainder.shrink(1);
        return remainder;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        ItemStack outStack = this.mobDetector.getSlimeStack().copy();
        if (!simulate) {
            this.mobDetector.setSlimeStack(ItemStack.EMPTY);
        }
        return outStack;
    }

    public int getSlotLimit(int slot) {
        return 1;
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return MobDetectorItemHandler.isItemValidFilter(stack);
    }
}

