/*
 * Decompiled with CFR 0.152.
 */
package net.commoble.entitydetectors.registrables;

import java.util.Optional;
import javax.annotation.Nullable;
import net.commoble.entitydetectors.EntityDetectors;
import net.commoble.entitydetectors.registrables.EntityDetectorBlockEntity;
import net.commoble.entitydetectors.registrables.ImprintedSlimeballItem;
import net.commoble.entitydetectors.registrables.MobDetectorItemHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandler;

public class MobDetectorBlockEntity
extends EntityDetectorBlockEntity<Mob> {
    public static final String FILTER_KEY = "filter";
    public static final BlockEntityTicker<MobDetectorBlockEntity> TICKER = (level, pos, state, be) -> be.tick(level, pos, state);
    private ItemStack slimeStack = ItemStack.EMPTY;
    private final IItemHandler itemHandler = new MobDetectorItemHandler(this);

    public static MobDetectorBlockEntity create(BlockPos pos, BlockState state) {
        return new MobDetectorBlockEntity((BlockEntityType<?>)((BlockEntityType)EntityDetectors.MOB_DETECTOR_BET.get()), pos, state, (Class<? extends Mob>)Mob.class);
    }

    public MobDetectorBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, Class<? extends Mob> mobClass) {
        super(type, pos, state, mobClass);
    }

    public ItemStack getSlimeStack() {
        return this.slimeStack;
    }

    public void setSlimeStack(ItemStack slimeStack) {
        this.slimeStack = slimeStack;
        this.setChanged();
        this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 2);
    }

    @Override
    public boolean isEntityDetectable(Mob ent) {
        return ImprintedSlimeballItem.getEntityType(this.slimeStack).map(type -> type.value() == ent.getType()).orElse(true);
    }

    public Optional<Holder<EntityType<?>>> getFilteredEntityType() {
        return ImprintedSlimeballItem.getEntityType(this.slimeStack);
    }

    public void onRightClickWithSlime(Player player, ItemStack stack, Level level, BlockPos pos) {
        this.dropSlime(level, pos);
        ItemStack remainder = this.itemHandler.insertItem(0, stack, false);
        stack.setCount(remainder.getCount());
    }

    private void dropSlime(Level level, BlockPos pos) {
        ItemStack extractedStack;
        if (!level.isClientSide && !(extractedStack = this.itemHandler.extractItem(0, 1, false)).isEmpty()) {
            level.playSound(null, pos, SoundEvents.SLIME_SQUISH_SMALL, SoundSource.BLOCKS, 0.1f + level.random.nextFloat() * 0.3f, level.random.nextFloat() * 1.5f + 1.0f);
            double d0 = (double)(level.random.nextFloat() * 0.7f) + (double)0.15f;
            double d1 = (double)(level.random.nextFloat() * 0.7f) + 0.06000000238418579 + 0.6;
            double d2 = (double)(level.random.nextFloat() * 0.7f) + (double)0.15f;
            ItemEntity itementity = new ItemEntity(level, (double)pos.getX() + d0, (double)pos.getY() + d1, (double)pos.getZ() + d2, extractedStack.copy());
            itementity.setDefaultPickUpDelay();
            level.addFreshEntity((Entity)itementity);
        }
    }

    public IItemHandler getItemHandler(@Nullable Direction side) {
        return this.getItemHandler(side);
    }

    public void loadAdditional(CompoundTag compound, HolderLookup.Provider registries) {
        super.loadAdditional(compound, registries);
        if (compound.contains(FILTER_KEY)) {
            CompoundTag itemTag = compound.getCompound(FILTER_KEY);
            this.slimeStack = ItemStack.parseOptional((HolderLookup.Provider)registries, (CompoundTag)itemTag);
        }
    }

    public void saveAdditional(CompoundTag nbt, HolderLookup.Provider registries) {
        super.saveAdditional(nbt, registries);
        CompoundTag itemNBT = this.slimeStack.isEmpty() ? new CompoundTag() : this.slimeStack.save(registries);
        nbt.put(FILTER_KEY, (Tag)itemNBT);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveWithoutMetadata(registries);
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }
}

