/*
 * Decompiled with CFR 0.152.
 */
package net.commoble.entitydetectors.registrables;

import net.commoble.entitydetectors.EntityDetectors;
import net.commoble.entitydetectors.registrables.EntityDetectorBlock;
import net.commoble.entitydetectors.registrables.MobDetectorBlockEntity;
import net.commoble.entitydetectors.registrables.MobDetectorItemHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;

public class MobDetectorBlock
extends EntityDetectorBlock {
    public MobDetectorBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity blockEntity;
        if (MobDetectorItemHandler.isItemValidFilter(stack) && (blockEntity = world.getBlockEntity(pos)) instanceof MobDetectorBlockEntity) {
            MobDetectorBlockEntity mobDetector = (MobDetectorBlockEntity)blockEntity;
            if (!world.isClientSide) {
                mobDetector.onRightClickWithSlime(player, stack, world, pos);
            }
            return ItemInteractionResult.SUCCESS;
        }
        return super.useItemOn(stack, state, world, pos, player, hand, hit);
    }

    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity blockEntity;
        if (state.getBlock() != newState.getBlock() && (blockEntity = world.getBlockEntity(pos)) instanceof MobDetectorBlockEntity) {
            MobDetectorBlockEntity mobDetector = (MobDetectorBlockEntity)blockEntity;
            Containers.dropItemStack((Level)world, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)mobDetector.getSlimeStack());
        }
        super.onRemove(state, world, pos, newState, isMoving);
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return MobDetectorBlockEntity.create(pos, state);
    }

    @Override
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return !level.isClientSide && type == EntityDetectors.MOB_DETECTOR_BET.get() ? MobDetectorBlockEntity.TICKER : null;
    }
}

