/*
 * Decompiled with CFR 0.152.
 */
package net.commoble.entitydetectors.registrables;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import net.commoble.entitydetectors.EntityDetectors;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class ImprintedSlimeballItem
extends Item {
    public ImprintedSlimeballItem(Item.Properties properties) {
        super(properties);
    }

    public Component getName(ItemStack stack) {
        return ImprintedSlimeballItem.getEntityType(stack).map(holder -> Component.translatable((String)this.getDescriptionId()).append((Component)Component.literal((String)" (")).append((Component)Component.translatable((String)((EntityType)holder.value()).getDescriptionId())).append((Component)Component.literal((String)")"))).orElseGet(() -> super.getName(stack));
    }

    public static ItemStack createItemStackForEntityType(EntityType<?> entityType) {
        ResourceKey id = BuiltInRegistries.ENTITY_TYPE.getResourceKey(entityType).orElse(null);
        return ImprintedSlimeballItem.createItemStackForEntityType(id);
    }

    public static ItemStack createItemStackForEntityType(ResourceKey<EntityType<?>> id) {
        ItemStack stack = new ItemStack((ItemLike)EntityDetectors.IMPRINTED_SLIME_BALL.get());
        if (id != null) {
            BuiltInRegistries.ENTITY_TYPE.getHolder(id).ifPresent(holder -> stack.set((DataComponentType)EntityDetectors.IMPRINTED_ENTITY.get(), holder));
        }
        return stack;
    }

    public static Optional<Holder<EntityType<?>>> getEntityType(ItemStack stack) {
        if (stack.getCount() < 0) {
            return Optional.empty();
        }
        return Optional.ofNullable((Holder)stack.get(EntityDetectors.IMPRINTED_ENTITY));
    }

    public Collection<ItemStack> getVariants() {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        BuiltInRegistries.ENTITY_TYPE.holders().filter(holder -> ImprintedSlimeballItem.isEntityTypeValid((EntityType)holder.value())).forEachOrdered(holder -> items.add(ImprintedSlimeballItem.createItemStackForEntityType(holder.key())));
        return items;
    }

    public static boolean isEntityTypeValid(EntityType<?> entityType) {
        return entityType.getCategory() != MobCategory.MISC;
    }
}

