/*
 * Decompiled with CFR 0.152.
 */
package net.commoble.entitydetectors.registrables;

import net.commoble.entitydetectors.EntityDetectors;
import net.commoble.entitydetectors.registrables.EntityDetectorBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;

public abstract class EntityDetectorBlockEntity<ENTITY extends Entity>
extends BlockEntity {
    public static final AABB BOX = Shapes.block().bounds();
    private final Class<? extends ENTITY> entityClass;

    public EntityDetectorBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, Class<? extends ENTITY> entityClass) {
        super(type, pos, state);
        this.entityClass = entityClass;
    }

    public abstract boolean isEntityDetectable(ENTITY var1);

    public void onUpdate() {
        BlockState actualState = this.getBlockState();
        if (actualState.hasProperty((Property)EntityDetectorBlock.LEVEL) && actualState.hasProperty((Property)EntityDetectorBlock.POWERED)) {
            Vec3 center;
            boolean areEntitiesNear;
            BlockPos pos = this.worldPosition;
            int detectionLevel = (Integer)actualState.getValue((Property)EntityDetectorBlock.LEVEL);
            double radius = 2.0 * Math.pow(2.0, detectionLevel);
            double radiusSquared = radius * radius;
            AABB aabb = BOX.move(pos).inflate(radius);
            boolean bl = areEntitiesNear = !this.level.getEntitiesOfClass(this.entityClass, aabb, arg_0 -> this.lambda$onUpdate$0(center = new Vec3((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5), radiusSquared, arg_0)).isEmpty();
            if (areEntitiesNear != (Boolean)actualState.getValue((Property)EntityDetectorBlock.POWERED)) {
                this.level.setBlock(pos, (BlockState)actualState.setValue((Property)EntityDetectorBlock.POWERED, (Comparable)Boolean.valueOf(areEntitiesNear)), 3);
            }
        }
    }

    protected void tick(Level level, BlockPos pos, BlockState state) {
        if (level.getGameTime() % (long)((Integer)EntityDetectors.COMMON_CONFIG.refreshRate().get()).intValue() == 0L) {
            this.onUpdate();
        }
    }

    private /* synthetic */ boolean lambda$onUpdate$0(Vec3 center, double radiusSquared, Entity entity) {
        return this.isEntityDetectable(entity) && entity.distanceToSqr(center) < radiusSquared;
    }
}

