/*
 * Decompiled with CFR 0.152.
 */
package net.commoble.entitydetectors.registrables;

import net.commoble.entitydetectors.registrables.EntityDetectorBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public abstract class EntityDetectorBlock
extends Block
implements EntityBlock {
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    public static final IntegerProperty LEVEL = IntegerProperty.create((String)"level", (int)0, (int)3);

    public EntityDetectorBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)POWERED, (Comparable)Boolean.valueOf(false))).setValue((Property)LEVEL, (Comparable)Integer.valueOf(0)));
    }

    public abstract <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level var1, BlockState var2, BlockEntityType<T> var3);

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{POWERED, LEVEL});
    }

    public static int getLightValue(BlockState state) {
        return (Boolean)state.getValue((Property)POWERED) != false ? 7 : 0;
    }

    public boolean isSignalSource(BlockState state) {
        return true;
    }

    public int getDirectSignal(BlockState blockState, BlockGetter blockAccess, BlockPos pos, Direction side) {
        return blockState.getSignal(blockAccess, pos, side);
    }

    public int getSignal(BlockState blockState, BlockGetter blockAccess, BlockPos pos, Direction side) {
        return (Boolean)blockState.getValue((Property)POWERED) != false ? 15 : 0;
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        if (state.hasProperty((Property)LEVEL)) {
            int oldLevel = (Integer)state.getValue((Property)LEVEL);
            int newLevel = (oldLevel + 1) % 4;
            level.setBlock(pos, (BlockState)state.setValue((Property)LEVEL, (Comparable)Integer.valueOf(newLevel)), 3);
            this.onUpdate(state, level, pos);
            float volume = 0.25f + level.random.nextFloat() * 0.1f;
            float pitch = 0.5f + level.random.nextFloat() * 0.1f;
            level.playSound(player, pos, SoundEvents.STONE_BUTTON_CLICK_ON, SoundSource.BLOCKS, volume, pitch);
            return InteractionResult.SUCCESS;
        }
        return super.useWithoutItem(state, level, pos, player, hit);
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (state.getBlock() != oldState.getBlock()) {
            this.onUpdate(state, level, pos);
        }
    }

    public void onUpdate(BlockState state, Level level, BlockPos pos) {
        BlockEntity blockEntity;
        if (!level.isClientSide && (blockEntity = level.getBlockEntity(pos)) instanceof EntityDetectorBlockEntity) {
            EntityDetectorBlockEntity entityDetector = (EntityDetectorBlockEntity)blockEntity;
            entityDetector.onUpdate();
        }
    }
}

