/*
 * Decompiled with CFR 0.152.
 */
package net.commoble.entitydetectors.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.commoble.entitydetectors.client.FakeClientEntities;
import net.commoble.entitydetectors.registrables.MobDetectorBlockEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class MobDetectorBlockEntityRenderer
implements BlockEntityRenderer<MobDetectorBlockEntity> {
    private static final float DEGREES_PER_ROTATION = 360.0f;
    private static final float ROTATIONS_PER_SECOND = 0.5f;
    private static final float SECONDS_PER_TICK = 0.05f;
    private static final float DEGREES_PER_TICK = 9.0f;
    private static final double MIN_RENDER_DISTANCE = 2.0;
    private static final double MAX_RENDER_DISTANCE = 5.0;
    private static final double MIN_RENDER_DISTANCE_SQ = 4.0;
    private static final double MAX_RENDER_DISTANCE_SQ = 25.0;
    private static final double DISTANCE_DIFF = 21.0;

    public MobDetectorBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(MobDetectorBlockEntity be, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int lightUV, int overlayUV) {
        LocalPlayer player = Minecraft.getInstance().player;
        Level level = be.getLevel();
        if (player != null && level.isEmptyBlock(be.getBlockPos().above())) {
            FakeClientEntities.getOptionalFakeEntity(be.getFilteredEntityType(), level).ifPresent(entity -> this.renderFakeEntity(be, player, (Entity)entity, partialTicks, poseStack, buffer, lightUV));
        }
    }

    public void renderFakeEntity(MobDetectorBlockEntity be, LocalPlayer player, Entity entity, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int lightUV) {
        BlockPos pos = be.getBlockPos();
        double teX = (double)pos.getX() + 0.5;
        double teY = (double)pos.getY() + 0.5;
        double teZ = (double)pos.getZ() + 0.5;
        Vec3 vel = player.getDeltaMovement();
        double extraX = vel.x * (double)partialTicks;
        double extraY = vel.y * (double)partialTicks;
        double extraZ = vel.z * (double)partialTicks;
        double playerDistanceSq = player.distanceToSqr(teX - extraX, teY - extraY, teZ - extraZ);
        if (playerDistanceSq < 25.0) {
            double distFactor = 1.0 - Math.min(playerDistanceSq - 4.0, 21.0) / 21.0;
            long gameTicks = be.getLevel().getGameTime();
            float renderTicks = (float)gameTicks + partialTicks;
            float rotation = renderTicks * 9.0f % 360.0f;
            poseStack.pushPose();
            float entityScale = 0.53125f;
            entityScale = (float)((double)entityScale * ((double)0.8f * distFactor));
            float scaleDivisor = Math.max(entity.getBbWidth(), entity.getBbHeight());
            if ((double)scaleDivisor > 1.0) {
                entityScale /= scaleDivisor;
            }
            EntityRenderDispatcher renderManager = Minecraft.getInstance().getEntityRenderDispatcher();
            renderManager.setRenderShadow(false);
            entity.setPos(teX, teY, teZ);
            poseStack.translate(0.5, 1.0, 0.5);
            poseStack.mulPose(Axis.YP.rotationDegrees(rotation));
            poseStack.scale(entityScale, entityScale, entityScale);
            renderManager.render(entity, 0.0, 0.0, 0.0, 0.0f, partialTicks, poseStack, buffer, 0xFFFFFF);
            renderManager.setRenderShadow(true);
            poseStack.popPose();
        }
    }
}

