/*
 * Decompiled with CFR 0.152.
 */
package net.commoble.entitydetectors.client;

import java.util.Optional;
import net.commoble.entitydetectors.EntityDetectors;
import net.commoble.entitydetectors.client.MobDetectorBlockEntityRenderer;
import net.commoble.entitydetectors.registrables.ImprintedSlimeballItem;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;

public class ClientProxy {
    public static void subscribeClientEvents(IEventBus modBus, IEventBus forgeBus) {
        modBus.addListener(ClientProxy::onRegisterEntityRenderers);
        modBus.addListener(ClientProxy::onRegisterItemColors);
    }

    private static void onRegisterEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer((BlockEntityType)EntityDetectors.MOB_DETECTOR_BET.get(), MobDetectorBlockEntityRenderer::new);
    }

    private static void onRegisterItemColors(RegisterColorHandlersEvent.Item event) {
        event.register(ClientProxy::getImprintedSlimeballColor, new ItemLike[]{(ItemLike)EntityDetectors.IMPRINTED_SLIME_BALL.get()});
    }

    private static int getImprintedSlimeballColor(ItemStack stack, int tintIndex) {
        return ImprintedSlimeballItem.getEntityType(stack).flatMap(holder -> Optional.ofNullable(SpawnEggItem.byId((EntityType)((EntityType)holder.value())))).map(egg -> FastColor.ARGB32.opaque((int)egg.getColor(tintIndex))).orElse(-1);
    }
}

