/*
 * Decompiled with CFR 0.152.
 */
package net.commoble.entitydetectors;

import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import net.commoble.entitydetectors.CommonConfig;
import net.commoble.entitydetectors.ConfigHelper;
import net.commoble.entitydetectors.client.ClientProxy;
import net.commoble.entitydetectors.registrables.EntityDetectorBlock;
import net.commoble.entitydetectors.registrables.ImprintedSlimeballItem;
import net.commoble.entitydetectors.registrables.MobDetectorBlock;
import net.commoble.entitydetectors.registrables.MobDetectorBlockEntity;
import net.commoble.entitydetectors.registrables.PlayerDetectorBlock;
import net.commoble.entitydetectors.registrables.PlayerDetectorBlockEntity;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.AttackEntityEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

@Mod(value="entitydetectors")
public class EntityDetectors {
    public static final String MODID = "entitydetectors";
    public static final CommonConfig COMMON_CONFIG = ConfigHelper.register("entitydetectors", ModConfig.Type.COMMON, CommonConfig::create);
    private static final DeferredRegister<Block> BLOCKS = EntityDetectors.defreg(Registries.BLOCK);
    private static final DeferredRegister<Item> ITEMS = EntityDetectors.defreg(Registries.ITEM);
    private static final DeferredRegister<CreativeModeTab> TABS = EntityDetectors.defreg(Registries.CREATIVE_MODE_TAB);
    private static final DeferredRegister<BlockEntityType<?>> BETS = EntityDetectors.defreg(Registries.BLOCK_ENTITY_TYPE);
    private static final DeferredRegister<DataComponentType<?>> DATA_COMPONENTS = EntityDetectors.defreg(Registries.DATA_COMPONENT_TYPE);
    public static final DeferredHolder<Block, EntityDetectorBlock> PLAYER_DETECTOR = EntityDetectors.registerBlockItem("player_detector", BLOCKS, ITEMS, () -> BlockBehaviour.Properties.of().strength(3.0f).lightLevel(EntityDetectorBlock::getLightValue).noOcclusion(), PlayerDetectorBlock::new);
    public static final DeferredHolder<Block, MobDetectorBlock> MOB_DETECTOR = EntityDetectors.registerBlockItem("mob_detector", BLOCKS, ITEMS, () -> BlockBehaviour.Properties.of().strength(3.0f).lightLevel(EntityDetectorBlock::getLightValue).noOcclusion(), MobDetectorBlock::new);
    public static final DeferredHolder<Item, ImprintedSlimeballItem> IMPRINTED_SLIME_BALL = EntityDetectors.registerItem("imprinted_slime_ball", ITEMS, ImprintedSlimeballItem::new);
    public static final DeferredHolder<CreativeModeTab, CreativeModeTab> TAB = TABS.register("entitydetectors", () -> CreativeModeTab.builder().icon(() -> new ItemStack((ItemLike)MOB_DETECTOR.get())).title((Component)Component.translatable((String)"itemGroup.entitydetectors")).displayItems((params, output) -> {
        output.accept((ItemLike)PLAYER_DETECTOR.get());
        output.accept((ItemLike)MOB_DETECTOR.get());
        output.acceptAll(((ImprintedSlimeballItem)((Object)((Object)((Object)IMPRINTED_SLIME_BALL.get())))).getVariants());
    }).build());
    public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<PlayerDetectorBlockEntity>> PLAYER_DETECTOR_BET = BETS.register("player_detector", () -> BlockEntityType.Builder.of(PlayerDetectorBlockEntity::create, (Block[])new Block[]{(Block)PLAYER_DETECTOR.get()}).build(null));
    public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<MobDetectorBlockEntity>> MOB_DETECTOR_BET = BETS.register("mob_detector", () -> BlockEntityType.Builder.of(MobDetectorBlockEntity::create, (Block[])new Block[]{(Block)MOB_DETECTOR.get()}).build(null));
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Holder<EntityType<?>>>> IMPRINTED_ENTITY = DATA_COMPONENTS.register("imprinted_entity", () -> DataComponentType.builder().persistent(BuiltInRegistries.ENTITY_TYPE.holderByNameCodec()).networkSynchronized(ByteBufCodecs.holderRegistry((ResourceKey)Registries.ENTITY_TYPE)).build());

    public EntityDetectors(IEventBus modBus) {
        IEventBus forgeBus = NeoForge.EVENT_BUS;
        forgeBus.addListener(EntityDetectors::onPlayerInteractWithEntity);
        forgeBus.addListener(EntityDetectors::onPlayerAttackEntity);
        if (FMLEnvironment.dist == Dist.CLIENT) {
            ClientProxy.subscribeClientEvents(modBus, forgeBus);
        }
    }

    public static void onPlayerInteractWithEntity(PlayerInteractEvent.EntityInteract event) {
        Player player = event.getEntity();
        ItemStack oldStack = event.getItemStack();
        EntityType entityType = event.getTarget().getType();
        if (player.isCrouching() && EntityDetectors.onPlayerAttackedOrInteractedWithEntity(player, oldStack, entityType)) {
            event.setCanceled(true);
            event.setCancellationResult(InteractionResult.SUCCESS);
        }
    }

    public static void onPlayerAttackEntity(AttackEntityEvent event) {
        Player player = event.getEntity();
        ItemStack oldStack = player.getMainHandItem();
        EntityType entityType = event.getTarget().getType();
        EntityDetectors.onPlayerAttackedOrInteractedWithEntity(player, oldStack, entityType);
    }

    public static boolean onPlayerAttackedOrInteractedWithEntity(Player player, ItemStack oldStack, EntityType<?> entityType) {
        if (oldStack.is(Tags.Items.IMPRINTABLE) && ImprintedSlimeballItem.isEntityTypeValid(entityType)) {
            if (!player.level().isClientSide) {
                oldStack.shrink(1);
                ItemStack newSlimeStack = ImprintedSlimeballItem.createItemStackForEntityType(entityType);
                if (!player.addItem(newSlimeStack)) {
                    player.drop(newSlimeStack, false);
                }
            }
            return true;
        }
        return false;
    }

    private static <T> DeferredRegister<T> defreg(ResourceKey<Registry<T>> key) {
        DeferredRegister defreg = DeferredRegister.create(key, (String)MODID);
        defreg.register(((ModContainer)ModList.get().getModContainerById(MODID).get()).getEventBus());
        return defreg;
    }

    private static <BLOCK extends Block, ITEM extends BlockItem> DeferredHolder<Block, BLOCK> registerBlockItem(String name, DeferredRegister<Block> blocks, DeferredRegister<Item> items, Supplier<BlockBehaviour.Properties> blockProperties, Function<BlockBehaviour.Properties, BLOCK> blockFactory, Supplier<Item.Properties> itemProperties, BiFunction<? super BLOCK, Item.Properties, ITEM> itemFactory) {
        DeferredHolder blockHolder = blocks.register(name, () -> (Block)blockFactory.apply((BlockBehaviour.Properties)blockProperties.get()));
        items.register(name, () -> (BlockItem)itemFactory.apply((Object)blockHolder.get(), (Item.Properties)itemProperties.get()));
        return blockHolder;
    }

    private static <BLOCK extends Block, ITEM extends BlockItem> DeferredHolder<Block, BLOCK> registerBlockItem(String name, DeferredRegister<Block> blocks, DeferredRegister<Item> items, Supplier<BlockBehaviour.Properties> blockProperties, Function<BlockBehaviour.Properties, BLOCK> blockFactory) {
        return EntityDetectors.registerBlockItem(name, blocks, items, blockProperties, blockFactory, Item.Properties::new, BlockItem::new);
    }

    private static <ITEM extends Item> DeferredHolder<Item, ITEM> registerItem(String name, DeferredRegister<Item> items, Supplier<Item.Properties> itemProperties, Function<Item.Properties, ITEM> itemFactory) {
        return items.register(name, () -> (Item)itemFactory.apply((Item.Properties)itemProperties.get()));
    }

    private static <ITEM extends Item> DeferredHolder<Item, ITEM> registerItem(String name, DeferredRegister<Item> items, Function<Item.Properties, ITEM> itemFactory) {
        return EntityDetectors.registerItem(name, items, Item.Properties::new, itemFactory);
    }

    public static ResourceLocation id(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)path);
    }

    public static final class Tags {
        private Tags() {
        }

        public static final class Items {
            public static final TagKey<Item> MOB_DETECTOR_FILTERS = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)EntityDetectors.id("mob_detector_filters"));
            public static final TagKey<Item> IMPRINTABLE = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)EntityDetectors.id("imprintable"));

            private Items() {
            }
        }
    }
}

