/*
 * Decompiled with CFR 0.152.
 */
package toni.sodiumdynamiclights;

import java.util.Arrays;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public enum DynamicLightsMode {
    OFF(0, ChatFormatting.RED, "OFF"),
    SLOW(500, ChatFormatting.YELLOW, "SLOW"),
    FAST(250, ChatFormatting.GOLD, "FAST"),
    REALTIME(0, ChatFormatting.GREEN, "REALTIME");

    private final int delay;
    private final Component translatedText;

    private DynamicLightsMode(@NotNull int delay, ChatFormatting formatting, String translatedText) {
        this.delay = delay;
        this.translatedText = Component.literal((String)translatedText).copy().withStyle(formatting);
    }

    public boolean isEnabled() {
        return this != OFF;
    }

    public boolean hasDelay() {
        return this.delay != 0;
    }

    public int getDelay() {
        return this.delay;
    }

    public DynamicLightsMode next() {
        DynamicLightsMode[] v = DynamicLightsMode.values();
        if (v.length == this.ordinal() + 1) {
            return v[0];
        }
        return v[this.ordinal() + 1];
    }

    @NotNull
    public Component getTranslatedText() {
        return this.translatedText;
    }

    @NotNull
    public static Optional<DynamicLightsMode> byId(@NotNull String id) {
        return Arrays.stream(DynamicLightsMode.values()).filter(mode -> mode.getName().equalsIgnoreCase(id)).findFirst();
    }

    @NotNull
    public String getName() {
        return this.name().toLowerCase();
    }
}

