/*
 * Decompiled with CFR 0.152.
 */
package ianm1647.expandeddelight.common.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import ianm1647.expandeddelight.client.recipebook.JuicerRecipeBookTab;
import ianm1647.expandeddelight.common.registry.EDItems;
import ianm1647.expandeddelight.common.registry.EDRecipeSerializers;
import ianm1647.expandeddelight.common.registry.EDRecipeTypes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.util.RecipeMatcher;
import net.neoforged.neoforge.items.wrapper.RecipeWrapper;

public class JuicerRecipe
implements Recipe<RecipeWrapper> {
    public static final int INPUT_SLOTS = 2;
    private final String group;
    private final JuicerRecipeBookTab tab;
    private final NonNullList<Ingredient> inputItems;
    private final ItemStack output;
    private final ItemStack container;
    private final ItemStack containerOverride;
    private final float experience;
    private final int juiceTime;

    public JuicerRecipe(String group, @Nullable JuicerRecipeBookTab tab, NonNullList<Ingredient> inputItems, ItemStack output, ItemStack container, float experience, int juiceTime) {
        this.group = group;
        this.tab = tab;
        this.inputItems = inputItems;
        this.output = output;
        this.container = !container.isEmpty() ? container : (!output.getCraftingRemainingItem().isEmpty() ? output.getCraftingRemainingItem() : ItemStack.EMPTY);
        this.containerOverride = container;
        this.experience = experience;
        this.juiceTime = juiceTime;
    }

    public String getGroup() {
        return this.group;
    }

    @Nullable
    public JuicerRecipeBookTab getRecipeBookTab() {
        return this.tab;
    }

    public NonNullList<Ingredient> getIngredients() {
        return this.inputItems;
    }

    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return this.output;
    }

    public ItemStack getOutputContainer() {
        return this.container;
    }

    public ItemStack getContainerOverride() {
        return this.containerOverride;
    }

    public ItemStack assemble(RecipeWrapper inv, HolderLookup.Provider provider) {
        return this.output.copy();
    }

    public float getExperience() {
        return this.experience;
    }

    public int getJuiceTime() {
        return this.juiceTime;
    }

    public boolean matches(RecipeWrapper inv, Level level) {
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
        int i = 0;
        for (int j = 0; j < 2; ++j) {
            ItemStack itemstack = inv.getItem(j);
            if (itemstack.isEmpty()) continue;
            ++i;
            inputs.add(itemstack);
        }
        return i == this.inputItems.size() && RecipeMatcher.findMatches(inputs, this.inputItems) != null;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= this.inputItems.size();
    }

    public RecipeSerializer<?> getSerializer() {
        return EDRecipeSerializers.JUICING.get();
    }

    public RecipeType<?> getType() {
        return EDRecipeTypes.JUICING.get();
    }

    public ItemStack getToastSymbol() {
        return new ItemStack((ItemLike)EDItems.JUICER.get());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            JuicerRecipe that = (JuicerRecipe)o;
            if (Float.compare(that.getExperience(), this.getExperience()) != 0) {
                return false;
            }
            if (this.getJuiceTime() != that.getJuiceTime()) {
                return false;
            }
            if (!this.getGroup().equals(that.getGroup())) {
                return false;
            }
            if (this.tab != that.tab) {
                return false;
            }
            if (!this.inputItems.equals(that.inputItems)) {
                return false;
            }
            return this.output.equals(that.output) && this.container.equals(that.container);
        }
        return false;
    }

    public int hashCode() {
        int result = this.getGroup().hashCode();
        result = 31 * result + (this.getRecipeBookTab() != null ? this.getRecipeBookTab().hashCode() : 0);
        result = 31 * result + this.inputItems.hashCode();
        result = 31 * result + this.output.hashCode();
        result = 31 * result + this.container.hashCode();
        result = 31 * result + (this.getExperience() != 0.0f ? Float.floatToIntBits(this.getExperience()) : 0);
        result = 31 * result + this.getJuiceTime();
        return result;
    }

    public static class Serializer
    implements RecipeSerializer<JuicerRecipe> {
        private static final MapCodec<JuicerRecipe> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(JuicerRecipe::getGroup), (App)JuicerRecipeBookTab.CODEC.optionalFieldOf("recipe_book_tab").xmap(optional -> optional.orElse(JuicerRecipeBookTab.MISC), Optional::of).forGetter(JuicerRecipe::getRecipeBookTab), (App)Ingredient.LIST_CODEC_NONEMPTY.fieldOf("ingredients").xmap(ingredients -> {
            NonNullList nonNullList = NonNullList.create();
            nonNullList.addAll((Collection)ingredients);
            return nonNullList;
        }, ingredients -> ingredients).forGetter(JuicerRecipe::getIngredients), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(r -> r.output), (App)ItemStack.STRICT_CODEC.optionalFieldOf("container", (Object)ItemStack.EMPTY).forGetter(JuicerRecipe::getContainerOverride), (App)Codec.FLOAT.optionalFieldOf("experience", (Object)Float.valueOf(0.0f)).forGetter(JuicerRecipe::getExperience), (App)Codec.INT.optionalFieldOf("juicingtime", (Object)200).forGetter(JuicerRecipe::getJuiceTime)).apply((Applicative)inst, JuicerRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, JuicerRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<JuicerRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, JuicerRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        private static JuicerRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
            String groupIn = buffer.readUtf();
            JuicerRecipeBookTab tabIn = JuicerRecipeBookTab.findByName(buffer.readUtf());
            int i = buffer.readVarInt();
            NonNullList inputItemsIn = NonNullList.withSize((int)i, (Object)Ingredient.EMPTY);
            inputItemsIn.replaceAll(ignored -> (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer));
            ItemStack outputIn = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer);
            ItemStack container = (ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode((Object)buffer);
            float experienceIn = buffer.readFloat();
            int cookTimeIn = buffer.readVarInt();
            return new JuicerRecipe(groupIn, tabIn, (NonNullList<Ingredient>)inputItemsIn, outputIn, container, experienceIn, cookTimeIn);
        }

        private static void toNetwork(RegistryFriendlyByteBuf buffer, JuicerRecipe recipe) {
            buffer.writeUtf(recipe.group);
            buffer.writeUtf(recipe.tab != null ? recipe.tab.toString() : "");
            buffer.writeVarInt(recipe.inputItems.size());
            for (Ingredient ingredient : recipe.inputItems) {
                Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)ingredient);
            }
            ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.output);
            ItemStack.OPTIONAL_STREAM_CODEC.encode((Object)buffer, (Object)recipe.container);
            buffer.writeFloat(recipe.experience);
            buffer.writeVarInt(recipe.juiceTime);
        }
    }
}

