/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.util.predicates;

import com.google.common.base.Suppliers;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Encoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.critereon.BlockPredicate;
import net.minecraft.advancements.critereon.NbtPredicate;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.commands.arguments.blocks.BlockStateParser;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.StateHolder;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import snownee.jade.api.theme.IThemeHelper;
import snownee.jade.util.ModIdentification;
import snownee.lychee.compat.recipeviewer.RvHelper;
import snownee.lychee.context.LootParamsContext;
import snownee.lychee.util.ClientProxy;
import snownee.lychee.util.context.LycheeContext;
import snownee.lychee.util.context.LycheeContextKey;
import snownee.lychee.util.predicates.PropertiesPredicateExtensions;

public class BlockPredicateExtensions {
    public static final BlockPredicate ANY = new BlockPredicate(Optional.empty(), Optional.empty(), Optional.empty());
    private static final Cache<BlockPredicate, List<BlockState>> CACHE = CacheBuilder.newBuilder().expireAfterAccess(10L, TimeUnit.MINUTES).build();
    public static final Set<Property<?>> ITERABLE_PROPERTIES = Sets.newConcurrentHashSet(List.of(BlockStateProperties.AGE_1, BlockStateProperties.AGE_2, BlockStateProperties.AGE_3, BlockStateProperties.AGE_5, BlockStateProperties.AGE_7, BlockStateProperties.CANDLES, BlockStateProperties.BITES, BlockStateProperties.POWER, BlockStateProperties.POWERED, BlockStateProperties.LIT, BlockStateProperties.BERRIES, BlockStateProperties.OPEN, BlockStateProperties.DELAY, BlockStateProperties.DISTANCE, BlockStateProperties.LAYERS, BlockStateProperties.PICKLES, BlockStateProperties.LEVEL, BlockStateProperties.LEVEL_HONEY, BlockStateProperties.LEVEL_CAULDRON, BlockStateProperties.DRIPSTONE_THICKNESS));
    public static final Codec<BlockPredicate> CODEC_FOR_TESTING = BlockPredicateExtensions.codec(true);
    public static final Codec<BlockPredicate> CODEC = BlockPredicateExtensions.codec(false);

    public static DataResult<BlockPredicate> fromString(String s, boolean forTesting) {
        Either result;
        if ("*".equals(s)) {
            return DataResult.success((Object)ANY);
        }
        try {
            result = forTesting ? BlockStateParser.parseForTesting((HolderLookup)BuiltInRegistries.BLOCK.asLookup(), (String)s, (boolean)true) : Either.left((Object)BlockStateParser.parseForBlock((HolderLookup)BuiltInRegistries.BLOCK.asLookup(), (String)s, (boolean)true));
        }
        catch (Exception e) {
            return DataResult.error(() -> "Invalid block predicate: %s - %s".formatted(s, e.getMessage()));
        }
        return DataResult.success((Object)((BlockPredicate)result.map($ -> new BlockPredicate(Optional.of(HolderSet.direct((Holder[])new Holder[]{$.blockState().getBlockHolder()})), $.properties().isEmpty() ? Optional.empty() : Optional.of(new StatePropertiesPredicate($.properties().entrySet().stream().map(it -> new StatePropertiesPredicate.PropertyMatcher(((Property)it.getKey()).getName(), (StatePropertiesPredicate.ValueMatcher)new StatePropertiesPredicate.ExactMatcher(BlockPredicateExtensions.getNameByValue((Property)it.getKey(), it.getValue())))).toList())), Optional.ofNullable($.nbt()).map(NbtPredicate::new)), $ -> new BlockPredicate(Optional.of($.tag()), $.vagueProperties().isEmpty() ? Optional.empty() : Optional.of(new StatePropertiesPredicate($.vagueProperties().entrySet().stream().map(it -> new StatePropertiesPredicate.PropertyMatcher((String)it.getKey(), (StatePropertiesPredicate.ValueMatcher)new StatePropertiesPredicate.ExactMatcher((String)it.getValue()))).toList())), Optional.ofNullable($.nbt()).map(NbtPredicate::new)))));
    }

    private static <T extends Comparable<T>> String getNameByValue(Property<T> property, Object value) {
        return property.getName((Comparable)value);
    }

    private static Codec<BlockPredicate> codec(final boolean forTesting) {
        return Codec.of((Encoder)BlockPredicate.CODEC, (Decoder)new Decoder<BlockPredicate>(){

            public <T> DataResult<Pair<BlockPredicate, T>> decode(DynamicOps<T> ops, T input) {
                DataResult stringValue = ops.getStringValue(input);
                if (stringValue.result().isPresent()) {
                    return BlockPredicateExtensions.fromString((String)stringValue.getOrThrow(), forTesting).flatMap(it -> DataResult.success((Object)Pair.of((Object)it, (Object)ops.empty())));
                }
                DataResult result = BlockPredicate.CODEC.decode(ops, input);
                if (result.result().isPresent() && BlockPredicateExtensions.isAny((BlockPredicate)((Pair)result.getOrThrow()).getFirst())) {
                    return DataResult.error(() -> "Wildcard BlockPredicate must be \"*\" string, but found " + String.valueOf(input));
                }
                return result;
            }
        });
    }

    public static boolean isAny(BlockPredicate predicate) {
        if (predicate == ANY) {
            return true;
        }
        return predicate.blocks().isEmpty() && predicate.properties().isEmpty() && predicate.nbt().isEmpty();
    }

    public static Set<Block> matchedBlocks(BlockPredicate predicate) {
        if (BlockPredicateExtensions.isAny(predicate)) {
            return Set.of();
        }
        ArrayList blocks = Lists.newArrayList();
        if (predicate.blocks().isPresent()) {
            Iterables.addAll((Collection)blocks, (Iterable)((Iterable)((HolderSet)predicate.blocks().get()).unwrap().map(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.BLOCK).getOrCreateTag(arg_0), Function.identity())));
        }
        return blocks.stream().map(Holder::value).collect(Collectors.toSet());
    }

    public static Set<Fluid> matchedFluids(BlockPredicate predicate) {
        return BlockPredicateExtensions.matchedBlocks(predicate).stream().filter(LiquidBlock.class::isInstance).map(it -> it.defaultBlockState().getFluidState()).filter(Predicate.not(FluidState::isEmpty)).map(FluidState::getType).collect(Collectors.toSet());
    }

    public static List<ItemStack> matchedItemStacks(BlockPredicate predicate) {
        if (BlockPredicateExtensions.isAny(predicate)) {
            return List.of();
        }
        return BlockPredicateExtensions.matchedBlocks(predicate).stream().map(Block::asItem).filter(Predicate.not(Items.AIR::equals)).distinct().map(Item::getDefaultInstance).toList();
    }

    public static boolean matches(BlockPredicate predicate, LycheeContext context) {
        LootParamsContext lootParams = context.get(LycheeContextKey.LOOT_PARAMS);
        return BlockPredicateExtensions.unsafeMatches(context.level(), predicate, (BlockState)lootParams.get(LootContextParams.BLOCK_STATE), () -> (BlockEntity)lootParams.getOrNull(LootContextParams.BLOCK_ENTITY));
    }

    public static boolean unsafeMatches(Level level, BlockPredicate predicate, BlockState state, Supplier<BlockEntity> blockEntitySupplier) {
        if (predicate.blocks().isPresent() && !state.is((HolderSet)predicate.blocks().get())) {
            return false;
        }
        if (predicate.properties().isPresent() && !((StatePropertiesPredicate)predicate.properties().get()).matches(state)) {
            return false;
        }
        if (predicate.nbt().isPresent()) {
            BlockEntity blockEntity = blockEntitySupplier.get();
            return blockEntity != null && ((NbtPredicate)predicate.nbt().get()).matches((Tag)blockEntity.saveWithFullMetadata((HolderLookup.Provider)level.registryAccess()));
        }
        return true;
    }

    public static BlockState anyBlockState(BlockPredicate predicate) {
        return BlockPredicateExtensions.getShowcaseBlockStates(predicate).stream().findFirst().orElse(Blocks.AIR.defaultBlockState());
    }

    public static List<BlockState> getShowcaseBlockStates(BlockPredicate predicate) {
        if (BlockPredicateExtensions.isAny(predicate)) {
            return List.of();
        }
        try {
            return (List)CACHE.get((Object)predicate, () -> BlockPredicateExtensions.getShowcaseBlockStates(predicate, ITERABLE_PROPERTIES));
        }
        catch (ExecutionException e) {
            return List.of();
        }
    }

    public static List<BlockState> getShowcaseBlockStates(BlockPredicate predicate, Collection<Property<?>> iterableProperties) {
        Set<Block> blocks = BlockPredicateExtensions.matchedBlocks(predicate);
        if (blocks.isEmpty()) {
            return List.of();
        }
        ArrayList states = Lists.newArrayList();
        for (Block block : blocks) {
            BlockState state = block.defaultBlockState();
            ArrayListMultimap propertyMap = ArrayListMultimap.create();
            for (Property property : block.getStateDefinition().getProperties()) {
                String name = property.getName();
                Optional matcher = predicate.properties().flatMap(it -> PropertiesPredicateExtensions.findMatcher(it, name));
                if (matcher.isPresent()) {
                    for (Comparable object : property.getPossibleValues()) {
                        if (!((StatePropertiesPredicate.PropertyMatcher)matcher.get()).match(block.getStateDefinition(), (StateHolder)((BlockState)state.trySetValue(property, object)))) continue;
                        propertyMap.put((Object)property, (Object)object);
                    }
                    continue;
                }
                if (!iterableProperties.contains(property)) continue;
                propertyMap.putAll((Object)property, (Iterable)property.getPossibleValues());
            }
            Stream<Object> stream = Stream.of(state);
            for (Map.Entry e : propertyMap.asMap().entrySet()) {
                stream = stream.flatMap($ -> ((Collection)e.getValue()).stream().map(v -> (BlockState)$.trySetValue((Property)e.getKey(), v)));
            }
            states.addAll(stream.toList());
        }
        return states;
    }

    public static List<Component> getTooltips(BlockState blockState, BlockPredicate predicate, RvHelper helper) {
        return BlockPredicateExtensions.getTooltips(blockState, predicate, helper.appendModName());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<Component> getTooltips(BlockState blockState, BlockPredicate predicate, boolean appendModName) {
        if (BlockPredicateExtensions.isAny(predicate)) {
            if (blockState.isAir()) {
                return List.of(Component.translatable((String)"tip.lychee.anyBlock"));
            }
            return List.of();
        }
        ArrayList list = Lists.newArrayList((Object[])new Component[]{blockState.getBlock().getName()});
        Optional<List> matchers = predicate.properties().map(StatePropertiesPredicate::properties);
        if (matchers.isPresent()) {
            for (StatePropertiesPredicate.PropertyMatcher matcher : matchers.get()) {
                MutableComponent name = Component.literal((String)(matcher.name() + "=")).withStyle(ChatFormatting.GRAY);
                StatePropertiesPredicate.ValueMatcher valueMatcher = matcher.valueMatcher();
                if (valueMatcher instanceof StatePropertiesPredicate.ExactMatcher) {
                    String value;
                    StatePropertiesPredicate.ExactMatcher exactMatcher = (StatePropertiesPredicate.ExactMatcher)valueMatcher;
                    try {
                        var14_15 = exactMatcher.value();
                        value = var14_15;
                    }
                    catch (Throwable throwable) {
                        throw new MatchException(throwable.toString(), throwable);
                    }
                    name.append((Component)Component.literal((String)value).withStyle(ChatFormatting.WHITE));
                } else {
                    valueMatcher = matcher.valueMatcher();
                    if (valueMatcher instanceof StatePropertiesPredicate.RangedMatcher) {
                        Object maxValue;
                        Object minValue;
                        StatePropertiesPredicate.RangedMatcher rangedMatcher = (StatePropertiesPredicate.RangedMatcher)valueMatcher;
                        {
                            minValue = var14_15 = rangedMatcher.minValue();
                            maxValue = var14_15 = rangedMatcher.maxValue();
                        }
                        StateDefinition definition = blockState.getBlock().getStateDefinition();
                        Property property = definition.getProperty(matcher.name());
                        if (property == null) continue;
                        com.google.common.base.Supplier rangePair = Suppliers.memoize(() -> {
                            List sorted = property.getPossibleValues().stream().sorted().toList();
                            return Pair.of(sorted.getFirst(), sorted.getLast());
                        });
                        String min = ((Optional)minValue).orElseGet(() -> property.getName((Comparable)((Pair)rangePair.get()).getFirst()));
                        String max = ((Optional)maxValue).orElseGet(() -> property.getName((Comparable)((Pair)rangePair.get()).getSecond()));
                        name.append((Component)Component.literal((String)min).withStyle(ChatFormatting.WHITE));
                        if (!min.equals(max)) {
                            name.append((Component)Component.literal((String)"~").withStyle(ChatFormatting.GRAY));
                            name.append((Component)Component.literal((String)max).withStyle(ChatFormatting.WHITE));
                        }
                    }
                }
                list.add(name);
            }
        }
        if (predicate.nbt().isPresent()) {
            list.add(Component.translatable((String)"tip.lychee.nbtPredicate").withStyle(ChatFormatting.GRAY));
        }
        if (appendModName && ClientProxy.hasJade) {
            list.add(IThemeHelper.get().modName((Object)ModIdentification.getModName((Block)blockState.getBlock())));
        }
        return list;
    }
}

