/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.util.context;

import com.mojang.serialization.Codec;
import java.util.Objects;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import snownee.lychee.LycheeRegistries;
import snownee.lychee.context.ActionContext;
import snownee.lychee.util.context.LycheeContextKey;

public interface LycheeContextSerializers {
    public static void init() {
        LycheeContextSerializers.register(LycheeContextKey.ACTION, ActionContext.CODEC);
        LycheeContextSerializers.register(LycheeContextKey.JSON, ExtraCodecs.JSON);
        LycheeContextSerializers.register(LycheeContextKey.RECIPE_ID, ResourceLocation.CODEC);
    }

    public static <T> Codec<T> register(ResourceLocation location, Codec<T> object) {
        Registry.register(LycheeRegistries.CONTEXT_SERIALIZER, (ResourceLocation)location, object);
        return object;
    }

    public static <T> Codec<T> register(LycheeContextKey<T> key, Codec<T> codec) {
        return LycheeContextSerializers.register(Objects.requireNonNull(LycheeRegistries.CONTEXT.getKey(key)), codec);
    }
}

