/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.util.action;

import com.google.common.base.MoreObjects;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;
import snownee.lychee.util.contextual.ContextualHolder;
import snownee.lychee.util.recipe.LycheeRecipeCommonProperties;

public class PostActionCommonProperties {
    public static final PostActionCommonProperties EMPTY = new PostActionCommonProperties(ContextualHolder.EMPTY, Optional.empty());
    public static final ResourceLocation HIDDEN = ResourceLocation.withDefaultNamespace((String)"hidden");
    public static final MapCodec<Optional<ResourceLocation>> ICON_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ResourceLocation.CODEC.optionalFieldOf("icon").forGetter(it -> it.isEmpty() || ((ResourceLocation)it.get()).equals((Object)HIDDEN) ? Optional.empty() : it), (App)Codec.BOOL.optionalFieldOf("hide", (Object)false).forGetter(it -> it.isPresent() && ((ResourceLocation)it.get()).equals((Object)HIDDEN))).apply((Applicative)instance, (it, bl) -> bl != false ? Optional.of(HIDDEN) : it));
    public static final MapCodec<PostActionCommonProperties> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)LycheeRecipeCommonProperties.CONTEXTUAL_CODEC.forGetter(PostActionCommonProperties::conditions), (App)ICON_CODEC.forGetter(it -> Optional.ofNullable(it.icon())), (App)Codec.STRING.optionalFieldOf("@path").forGetter(PostActionCommonProperties::getPath)).apply((Applicative)instance, PostActionCommonProperties::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, PostActionCommonProperties> STREAM_CODEC = StreamCodec.composite(ContextualHolder.STREAM_CODEC, PostActionCommonProperties::conditions, (StreamCodec)ByteBufCodecs.optional((StreamCodec)ResourceLocation.STREAM_CODEC), $ -> Optional.ofNullable($.icon()), PostActionCommonProperties::new);
    private Optional<String> path;
    private final ContextualHolder conditions;
    @Nullable
    private final ResourceLocation icon;

    public PostActionCommonProperties(ContextualHolder conditions, Optional<ResourceLocation> icon) {
        this(conditions, icon, Optional.empty());
    }

    public PostActionCommonProperties(ContextualHolder conditions, Optional<ResourceLocation> icon, Optional<String> path) {
        this.path = path;
        this.conditions = conditions;
        this.icon = icon.orElse(null);
    }

    public ContextualHolder conditions() {
        return this.conditions;
    }

    public Optional<String> getPath() {
        return this.path;
    }

    public void setPath(@Nullable String path) {
        this.path = Optional.ofNullable(path);
    }

    @Nullable
    public ResourceLocation icon() {
        return this.icon;
    }

    public boolean hidden() {
        return HIDDEN.equals((Object)this.icon);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("path", this.path).add("icon", (Object)this.icon).toString();
    }
}

