/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.util.action;

import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.MapCodec;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.GsonHelper;
import org.jetbrains.annotations.Nullable;
import snownee.kiwi.util.codec.KCodecs;
import snownee.lychee.LycheeRegistries;
import snownee.lychee.util.CommonProxy;
import snownee.lychee.util.SerializableType;
import snownee.lychee.util.action.PostActionCommonProperties;
import snownee.lychee.util.action.PostActionDisplay;
import snownee.lychee.util.action.PostActionLike;
import snownee.lychee.util.action.PostActionType;
import snownee.lychee.util.context.LycheeContext;
import snownee.lychee.util.contextual.Contextual;
import snownee.lychee.util.contextual.ContextualHolder;
import snownee.lychee.util.contextual.ContextualPredicate;
import snownee.lychee.util.json.JsonPointer;
import snownee.lychee.util.recipe.ILycheeRecipe;

public interface PostAction
extends PostActionDisplay,
PostActionLike,
ContextualPredicate,
Contextual {
    public static final MapCodec<PostAction> MAP_CODEC = LycheeRegistries.POST_ACTION.byNameCodec().dispatchMap(PostAction::type, SerializableType::codec);
    public static final Codec<PostAction> CODEC = MAP_CODEC.codec();
    public static final Codec<List<PostAction>> LIST_CODEC = KCodecs.compactList(CODEC);
    public static final StreamCodec<RegistryFriendlyByteBuf, PostAction> STREAM_CODEC = ByteBufCodecs.registry((ResourceKey)LycheeRegistries.POST_ACTION.key()).dispatch(PostAction::type, PostActionType::streamCodec);
    public static final StreamCodec<RegistryFriendlyByteBuf, List<PostAction>> STREAM_LIST_CODEC = STREAM_CODEC.apply(original -> new StreamCodec<RegistryFriendlyByteBuf, List<PostAction>>(){

        public void encode(RegistryFriendlyByteBuf byteBuf, List<PostAction> list) {
            List<PostAction> filtered = list.stream().filter(it -> !it.preventSync()).toList();
            ByteBufCodecs.writeCount((ByteBuf)byteBuf, (int)filtered.size(), (int)Integer.MAX_VALUE);
            for (PostAction action : filtered) {
                original.encode((Object)byteBuf, (Object)action);
            }
        }

        public List<PostAction> decode(RegistryFriendlyByteBuf byteBuf) {
            int size = ByteBufCodecs.readCount((ByteBuf)byteBuf, (int)Integer.MAX_VALUE);
            ArrayList<PostAction> list = new ArrayList<PostAction>(size);
            for (int i = 0; i < size; ++i) {
                PostAction action = (PostAction)original.decode((Object)byteBuf);
                if (action.preventSync()) continue;
                list.add(action);
            }
            return list;
        }
    });

    public PostActionCommonProperties commonProperties();

    default public Optional<String> getPath() {
        return this.commonProperties().getPath();
    }

    default public void setPath(String path) {
        this.commonProperties().setPath(path);
    }

    @Override
    default public ContextualHolder conditions() {
        return this.commonProperties().conditions();
    }

    @Override
    default public boolean hidden() {
        return this.commonProperties().hidden();
    }

    public PostActionType<?> type();

    public void apply(@Nullable ILycheeRecipe<?> var1, LycheeContext var2, int var3);

    @Override
    default public Component getDisplayName() {
        return Component.translatable((String)CommonProxy.makeDescriptionId("postAction", LycheeRegistries.POST_ACTION.getKey(this.type())));
    }

    default public boolean repeatable() {
        return true;
    }

    default public void getUsedPointers(@Nullable ILycheeRecipe<?> recipe, Consumer<JsonPointer> consumer) {
    }

    default public void onFailure(@Nullable ILycheeRecipe<?> recipe, LycheeContext context, int times) {
    }

    @Override
    default public int test(@Nullable ILycheeRecipe<?> recipe, LycheeContext ctx, int times) {
        return this.conditions().test(recipe, ctx, times);
    }

    @Override
    default public String toJsonString() {
        return GsonHelper.toStableString((JsonElement)((JsonElement)((Codec)this.type().codec()).encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this).getOrThrow()));
    }

    default public void validate(ILycheeRecipe<?> recipe) {
    }

    @Override
    default public PostAction asAction() {
        return this;
    }
}

