/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.util.action;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import snownee.lychee.LycheeRegistries;
import snownee.lychee.action.CycleStateProperty;
import snownee.lychee.action.DropItem;
import snownee.lychee.action.PlaceBlock;
import snownee.lychee.action.RandomSelect;
import snownee.lychee.action.SetBlock;
import snownee.lychee.action.input.DamageItem;
import snownee.lychee.action.input.PreventDefault;
import snownee.lychee.action.input.SetItem;
import snownee.lychee.client.action.IfActionRenderer;
import snownee.lychee.compat.recipeviewer.IngredientInfo;
import snownee.lychee.compat.recipeviewer.SlotType;
import snownee.lychee.util.BoundsExtensions;
import snownee.lychee.util.ClientProxy;
import snownee.lychee.util.CommonProxy;
import snownee.lychee.util.action.BlockBasedActionRenderer;
import snownee.lychee.util.action.PostAction;
import snownee.lychee.util.action.PostActionType;
import snownee.lychee.util.action.PostActionTypes;
import snownee.lychee.util.predicates.BlockPredicateExtensions;
import snownee.lychee.util.recipe.ILycheeRecipe;
import snownee.lychee.util.recipe.LycheeRecipeType;

public interface ActionRenderer<T extends PostAction> {
    public static final Map<PostActionType<?>, ActionRenderer<?>> RENDERERS = Maps.newIdentityHashMap();
    public static final ActionRenderer<PostAction> DEFAULT = new ActionRenderer<PostAction>(){};

    public static void init() {
        ActionRenderer.register(PostActionTypes.DROP_ITEM, DropItem::itemStack);
        ActionRenderer.register(PostActionTypes.SET_ITEM, SetItem::itemStack);
        ActionRenderer.register(PostActionTypes.DROP_XP, action -> Items.EXPERIENCE_BOTTLE.getDefaultInstance());
        ActionRenderer.register(PostActionTypes.EXECUTE, action -> Items.COMMAND_BLOCK.getDefaultInstance());
        ActionRenderer.register(PostActionTypes.EXPLODE, action -> Items.TNT.getDefaultInstance());
        ActionRenderer.register(PostActionTypes.IF, new IfActionRenderer());
        ActionRenderer.register(PostActionTypes.PLACE, BlockBasedActionRenderer.fromPredicate(PlaceBlock::block));
        ActionRenderer.register(PostActionTypes.SET_BLOCK, BlockBasedActionRenderer.fromPredicate(SetBlock::block));
        ActionRenderer.register(PostActionTypes.CYCLE_STATE_PROPERTY, new BlockBasedActionRenderer<CycleStateProperty>(it -> {
            List<BlockState> blockStates = BlockPredicateExtensions.getShowcaseBlockStates(it.block(), Set.of(it.property()));
            return CommonProxy.getCycledItem(blockStates, Blocks.AIR.defaultBlockState(), 1000);
        }));
        ActionRenderer.register(PostActionTypes.DAMAGE_ITEM, new ActionRenderer<DamageItem>(){

            @Override
            public void loadCatalystsInfo(DamageItem action, ILycheeRecipe<?> recipe, List<IngredientInfo> ingredients) {
                String key = CommonProxy.makeDescriptionId("postAction", LycheeRegistries.POST_ACTION.getKey(action.type()));
                MutableComponent component = Component.translatable((String)key, (Object[])new Object[]{action.damage()}).withStyle(ChatFormatting.YELLOW);
                Minecraft mc = Minecraft.getInstance();
                recipe.getItemIndexes(action.target()).forEach(i -> {
                    IngredientInfo info = (IngredientInfo)ingredients.get(i);
                    info.addTooltip((Component)component);
                    action.conditions().appendToTooltips(info.tooltips, (Level)mc.level, (Player)mc.player, 0);
                    info.type = SlotType.CATALYST;
                });
            }
        });
        ActionRenderer.register(PostActionTypes.PREVENT_DEFAULT, new ActionRenderer<PreventDefault>(){

            @Override
            public void loadCatalystsInfo(PreventDefault action, ILycheeRecipe<?> recipe, List<IngredientInfo> ingredients) {
                LycheeRecipeType lycheeRecipeType;
                block4: {
                    block3: {
                        RecipeType<Recipe<?>> recipeType = recipe.getType();
                        if (!(recipeType instanceof LycheeRecipeType)) break block3;
                        lycheeRecipeType = (LycheeRecipeType)recipeType;
                        if (lycheeRecipeType.canPreventConsumeInputs) break block4;
                    }
                    return;
                }
                Minecraft mc = Minecraft.getInstance();
                for (IngredientInfo info : ingredients) {
                    if (!info.tooltips.isEmpty()) continue;
                    info.addTooltip(lycheeRecipeType.getPreventDefaultDescription(recipe));
                    action.conditions().appendToTooltips(info.tooltips, (Level)mc.level, (Player)mc.player, 0);
                    info.type = SlotType.CATALYST;
                }
            }
        });
    }

    public static <T extends PostAction> ActionRenderer<T> of(PostAction action) {
        return Objects.requireNonNull(RENDERERS.getOrDefault(action.type(), DEFAULT));
    }

    public static <T extends PostAction> void register(PostActionType<T> type, ActionRenderer<T> renderer) {
        Objects.requireNonNull(type);
        Objects.requireNonNull(renderer);
        RENDERERS.put(type, renderer);
    }

    public static List<Component> getTooltipsFromRandom(RandomSelect randomSelect, PostAction child, @Nullable Player player) {
        int c;
        ArrayList list;
        int index = -1;
        for (int i = 0; i < randomSelect.entries().size(); ++i) {
            if (!randomSelect.entries().get(i).action().equals(child)) continue;
            index = i;
        }
        ArrayList arrayList = list = randomSelect.entries().size() == 1 && randomSelect.emptyWeight() == 0 ? Lists.newArrayList((Object[])new Component[]{randomSelect.getDisplayName()}) : ActionRenderer.of(child).getBaseTooltips(child, player);
        if (index == -1) {
            return list;
        }
        if (randomSelect.entries().size() > 1 || randomSelect.emptyWeight() > 0) {
            String chance = CommonProxy.chance((float)randomSelect.entries().get(index).weight() / (float)randomSelect.totalWeight());
            if (randomSelect.rolls() == BoundsExtensions.ONE) {
                list.add(Component.translatable((String)"tip.lychee.randomChance.one", (Object[])new Object[]{chance}).withStyle(ChatFormatting.YELLOW));
            } else {
                list.add(Component.translatable((String)"tip.lychee.randomChance", (Object[])new Object[]{chance, BoundsExtensions.getPlainDescription(randomSelect.rolls())}).withStyle(ChatFormatting.YELLOW));
            }
        }
        if ((c = randomSelect.conditions().showingCount() + child.conditions().showingCount()) > 0) {
            list.add(ClientProxy.format("contextual.lychee", c).withStyle(ChatFormatting.GRAY));
        }
        Minecraft mc = Minecraft.getInstance();
        randomSelect.conditions().appendToTooltips(list, (Level)mc.level, (Player)mc.player, 0);
        child.conditions().appendToTooltips(list, (Level)mc.level, (Player)mc.player, 0);
        return list;
    }

    default public void internalRender(T action, GuiGraphics graphics, int x, int y) {
        ResourceLocation sprite;
        if (!action.hidden() && (sprite = action.commonProperties().icon()) != null) {
            graphics.blitSprite(sprite, x, y, 16, 16);
            return;
        }
        this.render(action, graphics, x, y);
    }

    default public void render(T action, GuiGraphics graphics, int x, int y) {
    }

    default public List<Component> getBaseTooltips(T action, @Nullable Player player) {
        return Lists.newArrayList((Object[])new Component[]{action.getDisplayName()});
    }

    default public List<Component> getTooltips(T action, @Nullable Player player) {
        List<Component> list = this.getBaseTooltips(action, player);
        int c = action.conditions().showingCount();
        if (c > 0) {
            list.add((Component)ClientProxy.format("contextual.lychee", c).withStyle(ChatFormatting.GRAY));
        }
        Minecraft mc = Minecraft.getInstance();
        action.conditions().appendToTooltips(list, (Level)mc.level, player, 0);
        return list;
    }

    default public void loadCatalystsInfo(T action, ILycheeRecipe<?> recipe, List<IngredientInfo> ingredients) {
    }
}

