/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.util;

import io.netty.buffer.ByteBuf;
import java.text.DecimalFormat;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;

public class BoundsExtensions {
    public static final MinMaxBounds.Ints ONE = MinMaxBounds.Ints.exactly((int)1);
    public static final StreamCodec<ByteBuf, MinMaxBounds.Ints> INT_STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.VAR_INT), MinMaxBounds.Ints::min, (StreamCodec)ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.VAR_INT), MinMaxBounds.Ints::max, MinMaxBounds.Ints::new);
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("##.##");

    public static MutableComponent getDescription(MinMaxBounds<?> bounds) {
        return BoundsExtensions.getPlainDescription(bounds).withStyle(ChatFormatting.WHITE);
    }

    public static MutableComponent getPlainDescription(MinMaxBounds<?> bounds) {
        if (bounds.isAny()) {
            return Component.literal((String)"*");
        }
        if (bounds.min().isEmpty()) {
            return Component.literal((String)("<=" + DECIMAL_FORMAT.format(bounds.max().orElseThrow())));
        }
        if (bounds.max().isEmpty()) {
            return Component.literal((String)(">=" + DECIMAL_FORMAT.format(bounds.min().orElseThrow())));
        }
        if (Objects.equals(bounds.min().orElseThrow(), bounds.max().orElseThrow())) {
            return Component.literal((String)DECIMAL_FORMAT.format(bounds.min().get()));
        }
        return Component.literal((String)(DECIMAL_FORMAT.format(bounds.min().get()) + "~" + DECIMAL_FORMAT.format(bounds.max().get())));
    }

    public static int random(MinMaxBounds.Ints ints, RandomSource random) {
        int max;
        int min = ints.min().orElse(Integer.MIN_VALUE);
        if (min == (max = ints.max().orElse(Integer.MAX_VALUE).intValue())) {
            return min;
        }
        return Mth.randomBetweenInclusive((RandomSource)random, (int)min, (int)max);
    }

    public static float random(MinMaxBounds.Doubles doubles, RandomSource random) {
        float max;
        float min = doubles.min().map(Double::floatValue).orElse(Float.valueOf(Float.MIN_VALUE)).floatValue();
        if (min == (max = doubles.max().map(Double::floatValue).orElse(Float.valueOf(Float.MAX_VALUE)).floatValue())) {
            return min;
        }
        return Mth.randomBetween((RandomSource)random, (float)min, (float)max);
    }
}

