/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.ui;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import snownee.lychee.client.gui.LycheeGuiGraphics;
import snownee.lychee.client.gui.RenderElement;
import snownee.lychee.ui.SpriteElement;

public class SpriteElementRenderer
extends RenderElement {
    private final ResourceLocation id;
    private final float scale;

    public SpriteElementRenderer(ResourceLocation id) {
        this(id, 1.0f);
    }

    public SpriteElementRenderer(ResourceLocation id, float scale) {
        this.id = id;
        this.scale = scale;
    }

    @Override
    public void render(GuiGraphics graphics) {
        int width = Math.round((float)this.width() * this.scale);
        int height = Math.round((float)this.height() * this.scale);
        float xOff = (float)(this.width() - width) * 0.5f;
        int x = Math.round(this.x() + xOff);
        float yOff = (float)(this.height() - height) * 0.5f;
        int y = Math.round(this.y() + yOff);
        ((LycheeGuiGraphics)graphics).lychee$setRenderType(LycheeGuiGraphics::guiTextured);
        graphics.blitSprite(this.id, x, y, (int)this.z(), width, height);
        ((LycheeGuiGraphics)graphics).lychee$setRenderType(null);
    }

    public static SpriteElementRenderer create(SpriteElement element) {
        return new SpriteElementRenderer(element.id(), element.scale());
    }
}

