/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import snownee.kiwi.recipe.SizedIngredient;
import snownee.lychee.RecipeSerializers;
import snownee.lychee.RecipeTypes;
import snownee.lychee.context.LootParamsContext;
import snownee.lychee.util.NonNullListExtensions;
import snownee.lychee.util.context.LycheeContext;
import snownee.lychee.util.context.LycheeContextKey;
import snownee.lychee.util.input.ItemStackHolderCollection;
import snownee.lychee.util.recipe.ILycheeRecipe;
import snownee.lychee.util.recipe.LycheeRecipe;
import snownee.lychee.util.recipe.LycheeRecipeCommonProperties;
import snownee.lychee.util.recipe.LycheeRecipeSerializer;
import snownee.lychee.util.recipe.LycheeRecipeType;

public class ItemBurningRecipe
extends LycheeRecipe<LycheeContext> {
    protected final SizedIngredient input;

    public static void invoke(ItemEntity entity) {
        LycheeContext context = new LycheeContext();
        context.put(LycheeContextKey.LEVEL, entity.level());
        LootParamsContext lootParams = context.initLootParams(RecipeTypes.ITEM_BURNING);
        lootParams.set(LootContextParams.ORIGIN, entity.position());
        lootParams.set(LootContextParams.THIS_ENTITY, entity);
        lootParams.validate();
        RecipeTypes.ITEM_BURNING.findFirst(context, entity.level()).ifPresent(it -> {
            context.put((RecipeHolder<? extends ILycheeRecipe<?>>)it);
            int times = ((ItemBurningRecipe)it.value()).getRandomRepeats(entity.getItem().getCount() / ((ItemBurningRecipe)it.value()).input.count(), context);
            ItemStackHolderCollection itemStackHolders = ItemStackHolderCollection.InWorld.of(entity);
            context.put(LycheeContextKey.ITEM, itemStackHolders);
            ((ItemBurningRecipe)it.value()).applyPostActions(context, times);
            itemStackHolders.postApply(true, times);
        });
    }

    public ItemBurningRecipe(LycheeRecipeCommonProperties commonProperties, SizedIngredient input) {
        super(commonProperties);
        this.input = input;
        this.onConstructed();
    }

    public SizedIngredient input() {
        return this.input;
    }

    @Override
    public boolean matches(LycheeContext context, Level level) {
        LootParamsContext lootParams = context.get(LycheeContextKey.LOOT_PARAMS);
        ItemStack stack = ((ItemEntity)lootParams.get(LootContextParams.THIS_ENTITY)).getItem();
        return this.input.test(stack);
    }

    @Override
    public NonNullList<Ingredient> getIngredients() {
        return NonNullListExtensions.copyOf(List.of(this.input.ingredient()));
    }

    @Override
    public List<SizedIngredient> sizedIngredients() {
        return List.of(this.input);
    }

    @Override
    public LycheeRecipeSerializer<ItemBurningRecipe> getSerializer() {
        return RecipeSerializers.ITEM_BURNING;
    }

    @Override
    public LycheeRecipeType<ItemBurningRecipe> getType() {
        return RecipeTypes.ITEM_BURNING;
    }

    public static class Serializer
    implements LycheeRecipeSerializer<ItemBurningRecipe> {
        public static final MapCodec<ItemBurningRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)LycheeRecipeCommonProperties.SIMPLE_MAP_CODEC.forGetter(LycheeRecipe::commonProperties), (App)SizedIngredient.CODEC.fieldOf("item_in").forGetter(ItemBurningRecipe::input)).apply((Applicative)instance, ItemBurningRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, ItemBurningRecipe> STREAM_CODEC = StreamCodec.composite(LycheeRecipeCommonProperties.STREAM_CODEC, LycheeRecipe::commonProperties, (StreamCodec)SizedIngredient.STREAM_CODEC, ItemBurningRecipe::input, ItemBurningRecipe::new);

        @Override
        public MapCodec<ItemBurningRecipe> codec() {
            return CODEC;
        }

        @Override
        public StreamCodec<RegistryFriendlyByteBuf, ItemBurningRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

