/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.recipes;

import com.google.common.collect.Sets;
import java.util.Set;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import org.jetbrains.annotations.MustBeInvokedByOverriders;
import org.jetbrains.annotations.Nullable;
import snownee.lychee.recipes.DripstoneRecipe;
import snownee.lychee.util.predicates.BlockPredicateExtensions;
import snownee.lychee.util.recipe.BlockKeyableRecipeType;

public class DripstoneRecipeType
extends BlockKeyableRecipeType<DripstoneRecipe> {
    private final Set<Block> allSources = Sets.newHashSet();

    public DripstoneRecipeType(String name, Class<DripstoneRecipe> clazz, @Nullable LootContextParamSet paramSet) {
        super(name, clazz, paramSet);
    }

    @Override
    @MustBeInvokedByOverriders
    public void refreshCache() {
        super.refreshCache();
        this.allSources.clear();
        for (RecipeHolder recipe : this.recipes) {
            this.allSources.addAll(BlockPredicateExtensions.matchedBlocks(((DripstoneRecipe)recipe.value()).sourceBlock));
        }
    }

    public boolean hasSource(Block block) {
        return this.allSources.contains(block);
    }
}

