/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.advancements.critereon.BlockPredicate;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.level.Level;
import snownee.lychee.RecipeSerializers;
import snownee.lychee.RecipeTypes;
import snownee.lychee.util.context.LycheeContext;
import snownee.lychee.util.predicates.BlockPredicateExtensions;
import snownee.lychee.util.recipe.BlockKeyableRecipe;
import snownee.lychee.util.recipe.LycheeRecipe;
import snownee.lychee.util.recipe.LycheeRecipeCommonProperties;
import snownee.lychee.util.recipe.LycheeRecipeSerializer;
import snownee.lychee.util.recipe.LycheeRecipeType;

public class BlockExplodingRecipe
extends LycheeRecipe<LycheeContext>
implements BlockKeyableRecipe {
    protected final BlockPredicate blockPredicate;

    public BlockExplodingRecipe(LycheeRecipeCommonProperties commonProperties, BlockPredicate blockPredicate) {
        super(commonProperties);
        this.blockPredicate = blockPredicate;
        this.onConstructed();
    }

    @Override
    public boolean matches(LycheeContext context, Level level) {
        return BlockPredicateExtensions.isAny(this.blockPredicate()) || BlockPredicateExtensions.matches(this.blockPredicate(), context);
    }

    @Override
    public BlockPredicate blockPredicate() {
        return this.blockPredicate;
    }

    @Override
    public LycheeRecipeSerializer<BlockExplodingRecipe> getSerializer() {
        return RecipeSerializers.BLOCK_EXPLODING;
    }

    @Override
    public LycheeRecipeType<BlockExplodingRecipe> getType() {
        return RecipeTypes.BLOCK_EXPLODING;
    }

    public static class Serializer
    implements LycheeRecipeSerializer<BlockExplodingRecipe> {
        public static final MapCodec<BlockExplodingRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)LycheeRecipeCommonProperties.SIMPLE_MAP_CODEC.forGetter(LycheeRecipe::commonProperties), (App)BlockPredicateExtensions.CODEC_FOR_TESTING.optionalFieldOf("block_in", (Object)BlockPredicateExtensions.ANY).forGetter(BlockExplodingRecipe::blockPredicate)).apply((Applicative)instance, BlockExplodingRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, BlockExplodingRecipe> STREAM_CODEC = StreamCodec.composite(LycheeRecipeCommonProperties.STREAM_CODEC, LycheeRecipe::commonProperties, (StreamCodec)BlockPredicate.STREAM_CODEC, BlockExplodingRecipe::blockPredicate, BlockExplodingRecipe::new);

        @Override
        public MapCodec<BlockExplodingRecipe> codec() {
            return CODEC;
        }

        @Override
        public StreamCodec<RegistryFriendlyByteBuf, BlockExplodingRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

