/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.recipes;

import com.google.common.collect.Streams;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import snownee.kiwi.util.codec.KCodecs;
import snownee.lychee.RecipeSerializers;
import snownee.lychee.RecipeTypes;
import snownee.lychee.context.ActionContext;
import snownee.lychee.context.AnvilContext;
import snownee.lychee.util.action.Job;
import snownee.lychee.util.action.PostAction;
import snownee.lychee.util.codec.LycheeCodecs;
import snownee.lychee.util.context.LycheeContext;
import snownee.lychee.util.context.LycheeContextKey;
import snownee.lychee.util.json.JsonPointer;
import snownee.lychee.util.recipe.ILycheeRecipe;
import snownee.lychee.util.recipe.LycheeRecipe;
import snownee.lychee.util.recipe.LycheeRecipeCommonProperties;
import snownee.lychee.util.recipe.LycheeRecipeSerializer;
import snownee.lychee.util.recipe.LycheeRecipeType;

public class AnvilCraftingRecipe
extends LycheeRecipe<LycheeContext> {
    protected final NonNullList<Ingredient> ingredients;
    protected final int levelCost;
    protected final int materialCost;
    protected final ItemStack output;
    protected final List<PostAction> assemblingActions;

    public AnvilCraftingRecipe(LycheeRecipeCommonProperties commonProperties, NonNullList<Ingredient> ingredients, ItemStack output, List<PostAction> assemblingActions, int levelCost, int materialCost) {
        super(commonProperties);
        this.ingredients = ingredients;
        this.levelCost = levelCost;
        this.materialCost = materialCost;
        this.output = output;
        this.assemblingActions = assemblingActions;
        this.onConstructed();
    }

    @Override
    public IntList getItemIndexes(JsonPointer pointer) {
        if (pointer.size() == 1) {
            if (pointer.getString(0).equals("item_out")) {
                return IntList.of((int)2);
            }
            if (pointer.getString(0).equals("item_in")) {
                return this.ingredients.size() == 1 ? IntList.of((int)0) : IntList.of((int)0, (int)1);
            }
        }
        if (pointer.size() == 2 && pointer.getString(0).equals("item_in")) {
            try {
                int i = pointer.getInt(1);
                if (i >= 0 && i < 2) {
                    return IntList.of((int)i);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return IntList.of();
    }

    @Override
    public boolean matches(LycheeContext context, Level level) {
        AnvilContext anvilContext = context.get(LycheeContextKey.ANVIL);
        if (this.ingredients.size() == 2 && ((ItemStack)anvilContext.input().getSecond()).getCount() < this.materialCost) {
            return false;
        }
        return ((Ingredient)this.ingredients.getFirst()).test((ItemStack)anvilContext.input().getFirst()) && ((Ingredient)this.ingredients.getLast()).test((ItemStack)anvilContext.input().getSecond());
    }

    @Override
    public ItemStack assemble(LycheeContext context, HolderLookup.Provider provider) {
        AnvilContext anvilContext = context.get(LycheeContextKey.ANVIL);
        anvilContext.setLevelCost(this.levelCost);
        anvilContext.setMaterialCost(this.materialCost);
        context.get(LycheeContextKey.ITEM).replace(2, this.getResultItem(provider));
        ActionContext actionContext = context.get(LycheeContextKey.ACTION);
        actionContext.reset();
        actionContext.jobs.addAll(this.assemblingActions.stream().map(it -> new Job((PostAction)it, 1)).toList());
        actionContext.run(context);
        return context.getItem(2);
    }

    @Override
    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return this.output.copy();
    }

    @Override
    public NonNullList<Ingredient> getIngredients() {
        return this.ingredients;
    }

    @Override
    public LycheeRecipeSerializer<AnvilCraftingRecipe> getSerializer() {
        return RecipeSerializers.ANVIL_CRAFTING;
    }

    @Override
    public LycheeRecipeType<AnvilCraftingRecipe> getType() {
        return RecipeTypes.ANVIL_CRAFTING;
    }

    @Override
    public Stream<PostAction> allActions() {
        return Streams.concat((Stream[])new Stream[]{this.postActions().stream(), this.assemblingActions().stream()});
    }

    public int levelCost() {
        return this.levelCost;
    }

    public int materialCost() {
        return this.materialCost;
    }

    public ItemStack output() {
        return this.output;
    }

    public List<PostAction> assemblingActions() {
        return this.assemblingActions;
    }

    public static class Serializer
    implements LycheeRecipeSerializer<AnvilCraftingRecipe> {
        public static final MapCodec<AnvilCraftingRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)LycheeRecipeCommonProperties.SIMPLE_MAP_CODEC.forGetter(ILycheeRecipe::commonProperties), (App)LycheeCodecs.sizeLimit(KCodecs.compactList((Codec)Ingredient.CODEC_NONEMPTY), 1, 2).xmap(NonNullList::copyOf, Function.identity()).fieldOf("item_in").forGetter(AnvilCraftingRecipe::getIngredients), (App)LycheeCodecs.ITEM_STACK_CODEC.fieldOf("item_out").forGetter(AnvilCraftingRecipe::output), (App)PostAction.LIST_CODEC.optionalFieldOf("assembling", List.of()).forGetter(AnvilCraftingRecipe::assemblingActions), (App)ExtraCodecs.POSITIVE_INT.optionalFieldOf("level_cost", (Object)1).forGetter(AnvilCraftingRecipe::levelCost), (App)ExtraCodecs.NON_NEGATIVE_INT.optionalFieldOf("material_cost", (Object)1).forGetter(AnvilCraftingRecipe::materialCost)).apply((Applicative)instance, AnvilCraftingRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, AnvilCraftingRecipe> STREAM_CODEC = StreamCodec.composite(LycheeRecipeCommonProperties.STREAM_CODEC, LycheeRecipe::commonProperties, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC.apply(ByteBufCodecs.list((int)2)).map(NonNullList::copyOf, Function.identity()), AnvilCraftingRecipe::getIngredients, (StreamCodec)ItemStack.STREAM_CODEC, AnvilCraftingRecipe::output, PostAction.STREAM_LIST_CODEC, AnvilCraftingRecipe::assemblingActions, (StreamCodec)ByteBufCodecs.VAR_INT, AnvilCraftingRecipe::levelCost, (StreamCodec)ByteBufCodecs.VAR_INT, AnvilCraftingRecipe::materialCost, AnvilCraftingRecipe::new);

        @Override
        public MapCodec<AnvilCraftingRecipe> codec() {
            return CODEC;
        }

        @Override
        public StreamCodec<RegistryFriendlyByteBuf, AnvilCraftingRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

