/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.datagen;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.mojang.datafixers.util.Function3;
import dev.latvian.mods.rhino.util.HideFromJS;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.critereon.BlockPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.core.NonNullList;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;
import snownee.kiwi.recipe.SizedIngredient;
import snownee.lychee.datagen.ContextualBuilder;
import snownee.lychee.datagen.LycheeBuilder;
import snownee.lychee.recipes.AnvilCraftingRecipe;
import snownee.lychee.recipes.BlockCrushingRecipe;
import snownee.lychee.recipes.BlockExplodingRecipe;
import snownee.lychee.recipes.BlockInteractingRecipe;
import snownee.lychee.recipes.DripstoneRecipe;
import snownee.lychee.recipes.ItemBurningRecipe;
import snownee.lychee.recipes.ItemInsideRecipe;
import snownee.lychee.recipes.RandomBlockTickingRecipe;
import snownee.lychee.recipes.ShapedCraftingRecipe;
import snownee.lychee.util.BoundsExtensions;
import snownee.lychee.util.IngredientCollection;
import snownee.lychee.util.action.PostAction;
import snownee.lychee.util.action.PostActionLike;
import snownee.lychee.util.predicates.BlockPredicateExtensions;
import snownee.lychee.util.recipe.ILycheeRecipe;
import snownee.lychee.util.recipe.LycheeRecipeCommonProperties;

public abstract class LycheeRecipeBuilder<T extends LycheeRecipeBuilder<T, R>, R extends ILycheeRecipe<?>>
extends ContextualBuilder<T>
implements LycheeBuilder {
    protected boolean hideInRecipeViewer;
    protected boolean ghost;
    @Nullable
    protected String comment;
    protected String group = "default";
    protected final List<PostAction> postActions = Lists.newArrayListWithExpectedSize((int)6);
    protected MinMaxBounds.Ints maxRepeats = MinMaxBounds.Ints.ANY;
    @Nullable
    protected AdvancementHolder advancement;

    public LycheeRecipeCommonProperties properties() {
        return new LycheeRecipeCommonProperties(this.hideInRecipeViewer, this.ghost, Optional.ofNullable(this.comment), this.group, this.contextualHolder(), this.postActions, this.maxRepeats);
    }

    @Contract(value="-> this")
    public T hideInViewer() {
        this.hideInRecipeViewer = true;
        return (T)((LycheeRecipeBuilder)this.self());
    }

    @Contract(value="-> this")
    public T ghost() {
        this.ghost = true;
        return (T)((LycheeRecipeBuilder)this.self());
    }

    @Contract(value="_ -> this")
    public T comment(@Nullable String comment) {
        this.comment = comment;
        return (T)((LycheeRecipeBuilder)this.self());
    }

    @Contract(value="_ -> this")
    public T group(String group) {
        this.group = group;
        return (T)((LycheeRecipeBuilder)this.self());
    }

    @Contract(value="_ -> this")
    public T post(PostActionLike postAction) {
        this.postActions.add(postAction.asAction());
        return (T)((LycheeRecipeBuilder)this.self());
    }

    @HideFromJS
    @Contract(value="_ -> this")
    public T post(Collection<? extends PostActionLike> postActions) {
        postActions.forEach(this::post);
        return (T)((LycheeRecipeBuilder)this.self());
    }

    @Contract(value="_ -> this")
    public T maxRepeats(MinMaxBounds.Ints maxRepeats) {
        this.maxRepeats = maxRepeats;
        return (T)((LycheeRecipeBuilder)this.self());
    }

    @Contract(value="-> this")
    @CanIgnoreReturnValue
    public T noRepeat() {
        return this.maxRepeats(BoundsExtensions.ONE);
    }

    @Contract(value="_ -> this")
    public T advancement(AdvancementHolder advancement) {
        this.advancement = advancement;
        return (T)((LycheeRecipeBuilder)this.self());
    }

    public abstract R build();

    @CanIgnoreReturnValue
    public R export(ResourceLocation id, RecipeOutput exporter) {
        R recipe = this.build();
        exporter.accept(id, recipe, this.advancement);
        return recipe;
    }

    public static class ShapedCrafting
    extends LycheeRecipeBuilder<ShapedCrafting, ShapedCraftingRecipe> {
        private final RecipeCategory category;
        private final ItemStack result;
        private final List<String> rows;
        private final Map<Character, Ingredient> key;
        private boolean showNotification = true;
        protected final List<PostAction> assemblingActions = Lists.newArrayListWithExpectedSize((int)6);

        public ShapedCrafting(RecipeCategory category, ItemLike result, int amount) {
            this(category, new ItemStack(result, amount));
        }

        public ShapedCrafting(RecipeCategory category, ItemStack result) {
            this.rows = Lists.newArrayList();
            this.key = Maps.newLinkedHashMap();
            this.category = category;
            this.result = result;
        }

        public ShapedCrafting define(Character key, TagKey<Item> tagKey) {
            return this.define(key, Ingredient.of(tagKey));
        }

        public ShapedCrafting define(Character key, ItemLike item) {
            return this.define(key, Ingredient.of((ItemLike[])new ItemLike[]{item}));
        }

        public ShapedCrafting define(Character key, Ingredient ingredient) {
            if (this.key.containsKey(key)) {
                throw new IllegalArgumentException("Symbol '" + key + "' is already defined!");
            }
            if (key.charValue() == ' ') {
                throw new IllegalArgumentException("Symbol ' ' (whitespace) is reserved and cannot be defined");
            }
            this.key.put(key, ingredient);
            return this;
        }

        public ShapedCrafting pattern(String row) {
            if (!this.rows.isEmpty() && row.length() != this.rows.get(0).length()) {
                throw new IllegalArgumentException("Pattern must be the same width on every line!");
            }
            this.rows.add(row);
            return this;
        }

        public ShapedCrafting showNotification(boolean showNotification) {
            this.showNotification = showNotification;
            return this;
        }

        @Contract(value="_ -> this")
        public ShapedCrafting assembling(PostActionLike assemblingAction) {
            this.assemblingActions.add(assemblingAction.asAction());
            return (ShapedCrafting)this.self();
        }

        @HideFromJS
        @Contract(value="_ -> this")
        public ShapedCrafting assembling(Collection<? extends PostActionLike> assemblingActions) {
            assemblingActions.forEach(this::assembling);
            return (ShapedCrafting)this.self();
        }

        @Override
        public ShapedCraftingRecipe build() {
            LycheeRecipeCommonProperties properties = this.properties();
            ShapedRecipe shapedRecipe = new ShapedRecipe("default".equals(properties.group()) ? "" : properties.group(), ShapedCrafting.determineBookCategory(this.category), ShapedRecipePattern.of(this.key, this.rows), this.result, this.showNotification);
            return new ShapedCraftingRecipe(properties, shapedRecipe, this.assemblingActions);
        }

        static CraftingBookCategory determineBookCategory(RecipeCategory category) {
            return switch (category) {
                case RecipeCategory.BUILDING_BLOCKS -> CraftingBookCategory.BUILDING;
                case RecipeCategory.TOOLS, RecipeCategory.COMBAT -> CraftingBookCategory.EQUIPMENT;
                case RecipeCategory.REDSTONE -> CraftingBookCategory.REDSTONE;
                default -> CraftingBookCategory.MISC;
            };
        }
    }

    public static class BlockInteracting<R extends BlockInteractingRecipe>
    extends LycheeRecipeBuilder<BlockInteracting<R>, R> {
        protected final Function3<LycheeRecipeCommonProperties, List<SizedIngredient>, BlockPredicate, R> constructor;
        protected final List<SizedIngredient> input;
        protected final BlockPredicate blockPredicate;

        public BlockInteracting(Function3<LycheeRecipeCommonProperties, List<SizedIngredient>, BlockPredicate, R> constructor, SizedIngredient mainHand, @Nullable SizedIngredient offHand, BlockPredicate block) {
            this.constructor = constructor;
            this.input = offHand == null ? List.of(mainHand) : List.of(mainHand, offHand);
            this.blockPredicate = block;
            this.noRepeat();
        }

        @Override
        public R build() {
            return (R)((BlockInteractingRecipe)this.constructor.apply((Object)this.properties(), this.input, (Object)this.blockPredicate));
        }
    }

    public static class ItemBurning
    extends LycheeRecipeBuilder<ItemBurning, ItemBurningRecipe> {
        protected final SizedIngredient input;

        public ItemBurning(SizedIngredient input) {
            this.input = input;
        }

        @Override
        public ItemBurningRecipe build() {
            return new ItemBurningRecipe(this.properties(), this.input);
        }
    }

    public static class RandomBlockTicking
    extends LycheeRecipeBuilder<RandomBlockTicking, RandomBlockTickingRecipe> {
        protected final BlockPredicate block;

        public RandomBlockTicking(BlockPredicate block) {
            this.block = block;
        }

        @Override
        public RandomBlockTickingRecipe build() {
            return new RandomBlockTickingRecipe(this.properties(), this.block);
        }
    }

    public static class BlockExploding
    extends LycheeRecipeBuilder<BlockExploding, BlockExplodingRecipe> {
        protected final BlockPredicate block;

        public BlockExploding(BlockPredicate block) {
            this.block = block;
        }

        @Override
        public BlockExplodingRecipe build() {
            return new BlockExplodingRecipe(this.properties(), this.block);
        }
    }

    public static class AnvilCrafting
    extends LycheeRecipeBuilder<AnvilCrafting, AnvilCraftingRecipe> {
        protected final NonNullList<Ingredient> ingredients;
        protected final int levelCost;
        protected final int materialCost;
        protected final ItemStack output;
        protected final List<PostAction> assemblingActions = Lists.newArrayListWithExpectedSize((int)6);

        public AnvilCrafting(Ingredient left, @Nullable Ingredient right, int materialCost, int levelCost, ItemStack output) {
            this.ingredients = right == null ? NonNullList.of((Object)Ingredient.EMPTY, (Object[])new Ingredient[]{left}) : NonNullList.of((Object)Ingredient.EMPTY, (Object[])new Ingredient[]{left, right});
            this.levelCost = levelCost;
            this.materialCost = materialCost;
            this.output = output;
        }

        @Contract(value="_ -> this")
        public AnvilCrafting assembling(PostActionLike assemblingAction) {
            this.assemblingActions.add(assemblingAction.asAction());
            return (AnvilCrafting)this.self();
        }

        @HideFromJS
        @Contract(value="_ -> this")
        public AnvilCrafting assembling(Collection<? extends PostActionLike> assemblingActions) {
            assemblingActions.forEach(this::assembling);
            return (AnvilCrafting)this.self();
        }

        @Override
        public AnvilCraftingRecipe build() {
            return new AnvilCraftingRecipe(this.properties(), this.ingredients, this.output, this.assemblingActions, this.levelCost, this.materialCost);
        }
    }

    public static class Dripstone
    extends LycheeRecipeBuilder<Dripstone, DripstoneRecipe> {
        protected final BlockPredicate sourceBlock;
        protected final BlockPredicate targetBlock;

        public Dripstone(BlockPredicate sourceBlock, BlockPredicate targetBlock) {
            this.sourceBlock = sourceBlock;
            this.targetBlock = targetBlock;
        }

        @Override
        public DripstoneRecipe build() {
            return new DripstoneRecipe(this.properties(), this.sourceBlock, this.targetBlock);
        }
    }

    public static class ItemInside
    extends Shapeless<ItemInside, ItemInsideRecipe> {
        protected BlockPredicate block = BlockPredicateExtensions.ANY;
        protected int time;

        @Contract(value="_ -> this")
        public ItemInside blockIn(Object block) {
            this.block = this.block(block);
            return (ItemInside)this.self();
        }

        @Contract(value="_ -> this")
        public ItemInside time(int time) {
            this.time = time;
            return (ItemInside)this.self();
        }

        @Override
        public ItemInsideRecipe build() {
            return new ItemInsideRecipe(this.properties(), this.block, this.time, this.ingredientCollection());
        }
    }

    public static class BlockCrushing
    extends Shapeless<BlockCrushing, BlockCrushingRecipe> {
        protected BlockPredicate fallingBlock = BlockCrushingRecipe.ANVIL;
        protected BlockPredicate landingBlock = BlockPredicateExtensions.ANY;

        @Contract(value="_ -> this")
        public BlockCrushing fallingBlock(Object fallingBlock) {
            this.fallingBlock = this.block(fallingBlock);
            return (BlockCrushing)this.self();
        }

        @Contract(value="_ -> this")
        public BlockCrushing landingBlock(Object landingBlock) {
            this.landingBlock = this.block(landingBlock);
            return (BlockCrushing)this.self();
        }

        @Override
        public BlockCrushingRecipe build() {
            return new BlockCrushingRecipe(this.properties(), this.fallingBlock, this.landingBlock, this.ingredientCollection());
        }
    }

    public static class SimpleShapeless<R extends ILycheeRecipe<?>>
    extends Shapeless<SimpleShapeless<R>, R> {
        protected final BiFunction<LycheeRecipeCommonProperties, IngredientCollection, R> constructor;

        public SimpleShapeless(BiFunction<LycheeRecipeCommonProperties, IngredientCollection, R> constructor) {
            this.constructor = constructor;
        }

        @Override
        public R build() {
            return (R)((ILycheeRecipe)this.constructor.apply(this.properties(), this.ingredientCollection()));
        }
    }

    public static abstract class Shapeless<T extends LycheeRecipeBuilder<T, R>, R extends ILycheeRecipe<?>>
    extends LycheeRecipeBuilder<T, R> {
        protected final List<SizedIngredient> ingredients = Lists.newArrayList();

        @Contract(value="_ -> this")
        public T itemIn(Collection<SizedIngredient> ingredients) {
            this.ingredients.addAll(ingredients);
            return (T)((LycheeRecipeBuilder)this.self());
        }

        protected IngredientCollection ingredientCollection() {
            return IngredientCollection.of(this.ingredients);
        }
    }
}

