/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.datagen;

import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JavaOps;
import dev.latvian.mods.rhino.util.HideFromJS;
import java.lang.runtime.SwitchBootstraps;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.advancements.critereon.BlockPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import snownee.kiwi.recipe.SizedIngredient;
import snownee.lychee.action.AddItemCooldown;
import snownee.lychee.action.AnvilDamageChance;
import snownee.lychee.action.CustomAction;
import snownee.lychee.action.CycleStateProperty;
import snownee.lychee.action.Delay;
import snownee.lychee.action.DropItem;
import snownee.lychee.action.DropXp;
import snownee.lychee.action.Execute;
import snownee.lychee.action.Exit;
import snownee.lychee.action.Explode;
import snownee.lychee.action.If;
import snownee.lychee.action.Move;
import snownee.lychee.action.MoveTowardsFace;
import snownee.lychee.action.PlaceBlock;
import snownee.lychee.action.SetBlock;
import snownee.lychee.action.input.DamageItem;
import snownee.lychee.action.input.PreventDefault;
import snownee.lychee.action.input.SetItem;
import snownee.lychee.datagen.ActionBuilder;
import snownee.lychee.datagen.LycheeRecipeBuilder;
import snownee.lychee.recipes.BlockClickingRecipe;
import snownee.lychee.recipes.BlockInteractingRecipe;
import snownee.lychee.recipes.ItemExplodingRecipe;
import snownee.lychee.recipes.LightningChannelingRecipe;
import snownee.lychee.util.Reference;
import snownee.lychee.util.action.PostActionCommonProperties;
import snownee.lychee.util.action.PostActionLike;
import snownee.lychee.util.predicates.BlockPredicateExtensions;
import snownee.lychee.util.ui.BlankRecipe;

public interface LycheeBuilder {
    public static final ThreadLocal<RegistryOps<Object>> registryOps = new ThreadLocal();

    default public void setup(HolderLookup.Provider wrapperLookup) {
        this.setup((RegistryOps<Object>)wrapperLookup.createSerializationContext((DynamicOps)JavaOps.INSTANCE));
    }

    default public void setup(RegistryOps<Object> ops) {
        registryOps.set(ops);
    }

    default public void teardown() {
        registryOps.remove();
    }

    default public LycheeRecipeBuilder.SimpleShapeless<BlankRecipe> blankRecipe() {
        return new LycheeRecipeBuilder.SimpleShapeless<BlankRecipe>(BlankRecipe::new);
    }

    default public LycheeRecipeBuilder.AnvilCrafting anvilCraftingRecipe(Ingredient left, @Nullable Ingredient right, int materialCost, int levelCost, ItemStack output) {
        return new LycheeRecipeBuilder.AnvilCrafting(left, right, materialCost, levelCost, output);
    }

    default public LycheeRecipeBuilder.BlockInteracting<BlockClickingRecipe> blockClickingRecipe(SizedIngredient mainHand, @Nullable SizedIngredient offHand, Object block) {
        return new LycheeRecipeBuilder.BlockInteracting<BlockClickingRecipe>(BlockClickingRecipe::new, mainHand, offHand, this.block(block));
    }

    default public LycheeRecipeBuilder.BlockCrushing blockCrushingRecipe() {
        return new LycheeRecipeBuilder.BlockCrushing();
    }

    default public LycheeRecipeBuilder.BlockExploding blockExplodingRecipe(Object block) {
        return new LycheeRecipeBuilder.BlockExploding(this.block(block));
    }

    default public LycheeRecipeBuilder.BlockInteracting<BlockInteractingRecipe> blockInteractingRecipe(SizedIngredient mainHand, @Nullable SizedIngredient offHand, Object block) {
        return new LycheeRecipeBuilder.BlockInteracting<BlockInteractingRecipe>(BlockInteractingRecipe::new, mainHand, offHand, this.block(block));
    }

    default public LycheeRecipeBuilder.Dripstone blockDripstoneRecipe(Object sourceBlock, Object targetBlock) {
        return new LycheeRecipeBuilder.Dripstone(this.block(sourceBlock), this.block(targetBlock));
    }

    default public LycheeRecipeBuilder.ItemBurning itemBurningRecipe(SizedIngredient input) {
        return new LycheeRecipeBuilder.ItemBurning(input);
    }

    default public LycheeRecipeBuilder.SimpleShapeless<ItemExplodingRecipe> itemExplodingRecipe() {
        return new LycheeRecipeBuilder.SimpleShapeless<ItemExplodingRecipe>(ItemExplodingRecipe::new);
    }

    default public LycheeRecipeBuilder.ItemInside itemInsideRecipe() {
        return new LycheeRecipeBuilder.ItemInside();
    }

    default public LycheeRecipeBuilder.SimpleShapeless<LightningChannelingRecipe> lightningChannelingRecipe() {
        return new LycheeRecipeBuilder.SimpleShapeless<LightningChannelingRecipe>(LightningChannelingRecipe::new);
    }

    default public LycheeRecipeBuilder.RandomBlockTicking randomBlockTickingRecipe(Object block) {
        return new LycheeRecipeBuilder.RandomBlockTicking(this.block(block));
    }

    default public LycheeRecipeBuilder.ShapedCrafting shapedCraftingRecipe(RecipeCategory category, ItemLike result) {
        return this.shapedCraftingRecipe(category, result, 1);
    }

    default public LycheeRecipeBuilder.ShapedCrafting shapedCraftingRecipe(RecipeCategory category, ItemLike result, int amount) {
        return this.shapedCraftingRecipe(category, new ItemStack(result, amount));
    }

    default public LycheeRecipeBuilder.ShapedCrafting shapedCraftingRecipe(RecipeCategory category, ItemStack result) {
        return new LycheeRecipeBuilder.ShapedCrafting(category, result);
    }

    @HideFromJS
    default public ActionBuilder<?, DropItem> dropItem(ItemLike item) {
        return this.dropItem(item, 1);
    }

    default public ActionBuilder<?, DropItem> dropItem(ItemLike item, int count) {
        return this.dropItem(new ItemStack(item, count));
    }

    default public ActionBuilder<?, DropItem> dropItem(ItemStack itemStack) {
        return new ActionBuilder(new DropItem(PostActionCommonProperties.EMPTY, itemStack));
    }

    default public ActionBuilder<?, PlaceBlock> place(Object block) {
        return this.place(block, BlockPos.ZERO);
    }

    default public ActionBuilder<?, PlaceBlock> place(Object block, BlockPos offset) {
        return new ActionBuilder(new PlaceBlock(PostActionCommonProperties.EMPTY, this.block(block), offset));
    }

    default public ActionBuilder<?, SetBlock> setBlock(Object block) {
        return new ActionBuilder(new SetBlock(PostActionCommonProperties.EMPTY, this.block(block)));
    }

    default public ActionBuilder<?, CycleStateProperty> cycleStateProperty(Object block, String property) {
        return this.cycleStateProperty(block, property, BlockPos.ZERO);
    }

    default public ActionBuilder<?, CycleStateProperty> cycleStateProperty(Object block, String property, BlockPos offset) {
        return new ActionBuilder(new CycleStateProperty(PostActionCommonProperties.EMPTY, this.block(block), offset, property, false));
    }

    default public ActionBuilder<?, CycleStateProperty> cycleStatePropertyReversed(Object block, String property) {
        return this.cycleStatePropertyReversed(block, property, BlockPos.ZERO);
    }

    default public ActionBuilder<?, CycleStateProperty> cycleStatePropertyReversed(Object block, String property, BlockPos offset) {
        return new ActionBuilder(new CycleStateProperty(PostActionCommonProperties.EMPTY, this.block(block), offset, property, true));
    }

    default public ActionBuilder<?, MoveTowardsFace> moveTowardsFace(float factor) {
        return new ActionBuilder(new MoveTowardsFace(PostActionCommonProperties.EMPTY, factor));
    }

    default public ActionBuilder<?, Move> move(Vec3 offset) {
        return new ActionBuilder(new Move(PostActionCommonProperties.EMPTY, offset, ""));
    }

    default public ActionBuilder<?, Move> move(Vec3 offset, String with) {
        return new ActionBuilder(new Move(PostActionCommonProperties.EMPTY, offset, with));
    }

    default public ActionBuilder<?, Execute> execute(String command) {
        return new ActionBuilder(new Execute(PostActionCommonProperties.EMPTY, command, true));
    }

    default public ActionBuilder<?, Execute> executeNoRepeat(String command) {
        return new ActionBuilder(new Execute(PostActionCommonProperties.EMPTY, command, false));
    }

    default public ActionBuilder<?, Exit> exit() {
        return new ActionBuilder(new Exit());
    }

    default public ActionBuilder<?, If> ifAction(Collection<? extends PostActionLike> successEntries, Collection<? extends PostActionLike> failureEntries) {
        return new ActionBuilder(If.of(PostActionCommonProperties.EMPTY, successEntries.stream().map(PostActionLike::asAction).toList(), failureEntries.stream().map(PostActionLike::asAction).toList()));
    }

    default public ActionBuilder<?, AddItemCooldown> addItemCooldown(float seconds) {
        return this.addItemCooldown(seconds, null);
    }

    default public ActionBuilder<?, AddItemCooldown> addItemCooldown(float seconds, @Nullable Item item) {
        return new ActionBuilder(new AddItemCooldown(PostActionCommonProperties.EMPTY, seconds, Optional.ofNullable(item)));
    }

    default public ActionBuilder<?, PreventDefault> preventDefault() {
        return new ActionBuilder(new PreventDefault());
    }

    default public ActionBuilder<?, DropXp> dropXp(int amount) {
        return new ActionBuilder(new DropXp(PostActionCommonProperties.EMPTY, amount));
    }

    default public ActionBuilder<?, AnvilDamageChance> anvilDamageChance(float chance) {
        return new ActionBuilder(new AnvilDamageChance(PostActionCommonProperties.EMPTY, chance));
    }

    default public ActionBuilder.RandomSelectBuilder randomSelect() {
        return new ActionBuilder.RandomSelectBuilder();
    }

    default public ActionBuilder<?, Explode> explode(Explosion.BlockInteraction blockInteraction, BlockPos offset, boolean fire, float radius, float step) {
        return new ActionBuilder(new Explode(PostActionCommonProperties.EMPTY, blockInteraction, offset, fire, radius, step));
    }

    default public ActionBuilder<?, CustomAction> customAction(String id, JsonObject json, boolean repeatable, boolean preventSync) {
        return new ActionBuilder(new CustomAction(PostActionCommonProperties.EMPTY, id, json, repeatable, preventSync));
    }

    default public ActionBuilder<?, DamageItem> damageItem(int damage, Reference target) {
        return new ActionBuilder(new DamageItem(PostActionCommonProperties.EMPTY, damage, target));
    }

    default public ActionBuilder<?, SetItem> setItem(ItemStack itemStack, Reference target) {
        return new ActionBuilder(new SetItem(PostActionCommonProperties.EMPTY, itemStack, target));
    }

    default public ActionBuilder<?, Delay> delay(float seconds) {
        return new ActionBuilder(new Delay(seconds));
    }

    default public BlockPredicate block(Object o) {
        Object object = o;
        Objects.requireNonNull(object);
        Object object2 = object;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BlockPredicate.class, String.class, Block.class, TagKey.class}, (Object)object2, n)) {
            case 0 -> {
                BlockPredicate bp;
                yield bp = (BlockPredicate)object2;
            }
            case 1 -> {
                String s = (String)object2;
                yield (BlockPredicate)BlockPredicateExtensions.fromString(s, true).getOrThrow();
            }
            case 2 -> {
                Block block = (Block)object2;
                yield BlockPredicate.Builder.block().of(new Block[]{block}).build();
            }
            case 3 -> {
                TagKey tagKey = (TagKey)object2;
                yield BlockPredicate.Builder.block().of(tagKey).build();
            }
            default -> throw new IllegalArgumentException("Invalid argument: " + String.valueOf(o));
        };
    }

    default public SizedIngredient sized(Object o) {
        int i;
        char c;
        String s;
        if (o instanceof String && (s = (String)o).length() > 3 && (c = s.charAt(0)) >= '1' && c <= '9' && (i = s.indexOf("x ")) > 0) {
            int count = Integer.parseInt(s.substring(0, i));
            return this.sized(s.substring(i + 2), count);
        }
        return this.sized(o, 1);
    }

    default public SizedIngredient sized(Object o, int count) {
        Object object = o;
        Objects.requireNonNull(object);
        Object object2 = object;
        int n = 0;
        Ingredient i = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{SizedIngredient.class, Ingredient.class, ItemLike.class, ItemStack.class, TagKey.class, String.class}, (Object)object2, n)) {
            case 0 -> {
                SizedIngredient si = (SizedIngredient)object2;
                yield si.ingredient();
            }
            case 1 -> {
                Ingredient ing;
                yield ing = (Ingredient)object2;
            }
            case 2 -> {
                ItemLike item = (ItemLike)object2;
                yield Ingredient.of((ItemLike[])new ItemLike[]{item});
            }
            case 3 -> {
                ItemStack stack = (ItemStack)object2;
                yield Ingredient.of((ItemStack[])new ItemStack[]{stack});
            }
            case 4 -> {
                TagKey tagKey = (TagKey)object2;
                yield Ingredient.of((TagKey)tagKey);
            }
            case 5 -> {
                String s = (String)object2;
                yield LycheeBuilder.parse(s);
            }
            default -> throw new IllegalArgumentException("Invalid argument: " + String.valueOf(o));
        };
        return new SizedIngredient(i, count);
    }

    private static Ingredient parse(String s) {
        ExtraCodecs.TagOrElementLocation id = (ExtraCodecs.TagOrElementLocation)((Pair)ExtraCodecs.TAG_OR_ELEMENT_ID.decode((DynamicOps)JavaOps.INSTANCE, (Object)s).getOrThrow()).getFirst();
        if (id.tag()) {
            return Ingredient.of((TagKey)TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)id.id()));
        }
        return Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)BuiltInRegistries.ITEM.get(id.id())});
    }

    public static LycheeBuilder create(RegistryOps<?> registryOps) {
        LycheeBuilder builder = new LycheeBuilder(){};
        builder.setup((RegistryOps<Object>)registryOps.withParent((DynamicOps)JavaOps.INSTANCE));
        return builder;
    }
}

