/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.contextual;

import com.mojang.serialization.MapCodec;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import snownee.lychee.util.context.LycheeContext;
import snownee.lychee.util.contextual.ContextualCondition;
import snownee.lychee.util.contextual.ContextualConditionType;
import snownee.lychee.util.recipe.ILycheeRecipe;

public record Not(ContextualCondition condition) implements ContextualCondition
{
    public ContextualConditionType<Not> type() {
        return ContextualConditionType.NOT;
    }

    @Override
    public int test(@Nullable ILycheeRecipe<?> recipe, LycheeContext ctx, int times) {
        return times - this.condition.test(recipe, ctx, times);
    }

    @Override
    public TriState testForTooltips(Level level, @Nullable Player player) {
        return switch (this.condition.testForTooltips(level, player)) {
            case TriState.TRUE -> TriState.FALSE;
            case TriState.FALSE -> TriState.TRUE;
            default -> TriState.DEFAULT;
        };
    }

    @Override
    public MutableComponent getDescription(boolean inverted) {
        return this.condition.getDescription(!inverted);
    }

    public static class Type
    implements ContextualConditionType<Not> {
        public static final MapCodec<Not> CODEC = ContextualCondition.CODEC.xmap(Not::new, Not::condition).fieldOf("contextual");
        public static final StreamCodec<RegistryFriendlyByteBuf, Not> STREAM_CODEC = ContextualCondition.STREAM_CODEC.map(Not::new, Not::condition);

        @Override
        public MapCodec<Not> codec() {
            return CODEC;
        }

        @Override
        public StreamCodec<RegistryFriendlyByteBuf, Not> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

