/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.contextual;

import com.mojang.brigadier.ParseResults;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.mutable.MutableInt;
import org.jetbrains.annotations.Nullable;
import snownee.lychee.context.LootParamsContext;
import snownee.lychee.util.codec.LycheeStreamCodecs;
import snownee.lychee.util.context.LycheeContext;
import snownee.lychee.util.context.LycheeContextKey;
import snownee.lychee.util.contextual.ContextualCondition;
import snownee.lychee.util.contextual.ContextualConditionType;
import snownee.lychee.util.recipe.ILycheeRecipe;

public record Execute(String command, MinMaxBounds.Ints bounds) implements ContextualCondition
{
    public static final MinMaxBounds.Ints DEFAULT_RANGE = MinMaxBounds.Ints.atLeast((int)1);
    public static final Execute DUMMY = new Execute("", DEFAULT_RANGE);

    public Execute(String command) {
        this(command, DEFAULT_RANGE);
    }

    public ContextualConditionType<Execute> type() {
        return ContextualConditionType.EXECUTE;
    }

    @Override
    public int test(@Nullable ILycheeRecipe<?> recipe, LycheeContext ctx, int times) {
        Level level = ctx.level();
        if (this.command.isEmpty() || level.isClientSide) {
            return 0;
        }
        LootParamsContext lootParams = ctx.get(LycheeContextKey.LOOT_PARAMS);
        Vec3 pos = (Vec3)lootParams.get(LootContextParams.ORIGIN);
        Entity entity = (Entity)lootParams.getOrNull(LootContextParams.THIS_ENTITY);
        Vec2 rotation = Vec2.ZERO;
        Component displayName = snownee.lychee.action.Execute.DEFAULT_NAME;
        String name = "lychee";
        if (entity != null) {
            rotation = entity.getRotationVector();
            displayName = entity.getDisplayName();
            name = entity.getName().getString();
        }
        ServerLevel serverLevel = (ServerLevel)level;
        MinecraftServer server = serverLevel.getServer();
        MutableInt returnValue = new MutableInt();
        CommandSourceStack sourceStack = new CommandSourceStack(CommandSource.NULL, pos, rotation, serverLevel, 2, name, displayName, server, entity).withCallback((success, i) -> returnValue.setValue(i));
        Commands cmds = server.getCommands();
        ParseResults results = cmds.getDispatcher().parse(this.command, (Object)sourceStack);
        cmds.performCommand(results, this.command);
        return this.bounds.matches(returnValue.intValue()) ? times : 0;
    }

    @Override
    public MutableComponent getDescription(boolean inverted) {
        return Component.translatable((String)this.getDescriptionId(false));
    }

    public static class Type
    implements ContextualConditionType<Execute> {
        public static final MapCodec<Execute> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.fieldOf("command").forGetter(Execute::command), (App)MinMaxBounds.Ints.CODEC.optionalFieldOf("value", (Object)DEFAULT_RANGE).forGetter(Execute::bounds)).apply((Applicative)instance, Execute::new));

        @Override
        public MapCodec<Execute> codec() {
            return CODEC;
        }

        @Override
        public StreamCodec<RegistryFriendlyByteBuf, Execute> streamCodec() {
            return LycheeStreamCodecs.uncheckedUnit(DUMMY);
        }
    }
}

