/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.context;

import com.google.common.collect.Queues;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Queue;
import snownee.lychee.Lychee;
import snownee.lychee.util.action.Job;
import snownee.lychee.util.context.LycheeContext;

public class ActionContext {
    public static final Codec<ActionContext> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.optionalFieldOf("avoid_default", (Object)false).forGetter(it -> it.avoidDefault), (App)Codec.INT.fieldOf("state").flatXmap(it -> {
        try {
            return DataResult.success((Object)((Object)State.values()[it]));
        }
        catch (Throwable t) {
            return DataResult.error(t::getMessage);
        }
    }, it -> DataResult.success((Object)it.ordinal())).forGetter(it -> it.state), (App)Codec.list(Job.CODEC).fieldOf("jobs").xmap(Queues::newLinkedBlockingQueue, it -> it.stream().toList()).orElse((Object)Queues.newLinkedBlockingQueue()).forGetter(it -> it.jobs)).apply((Applicative)instance, ActionContext::new));
    public boolean avoidDefault = false;
    public State state = State.RUNNING;
    public Queue<Job> jobs = Queues.newLinkedBlockingQueue();

    public ActionContext() {
    }

    ActionContext(boolean avoidDefault, State state, Queue<Job> jobs) {
        this.avoidDefault = avoidDefault;
        this.state = state;
        this.jobs = jobs;
    }

    public void reset() {
        this.avoidDefault = false;
        this.state = State.RUNNING;
        this.jobs.clear();
    }

    public void run(LycheeContext context) {
        while (!this.jobs.isEmpty()) {
            Job job = this.jobs.poll();
            try {
                job.apply(context);
                if (this.state == State.RUNNING) continue;
                break;
            }
            catch (Throwable e) {
                Lychee.LOGGER.error("Error running action {}", job.action().type(), (Object)e);
                this.state = State.STOPPED;
            }
        }
        if (this.state == State.RUNNING || this.jobs.isEmpty()) {
            this.state = State.STOPPED;
        }
    }

    public static enum State {
        RUNNING,
        PAUSED,
        STOPPED;

    }
}

