/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.compat.recipeviewer.jei.category;

import com.mojang.blaze3d.platform.InputConstants;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.helpers.IPlatformFluidHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusFactory;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.runtime.IJeiKeyMapping;
import mezz.jei.api.runtime.IJeiRuntime;
import mezz.jei.api.runtime.IRecipesGui;
import mezz.jei.common.input.IInternalKeyMappings;
import net.minecraft.core.Holder;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import snownee.jade.api.config.IWailaConfig;
import snownee.lychee.compat.recipeviewer.RvHelper;
import snownee.lychee.util.ClientProxy;
import snownee.lychee.util.ui.InputAction;

public class JeiRvHelper
extends RvHelper {
    public static final JeiRvHelper INSTANCE = new JeiRvHelper();
    @Nullable
    private IJeiRuntime runtime;
    @Nullable
    private IJeiHelpers jeiHelpers;

    @Override
    public boolean doAction(ItemStack stack, InputAction.Direct action) {
        RecipeIngredientRole role;
        if (this.runtime == null) {
            return false;
        }
        IRecipesGui recipesGui = this.runtime.getRecipesGui();
        IFocusFactory focusFactory = this.runtime.getJeiHelpers().getFocusFactory();
        RecipeIngredientRole recipeIngredientRole = role = action == InputAction.Direct.SHOW_USAGES ? RecipeIngredientRole.INPUT : RecipeIngredientRole.OUTPUT;
        if (!stack.isEmpty()) {
            recipesGui.show(focusFactory.createFocus(role, (IIngredientType)VanillaTypes.ITEM_STACK, (Object)stack));
            return true;
        }
        return false;
    }

    @Override
    public boolean doAction(Fluid fluid, InputAction.Direct action) {
        if (this.runtime == null) {
            return false;
        }
        IRecipesGui recipesGui = this.runtime.getRecipesGui();
        IJeiHelpers helpers = this.runtime.getJeiHelpers();
        IPlatformFluidHelper fluidHelper = helpers.getPlatformFluidHelper();
        IFocusFactory focusFactory = helpers.getFocusFactory();
        RecipeIngredientRole role = action == InputAction.Direct.SHOW_USAGES ? RecipeIngredientRole.INPUT : RecipeIngredientRole.OUTPUT;
        recipesGui.show(focusFactory.createFocus(role, (IIngredientType)fluidHelper.getFluidIngredientType(), (Object)((FluidStack)fluidHelper.create((Holder)fluid.builtInRegistryHolder(), fluidHelper.bucketVolume()))));
        return true;
    }

    @Override
    public Optional<InputAction.Direct> toDirectAction(InputAction action) {
        if (action instanceof InputAction.Direct) {
            InputAction.Direct direct = (InputAction.Direct)action;
            return Optional.of(direct);
        }
        if (this.runtime == null) {
            return Optional.empty();
        }
        try {
            IInternalKeyMappings keyMappings = (IInternalKeyMappings)this.runtime.getKeyMappings();
            List<Map.Entry<IJeiKeyMapping, InputAction.Direct>> keys = List.of(Map.entry(keyMappings.getShowRecipe(), InputAction.Direct.SHOW_RECIPES), Map.entry(keyMappings.getShowUses(), InputAction.Direct.SHOW_USAGES), Map.entry(keyMappings.getBookmark(), InputAction.Direct.FAVORITE));
            for (Map.Entry<IJeiKeyMapping, InputAction.Direct> entry : keys) {
                InputConstants.Key key = action.keyMapping();
                if (key == InputConstants.UNKNOWN || !entry.getKey().isActiveAndMatches(key)) continue;
                return Optional.ofNullable(entry.getValue());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Optional.empty();
    }

    @Override
    public boolean appendModName() {
        if (ClientProxy.hasJade && IWailaConfig.get().getGeneral().showItemModNameTooltip()) {
            return true;
        }
        return this.jeiHelpers != null && this.jeiHelpers.getModIdHelper().isDisplayingModNameEnabled();
    }

    @ApiStatus.Internal
    public void setRuntime(@Nullable IJeiRuntime runtime) {
        this.runtime = runtime;
    }

    @ApiStatus.Internal
    public void setJeiHelpers(@Nullable IJeiHelpers jeiHelpers) {
        this.jeiHelpers = jeiHelpers;
    }

    public IJeiRuntime jeiRuntime() {
        return Objects.requireNonNull(this.runtime);
    }

    public IJeiHelpers jeiHelpers() {
        return Objects.requireNonNull(this.jeiHelpers);
    }
}

