/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.compat.recipeviewer.element;

import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2f;
import org.joml.Vector2fc;
import snownee.kiwi.loader.Platform;
import snownee.lychee.client.gui.AllGuiTextures;
import snownee.lychee.client.gui.InteractiveRenderElement;
import snownee.lychee.client.gui.RenderElement;
import snownee.lychee.ui.SpriteElementRenderer;

public class ShadowElement {
    private final int blockSize;
    private final int shadowWidth;
    private final int shadowHeight;
    @Nullable
    private RenderElement darkShadow;
    @Nullable
    private RenderElement lightShadow;

    public ShadowElement(int blockSize, int shadowWidth, int shadowHeight) {
        this.blockSize = blockSize;
        this.shadowWidth = shadowWidth;
        this.shadowHeight = shadowHeight;
    }

    public RenderElement get(boolean light) {
        RenderElement shadow;
        RenderElement renderElement = shadow = light ? this.lightShadow : this.darkShadow;
        if (shadow != null) {
            return shadow;
        }
        ResourceLocation id = light ? AllGuiTextures.LIGHT_SHADOW.id : AllGuiTextures.SHADOW.id;
        shadow = new SpriteElementRenderer(id).withSize(this.shadowWidth, this.shadowHeight);
        if (light) {
            this.lightShadow = shadow;
        } else {
            this.darkShadow = shadow;
        }
        return shadow;
    }

    public InteractiveRenderElement blockWithShadow(Supplier<BlockState> blockStateSupplier, Function<BlockState, RenderElement> blockElement) {
        return InteractiveRenderElement.create(graphics -> {
            int lightEmission;
            BlockState blockState = (BlockState)blockStateSupplier.get();
            if (blockState.isAir()) {
                RenderElement.create(AllGuiTextures.QUESTION_MARK).at(2.0f, 2.0f).render(graphics);
                return;
            }
            RenderElement element = (RenderElement)blockElement.apply(blockState);
            float x = element.position.x + (float)this.blockSize * 0.5f - (float)this.shadowWidth * 0.5f;
            float y = element.position.y + (float)this.blockSize - (float)this.shadowHeight * 0.4f;
            Vector2f shadowPosition = new Vector2f(x, y);
            if (!Platform.isProduction() && Screen.hasControlDown()) {
                graphics.pose().pushPose();
                graphics.pose().translate(0.0f, 0.0f, 1000.0f);
                graphics.renderOutline((int)element.x(), (int)element.y(), this.blockSize, this.blockSize, -1996554240);
                graphics.pose().popPose();
            }
            if ((lightEmission = blockState.getLightEmission()) < 5) {
                ((RenderElement)this.get(false).at((Vector2fc)shadowPosition)).debugOutline(graphics, 65280).render(graphics);
            } else if (lightEmission > 7) {
                ((RenderElement)this.get(true).at((Vector2fc)shadowPosition)).debugOutline(graphics, 65280).render(graphics);
            }
            element.render(graphics);
        });
    }
}

