/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.compat.recipeviewer.category;

import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;
import snownee.lychee.compat.recipeviewer.RvHelper;
import snownee.lychee.compat.recipeviewer.category.RvCategory;
import snownee.lychee.compat.recipeviewer.category.RvCategoryInstance;
import snownee.lychee.compat.recipeviewer.category.RvCategoryInstanceImpl;
import snownee.lychee.util.context.LycheeContext;
import snownee.lychee.util.recipe.ILycheeRecipe;
import snownee.lychee.util.recipe.LycheeRecipeType;

public final class RvCategoryInstanceProviders {
    public static final Map<ResourceLocation, RvCategoryProvider<?>> ALL = new Reference2ReferenceOpenHashMap();

    public static <R extends ILycheeRecipe<LycheeContext>> RvCategoryProvider<R> register(LycheeRecipeType<R> recipeType, SimpleRvCategoryProvider<R> provider) {
        RvCategoryProvider result = (type, helper) -> id -> provider.get(type, (ResourceLocation)id, helper);
        ALL.put(recipeType.categoryId, result);
        return result;
    }

    @Nullable
    public static <R extends ILycheeRecipe<LycheeContext>> RvCategoryProvider<R> get(ResourceLocation id) {
        if (ALL.containsKey(id)) {
            return ALL.get(id);
        }
        RvCategoryProvider provider = (type, helper) -> $ -> new RvCategoryInstanceImpl(type, (ResourceLocation)$, helper);
        ALL.put(id, provider);
        return provider;
    }

    @FunctionalInterface
    public static interface SimpleRvCategoryProvider<R extends ILycheeRecipe<LycheeContext>> {
        public RvCategoryInstance<R> get(RvCategory<R> var1, ResourceLocation var2, RvHelper var3);
    }

    @FunctionalInterface
    public static interface RvCategoryProvider<R extends ILycheeRecipe<LycheeContext>> {
        public Function<ResourceLocation, RvCategoryInstance<R>> get(RvCategory<R> var1, RvHelper var2);
    }
}

