/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.compat.recipeviewer;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import net.minecraft.advancements.critereon.BlockPredicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.joml.Quaternionf;
import snownee.lychee.client.gui.CustomLightingSettings;
import snownee.lychee.client.gui.ILightingSettings;
import snownee.lychee.compat.recipeviewer.IngredientInfo;
import snownee.lychee.compat.recipeviewer.IngredientType;
import snownee.lychee.util.CommonProxy;
import snownee.lychee.util.action.ActionRenderer;
import snownee.lychee.util.action.PostAction;
import snownee.lychee.util.context.LycheeContext;
import snownee.lychee.util.predicates.BlockPredicateExtensions;
import snownee.lychee.util.recipe.BlockKeyableRecipe;
import snownee.lychee.util.recipe.ILycheeRecipe;
import snownee.lychee.util.render.CachedRenderingEntity;

public final class RVs {
    public static final CachedRenderingEntity<PrimedTnt> TNT = CachedRenderingEntity.ofFactory(arg_0 -> ((EntityType)EntityType.TNT).create(arg_0));
    public static final CachedRenderingEntity<LightningBolt> LIGHTNING_BOLT = CachedRenderingEntity.ofFactory(arg_0 -> ((EntityType)EntityType.LIGHTNING_BOLT).create(arg_0));
    public static ILightingSettings BLOCK_LIGHTING = CustomLightingSettings.builder().firstLightRotation(-45.0f, -45.0f).secondLightRotation(15.0f, -60.0f).build();
    public static ILightingSettings SIDE_ICON_LIGHTING = CustomLightingSettings.builder().firstLightRotation(-30.0f, -60.0f).secondLightRotation(30.0f, -60.0f).build();
    public static ILightingSettings ENTITY_LIGHTING = CustomLightingSettings.builder().firstLightRotation(-120.0f, 20.0f).secondLightRotation(200.0f, 45.0f).build();

    public static List<IngredientInfo> generateShapelessInputs(ILycheeRecipe<LycheeContext> recipe) {
        List<IngredientInfo> ingredients;
        try {
            ingredients = recipe.sizedIngredients().stream().map(IngredientInfo::new).toList();
        }
        catch (Exception e) {
            ingredients = recipe.getIngredients().stream().map(IngredientInfo::new).toList();
        }
        for (PostAction action : recipe.postActions()) {
            ActionRenderer.of(action).loadCatalystsInfo(action, recipe, ingredients);
        }
        RVs.addIngredientTips(recipe, ingredients);
        return ingredients;
    }

    public static void addIngredientTips(ILycheeRecipe<LycheeContext> recipe, List<IngredientInfo> ingredients) {
        for (IngredientInfo ingredient : ingredients) {
            IngredientType type = CommonProxy.getIngredientType(ingredient.ingredient);
            if (type == IngredientType.NORMAL) continue;
            ingredient.addTooltip((Component)Component.translatable((String)("tip.lychee.ingredient." + type.name().toLowerCase(Locale.ROOT))));
        }
    }

    public static MutableComponent makeTitle(ResourceLocation id) {
        int i;
        String key = id.toLanguageKey("recipeType");
        if ("/minecraft/default".equals(key.substring(i = key.indexOf(47)))) {
            key = key.substring(0, i);
        }
        return Component.translatable((String)key);
    }

    public static List<Component> getRecipeTooltip(ILycheeRecipe<?> recipe) {
        ArrayList list = Lists.newArrayList();
        if (recipe.comment().map(it -> !Strings.isNullOrEmpty((String)it)).orElse(false).booleanValue()) {
            String comment = recipe.comment().orElseThrow();
            if (I18n.exists((String)comment)) {
                comment = I18n.get((String)comment, (Object[])new Object[0]);
            }
            Splitter.on((char)'\n').splitToStream((CharSequence)comment).map(Component::literal).forEach(list::add);
        }
        Minecraft mc = Minecraft.getInstance();
        recipe.conditions().appendToTooltips(list, (Level)mc.level, (Player)mc.player, 0);
        return list;
    }

    public static <T extends BlockKeyableRecipe> Pair<BlockState, Integer> getMostUsedBlock(Collection<? extends RecipeHolder<? extends T>> recipes) {
        Object2IntOpenHashMap blockStateCount = new Object2IntOpenHashMap();
        HashMap blockPredicateMap = Maps.newHashMap();
        for (RecipeHolder<T> recipeHolder : recipes) {
            BlockKeyableRecipe recipe = (BlockKeyableRecipe)recipeHolder.value();
            for (Block block : BlockPredicateExtensions.matchedBlocks(recipe.blockPredicate())) {
                if (block.defaultBlockState().isAir()) continue;
                blockStateCount.mergeInt((Object)block, 1, Integer::sum);
                blockPredicateMap.putIfAbsent(block, recipe.blockPredicate());
            }
        }
        if (blockStateCount.isEmpty()) {
            return Pair.of((Object)Blocks.AIR.defaultBlockState(), (Object)0);
        }
        return blockStateCount.object2IntEntrySet().stream().max(Comparator.comparingInt(Object2IntMap.Entry::getIntValue)).map($ -> Pair.of((Object)BlockPredicateExtensions.anyBlockState((BlockPredicate)blockPredicateMap.get($.getKey())), (Object)$.getIntValue())).orElseGet(() -> Pair.of((Object)Blocks.AIR.defaultBlockState(), (Object)0));
    }

    public static void renderTnt(GuiGraphics graphics) {
        PrimedTnt tnt = TNT.getEntity();
        int fuse = 80 - tnt.tickCount % 80;
        if (fuse >= 40) {
            return;
        }
        TNT.earlySetLevel();
        tnt.setFuse(fuse);
        float toRad = (float)Math.PI / 180;
        Quaternionf quaternion = new Quaternionf().rotateXYZ(200.0f * toRad, -20.0f * toRad, 0.0f);
        ENTITY_LIGHTING.applyLighting();
        TNT.render(graphics.pose(), quaternion);
    }

    public static void renderLightning(GuiGraphics graphics, float x, float y) {
        LightningBolt entity = LIGHTNING_BOLT.getEntity();
        int time = entity.tickCount % 80;
        if (time > 7) {
            return;
        }
        float toRad = (float)Math.PI / 180;
        Quaternionf quaternion = new Quaternionf().rotateXYZ(200.0f * toRad, -20.0f * toRad, 0.0f);
        if (time % 3 == 0) {
            entity.seed = entity.tickCount;
        }
        ENTITY_LIGHTING.applyLighting();
        LIGHTNING_BOLT.setScale(2.0f);
        LIGHTNING_BOLT.getTranslation().set(x, y, 20.0f);
        LIGHTNING_BOLT.render(graphics.pose(), quaternion);
    }

    public static ResourceLocation composeCategoryIdentifier(ResourceLocation categoryId, ResourceLocation group) {
        return ResourceLocation.fromNamespaceAndPath((String)categoryId.getNamespace(), (String)"%s/%s/%s".formatted(categoryId.getPath(), group.getNamespace(), group.getPath()));
    }

    public static BlockState getIconBlock(Collection<? extends RecipeHolder<? extends BlockKeyableRecipe>> recipes) {
        ClientPacketListener con = Minecraft.getInstance().getConnection();
        if (con == null) {
            return Blocks.AIR.defaultBlockState();
        }
        return (BlockState)RVs.getMostUsedBlock(recipes).getFirst();
    }
}

