/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.compat.recipe_api;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.Nullable;
import snownee.kiwi.recipe.CustomIngredient;
import snownee.kiwi.recipe.CustomIngredientSerializer;
import snownee.lychee.Lychee;

public class VisualOnlyComponentsIngredient
implements CustomIngredient {
    public static final ResourceLocation ID = Lychee.id("visual_only_components");
    public static final CustomIngredientSerializer<VisualOnlyComponentsIngredient> SERIALIZER = new Serializer();
    private final Ingredient base;
    private final DataComponentPatch components;

    public VisualOnlyComponentsIngredient(Ingredient base, DataComponentPatch components) {
        if (components.isEmpty()) {
            throw new IllegalArgumentException("ComponentIngredient must have at least one defined component");
        }
        this.base = base;
        this.components = components;
    }

    public boolean test(ItemStack stack) {
        return this.base.test(stack);
    }

    public List<ItemStack> getMatchingStacks() {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>(List.of(this.base.getItems()));
        stacks.replaceAll(stack -> {
            ItemStack copy = stack.copy();
            stack.applyComponents(this.components);
            return copy;
        });
        stacks.removeIf(stack -> !this.base.test(stack));
        return stacks;
    }

    public boolean requiresTesting() {
        return !this.base.isSimple();
    }

    public CustomIngredientSerializer<?> getSerializer() {
        return SERIALIZER;
    }

    private Ingredient getBase() {
        return this.base;
    }

    @Nullable
    private DataComponentPatch getComponents() {
        return this.components;
    }

    private static class Serializer
    implements CustomIngredientSerializer<VisualOnlyComponentsIngredient> {
        private static final MapCodec<VisualOnlyComponentsIngredient> ALLOW_EMPTY_CODEC = Serializer.createCodec((Codec<Ingredient>)Ingredient.CODEC);
        private static final MapCodec<VisualOnlyComponentsIngredient> DISALLOW_EMPTY_CODEC = Serializer.createCodec((Codec<Ingredient>)Ingredient.CODEC_NONEMPTY);
        private static final StreamCodec<RegistryFriendlyByteBuf, VisualOnlyComponentsIngredient> PACKET_CODEC = StreamCodec.composite((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, VisualOnlyComponentsIngredient::getBase, (StreamCodec)DataComponentPatch.STREAM_CODEC, VisualOnlyComponentsIngredient::getComponents, VisualOnlyComponentsIngredient::new);

        private Serializer() {
        }

        private static MapCodec<VisualOnlyComponentsIngredient> createCodec(Codec<Ingredient> ingredientCodec) {
            return RecordCodecBuilder.mapCodec(instance -> instance.group((App)ingredientCodec.fieldOf("base").forGetter(VisualOnlyComponentsIngredient::getBase), (App)DataComponentPatch.CODEC.fieldOf("components").forGetter(VisualOnlyComponentsIngredient::getComponents)).apply((Applicative)instance, VisualOnlyComponentsIngredient::new));
        }

        public ResourceLocation getIdentifier() {
            return ID;
        }

        public MapCodec<VisualOnlyComponentsIngredient> getCodec(boolean allowEmpty) {
            return allowEmpty ? ALLOW_EMPTY_CODEC : DISALLOW_EMPTY_CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, VisualOnlyComponentsIngredient> getPacketCodec() {
            return PACKET_CODEC;
        }
    }
}

