/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.client.gui;

import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.util.FastColor;
import org.joml.Vector2f;
import org.joml.Vector2fc;
import org.joml.Vector2i;
import org.joml.Vector2ic;
import org.joml.Vector3fc;
import snownee.kiwi.loader.Platform;
import snownee.lychee.client.gui.InteractiveRenderElement;
import snownee.lychee.client.gui.ScreenElement;
import snownee.lychee.client.gui.SimpleRenderElement;
import snownee.lychee.util.ui.UIElementCommonProperties;

public abstract class RenderElement
implements ScreenElement,
Renderable {
    public Vector2f position = new Vector2f();
    public Vector2i size = new Vector2i(UIElementCommonProperties.DEFAULT_SIZE);
    protected float z = 0.0f;
    protected float alpha = 1.0f;

    public static RenderElement empty() {
        return new RenderElement(){

            @Override
            public void render(GuiGraphics graphics) {
            }
        };
    }

    public static RenderElement create(BiConsumer<GuiGraphics, RenderElement> renderable) {
        return new SimpleRenderElement(renderable);
    }

    public static RenderElement create(Function<RenderElement, ScreenElement> renderable) {
        return new SimpleRenderElement(it -> (graphics, element) -> renderable.apply((RenderElement)element));
    }

    public static InteractiveRenderElement create(ScreenElement element) {
        return InteractiveRenderElement.create(element);
    }

    public <T extends RenderElement> T at(float x, float y) {
        this.position.set(x, y);
        return (T)this;
    }

    public <T extends RenderElement> T at(Vector2fc position) {
        return this.at(position.x(), position.y());
    }

    public <T extends RenderElement> T offset(float x, float y) {
        this.position.add(x, y);
        return (T)this;
    }

    public <T extends RenderElement> T offset(Vector2fc position) {
        return this.offset(position.x(), position.y());
    }

    public <T extends RenderElement> T at(float x, float y, float z) {
        this.at(x, y);
        this.z = z;
        return (T)this;
    }

    public <T extends RenderElement> T at(Vector3fc position) {
        return this.at(position.x(), position.y(), position.z());
    }

    public <T extends RenderElement> T atZ(float z) {
        this.z = z;
        return (T)this;
    }

    public <T extends RenderElement> T withSize(int width, int height) {
        this.size.set(width, height);
        return (T)this;
    }

    public <T extends RenderElement> T withSize(Vector2ic size) {
        return this.withSize(size.x(), size.y());
    }

    public <T extends RenderElement> T withSize(int size) {
        this.withSize(size, size);
        return (T)this;
    }

    public <T extends RenderElement> T withAlpha(float alpha) {
        this.alpha = alpha;
        return (T)this;
    }

    public int width() {
        return this.size.x();
    }

    public int height() {
        return this.size.y();
    }

    public float x() {
        return this.position.x();
    }

    public float y() {
        return this.position.y();
    }

    public float z() {
        return this.z;
    }

    public boolean containsMouse(double mouseX, double mouseY) {
        return mouseX >= (double)this.x() && mouseY >= (double)this.y() && mouseX <= (double)(this.x() + (float)this.width()) && mouseY <= (double)(this.y() + (float)this.height());
    }

    public void render(GuiGraphics graphics, int offsetX, int offsetY) {
        graphics.pose().pushPose();
        graphics.pose().translate((float)offsetX, (float)offsetY, 0.0f);
        this.render(graphics);
        graphics.pose().popPose();
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.render(guiGraphics);
    }

    public <T extends RenderElement> T debugOutline(GuiGraphics graphics, int color) {
        if (Platform.isProduction() || !Screen.hasControlDown()) {
            return (T)this;
        }
        if (FastColor.ARGB32.alpha((int)color) == 0) {
            color |= 0x88000000;
        }
        graphics.pose().pushPose();
        graphics.pose().translate(0.0f, 0.0f, 1000.0f);
        graphics.renderOutline(Math.round(this.x()), Math.round(this.y()), this.width(), this.height(), color);
        graphics.pose().popPose();
        return (T)this;
    }
}

