/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.action.input;

import com.google.common.base.Preconditions;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import snownee.lychee.util.CommonProxy;
import snownee.lychee.util.Reference;
import snownee.lychee.util.action.PostAction;
import snownee.lychee.util.action.PostActionCommonProperties;
import snownee.lychee.util.action.PostActionType;
import snownee.lychee.util.action.PostActionTypes;
import snownee.lychee.util.codec.LycheeCodecs;
import snownee.lychee.util.context.LycheeContext;
import snownee.lychee.util.context.LycheeContextKey;
import snownee.lychee.util.input.ExtendedItemStackHolder;
import snownee.lychee.util.json.JsonPointer;
import snownee.lychee.util.recipe.ILycheeRecipe;

public record SetItem(PostActionCommonProperties commonProperties, ItemStack itemStack, Reference target) implements PostAction
{
    public PostActionType<SetItem> type() {
        return PostActionTypes.SET_ITEM;
    }

    @Override
    public void apply(@Nullable ILycheeRecipe<?> recipe, LycheeContext context, int times) {
        IntList indexes = recipe.getItemIndexes(this.target);
        RegistryAccess registryAccess = context.level().registryAccess();
        for (Integer index : indexes) {
            CompoundTag tag = (CompoundTag)context.getItem(index).save((HolderLookup.Provider)registryAccess);
            ItemStack stack = this.getPath().isEmpty() ? this.itemStack.copy() : ItemStack.parseOptional((HolderLookup.Provider)registryAccess, (CompoundTag)CommonProxy.jsonToTag(new JsonPointer(this.getPath().get()).find(context.get(LycheeContextKey.JSON))));
            context.setItem(index, stack);
            if (!stack.isEmpty()) {
                ((CompoundTag)context.getItem(index).saveOptional((HolderLookup.Provider)registryAccess)).merge(tag);
            }
            ((ExtendedItemStackHolder)context.get(LycheeContextKey.ITEM).get(index)).setConsumption(0);
        }
    }

    @Override
    public Component getDisplayName() {
        return this.itemStack.getHoverName();
    }

    @Override
    public List<ItemStack> getOutputItems() {
        return List.of(this.itemStack);
    }

    @Override
    public boolean repeatable() {
        return false;
    }

    @Override
    public void validate(ILycheeRecipe<?> recipe) {
        Preconditions.checkArgument((!recipe.getItemIndexes(this.target).isEmpty() ? 1 : 0) != 0, (String)"No target found for %s", (Object)this.target);
    }

    public static class Type
    implements PostActionType<SetItem> {
        public static final MapCodec<SetItem> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)PostActionCommonProperties.MAP_CODEC.forGetter(SetItem::commonProperties), (App)LycheeCodecs.ITEM_STACK_MAP_CODEC.forGetter(SetItem::itemStack), (App)Reference.CODEC.optionalFieldOf("target", (Object)Reference.DEFAULT).forGetter(SetItem::target)).apply((Applicative)instance, SetItem::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, SetItem> STREAM_CODEC = StreamCodec.composite(PostActionCommonProperties.STREAM_CODEC, SetItem::commonProperties, (StreamCodec)ItemStack.OPTIONAL_STREAM_CODEC, SetItem::itemStack, Reference.STREAM_CODEC, SetItem::target, SetItem::new);

        @Override
        public MapCodec<SetItem> codec() {
            return CODEC;
        }

        @Override
        public StreamCodec<RegistryFriendlyByteBuf, SetItem> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

