/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.action.input;

import com.google.common.base.Preconditions;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.ints.IntList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import org.jetbrains.annotations.Nullable;
import snownee.lychee.context.LootParamsContext;
import snownee.lychee.util.Reference;
import snownee.lychee.util.action.PostAction;
import snownee.lychee.util.action.PostActionCommonProperties;
import snownee.lychee.util.action.PostActionType;
import snownee.lychee.util.action.PostActionTypes;
import snownee.lychee.util.context.LycheeContext;
import snownee.lychee.util.context.LycheeContextKey;
import snownee.lychee.util.input.ExtendedItemStackHolder;
import snownee.lychee.util.input.ItemStackHolderCollection;
import snownee.lychee.util.recipe.ILycheeRecipe;

public record DamageItem(PostActionCommonProperties commonProperties, int damage, Reference target) implements PostAction
{
    public PostActionType<DamageItem> type() {
        return PostActionTypes.DAMAGE_ITEM;
    }

    @Override
    public void apply(@Nullable ILycheeRecipe<?> recipe, LycheeContext context, int times) {
        IntList indexes = recipe.getItemIndexes(this.target);
        LootParamsContext lootParams = context.get(LycheeContextKey.LOOT_PARAMS);
        Entity thisEntity = (Entity)lootParams.get(LootContextParams.THIS_ENTITY);
        ItemStackHolderCollection itemStackHolders = context.get(LycheeContextKey.ITEM);
        for (Integer index : indexes) {
            ServerPlayer player;
            ExtendedItemStackHolder stackHolder = (ExtendedItemStackHolder)itemStackHolders.get(index);
            if (!stackHolder.get().isDamageableItem()) {
                return;
            }
            stackHolder.setConsumption(0);
            ItemStack itemStack = (ItemStack)itemStackHolders.split(index, 1).get();
            itemStack.hurtAndBreak(this.damage, (ServerLevel)context.level(), thisEntity instanceof ServerPlayer ? (player = (ServerPlayer)thisEntity) : null, it -> {
                if (thisEntity instanceof LivingEntity) {
                    LivingEntity livingEntity = (LivingEntity)thisEntity;
                    EquipmentSlot hand = null;
                    if (livingEntity.getMainHandItem() == itemStack) {
                        hand = EquipmentSlot.MAINHAND;
                    } else if (livingEntity.getOffhandItem() == itemStack) {
                        hand = EquipmentSlot.OFFHAND;
                    }
                    if (hand != null) {
                        livingEntity.onEquippedItemBroken(it, hand);
                    }
                }
                Item item = itemStack.getItem();
                itemStack.shrink(1);
                if (thisEntity instanceof Player) {
                    Player player = (Player)thisEntity;
                    player.awardStat(Stats.ITEM_BROKEN.get((Object)item));
                }
                itemStack.setDamageValue(0);
            });
        }
    }

    @Override
    public boolean hidden() {
        return true;
    }

    @Override
    public boolean repeatable() {
        return false;
    }

    @Override
    public void validate(ILycheeRecipe<?> recipe) {
        Preconditions.checkArgument((!recipe.getItemIndexes(this.target).isEmpty() ? 1 : 0) != 0, (String)"No target found for %s", (Object)this.target);
    }

    public static class Type
    implements PostActionType<DamageItem> {
        public static final MapCodec<DamageItem> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)PostActionCommonProperties.MAP_CODEC.forGetter(DamageItem::commonProperties), (App)Codec.INT.optionalFieldOf("damage", (Object)1).forGetter(DamageItem::damage), (App)Reference.CODEC.optionalFieldOf("target", (Object)Reference.DEFAULT).forGetter(DamageItem::target)).apply((Applicative)instance, DamageItem::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, DamageItem> STREAM_CODEC = StreamCodec.composite(PostActionCommonProperties.STREAM_CODEC, DamageItem::commonProperties, (StreamCodec)ByteBufCodecs.VAR_INT, DamageItem::damage, Reference.STREAM_CODEC, DamageItem::target, DamageItem::new);

        @Override
        public MapCodec<DamageItem> codec() {
            return CODEC;
        }

        @Override
        public StreamCodec<RegistryFriendlyByteBuf, DamageItem> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

