/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.action;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundExplodePacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import snownee.lychee.LycheeRegistries;
import snownee.lychee.context.LootParamsContext;
import snownee.lychee.util.CommonProxy;
import snownee.lychee.util.action.PostAction;
import snownee.lychee.util.action.PostActionCommonProperties;
import snownee.lychee.util.action.PostActionType;
import snownee.lychee.util.action.PostActionTypes;
import snownee.lychee.util.codec.LycheeCodecs;
import snownee.lychee.util.context.LycheeContext;
import snownee.lychee.util.context.LycheeContextKey;
import snownee.lychee.util.recipe.ILycheeRecipe;

public record Explode(PostActionCommonProperties commonProperties, Explosion.BlockInteraction blockInteraction, BlockPos offset, boolean fire, float radius, float step) implements PostAction
{
    private void explode(Level level, @Nullable Entity source, Vec3 pos, float radius) {
        Explosion explosion = new Explosion(level, source, pos.x, pos.y, pos.z, radius, this.fire, this.blockInteraction);
        explosion.explode();
        explosion.finalizeExplosion(true);
        if (!explosion.interactsWithBlocks()) {
            explosion.clearToBlow();
        }
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            for (ServerPlayer player : serverLevel.players()) {
                if (!(player.distanceToSqr(pos) < 4096.0)) continue;
                player.connection.send((Packet)new ClientboundExplodePacket(pos.x, pos.y, pos.z, radius, explosion.getToBlow(), (Vec3)explosion.getHitPlayers().get(player), this.blockInteraction, (ParticleOptions)ParticleTypes.EXPLOSION, (ParticleOptions)ParticleTypes.EXPLOSION_EMITTER, (Holder)SoundEvents.GENERIC_EXPLODE));
            }
        }
    }

    public PostActionType<Explode> type() {
        return PostActionTypes.EXPLODE;
    }

    @Override
    public void apply(@Nullable ILycheeRecipe<?> recipe, LycheeContext context, int times) {
        LootParamsContext lootParams = context.get(LycheeContextKey.LOOT_PARAMS);
        Vec3 pos = ((Vec3)lootParams.get(LootContextParams.ORIGIN)).add(Vec3.atLowerCornerOf((Vec3i)this.offset));
        float boundedRadius = Math.min(this.radius + this.step * (Mth.sqrt((float)times) - 1.0f), this.radius * 4.0f);
        this.explode(context.level(), (Entity)lootParams.get(LootContextParams.THIS_ENTITY), pos, boundedRadius);
    }

    @Override
    public Component getDisplayName() {
        return Component.translatable((String)(CommonProxy.makeDescriptionId("postAction", LycheeRegistries.POST_ACTION.getKey(this.type())) + "." + this.blockInteraction.name().toLowerCase(Locale.ENGLISH)));
    }

    public static class Type
    implements PostActionType<Explode> {
        public static final MapCodec<Explode> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)PostActionCommonProperties.MAP_CODEC.forGetter(Explode::commonProperties), (App)ExtraCodecs.NON_EMPTY_STRING.comapFlatMap(it -> switch (it) {
            case "none", "keep" -> DataResult.success((Object)Explosion.BlockInteraction.KEEP);
            case "break", "destroy_with_decay" -> DataResult.success((Object)Explosion.BlockInteraction.DESTROY_WITH_DECAY);
            case "destroy" -> DataResult.success((Object)Explosion.BlockInteraction.DESTROY);
            default -> DataResult.error(() -> "Unexpected value: " + it);
        }, it -> it.name().toLowerCase(Locale.ENGLISH)).optionalFieldOf("block_interaction", (Object)Explosion.BlockInteraction.DESTROY).forGetter(Explode::blockInteraction), (App)LycheeCodecs.OFFSET_CODEC.forGetter(Explode::offset), (App)Codec.BOOL.optionalFieldOf("fire", (Object)false).forGetter(Explode::fire), (App)ExtraCodecs.POSITIVE_FLOAT.optionalFieldOf("radius", (Object)Float.valueOf(4.0f)).forGetter(Explode::radius), (App)Codec.FLOAT.optionalFieldOf("radius_step", (Object)Float.valueOf(4.0f)).forGetter(Explode::step)).apply((Applicative)instance, Explode::new));

        @Override
        public MapCodec<Explode> codec() {
            return CODEC;
        }
    }
}

