/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.action;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import org.jetbrains.annotations.Nullable;
import snownee.lychee.context.LootParamsContext;
import snownee.lychee.util.action.PostAction;
import snownee.lychee.util.action.PostActionCommonProperties;
import snownee.lychee.util.action.PostActionType;
import snownee.lychee.util.action.PostActionTypes;
import snownee.lychee.util.context.LycheeContext;
import snownee.lychee.util.context.LycheeContextKey;
import snownee.lychee.util.recipe.ILycheeRecipe;

public record AddItemCooldown(PostActionCommonProperties commonProperties, float seconds, Optional<Item> item) implements PostAction
{
    @Override
    public PostActionType<?> type() {
        return PostActionTypes.ADD_ITEM_COOLDOWN;
    }

    @Override
    public void apply(@Nullable ILycheeRecipe<?> recipe, LycheeContext context, int times) {
        LootParamsContext lootParams = context.get(LycheeContextKey.LOOT_PARAMS);
        Player player = (Player)lootParams.get(LootContextParams.THIS_ENTITY);
        ItemStack item = context.getItem(0);
        player.getCooldowns().addCooldown(this.item.orElse(item.getItem()), (int)(this.seconds * 20.0f * (float)times));
    }

    @Override
    public boolean hidden() {
        return true;
    }

    public static class Type
    implements PostActionType<AddItemCooldown> {
        public static final MapCodec<AddItemCooldown> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)PostActionCommonProperties.MAP_CODEC.forGetter(AddItemCooldown::commonProperties), (App)ExtraCodecs.POSITIVE_FLOAT.fieldOf("s").forGetter(AddItemCooldown::seconds), (App)BuiltInRegistries.ITEM.byNameCodec().optionalFieldOf("item").forGetter(AddItemCooldown::item)).apply((Applicative)i, AddItemCooldown::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, AddItemCooldown> STREAM_CODEC = StreamCodec.composite(PostActionCommonProperties.STREAM_CODEC, AddItemCooldown::commonProperties, (StreamCodec)ByteBufCodecs.FLOAT, AddItemCooldown::seconds, (StreamCodec)ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.registry((ResourceKey)Registries.ITEM)), AddItemCooldown::item, AddItemCooldown::new);

        @Override
        public MapCodec<AddItemCooldown> codec() {
            return CODEC;
        }

        @Override
        public StreamCodec<RegistryFriendlyByteBuf, AddItemCooldown> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

