/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee;

import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeSerializer;
import snownee.lychee.Lychee;
import snownee.lychee.recipes.AnvilCraftingRecipe;
import snownee.lychee.recipes.BlockClickingRecipe;
import snownee.lychee.recipes.BlockCrushingRecipe;
import snownee.lychee.recipes.BlockExplodingRecipe;
import snownee.lychee.recipes.BlockInteractingRecipe;
import snownee.lychee.recipes.DripstoneRecipe;
import snownee.lychee.recipes.EntityTickingRecipe;
import snownee.lychee.recipes.ItemBurningRecipe;
import snownee.lychee.recipes.ItemExplodingRecipe;
import snownee.lychee.recipes.ItemInsideRecipe;
import snownee.lychee.recipes.LightningChannelingRecipe;
import snownee.lychee.recipes.RandomBlockTickingRecipe;
import snownee.lychee.recipes.ShapedCraftingRecipe;
import snownee.lychee.util.recipe.LycheeRecipeSerializer;
import snownee.lychee.util.ui.BlankRecipe;
import snownee.lychee.util.ui.CategoryMetadata;
import snownee.lychee.util.ui.CategoryModifier;

public final class RecipeSerializers {
    public static final RecipeSerializer<CategoryMetadata> CATEGORY_METADATA = RecipeSerializers.register("category_metadata", new CategoryMetadata.Serializer());
    public static final RecipeSerializer<CategoryModifier> CATEGORY_MODIFIER = RecipeSerializers.register("category_modifier", new CategoryModifier.Serializer());
    public static final LycheeRecipeSerializer<BlankRecipe> BLANK = RecipeSerializers.register("blank", new BlankRecipe.Serializer());
    public static final LycheeRecipeSerializer<ItemBurningRecipe> ITEM_BURNING = RecipeSerializers.register("item_burning", new ItemBurningRecipe.Serializer());
    public static final LycheeRecipeSerializer<ItemInsideRecipe> ITEM_INSIDE = RecipeSerializers.register("item_inside", new ItemInsideRecipe.Serializer());
    public static final LycheeRecipeSerializer<BlockInteractingRecipe> BLOCK_INTERACTING = RecipeSerializers.register("block_interacting", new BlockInteractingRecipe.Serializer());
    public static final LycheeRecipeSerializer<BlockClickingRecipe> BLOCK_CLICKING = RecipeSerializers.register("block_clicking", new BlockClickingRecipe.Serializer());
    public static final LycheeRecipeSerializer<AnvilCraftingRecipe> ANVIL_CRAFTING = RecipeSerializers.register("anvil_crafting", new AnvilCraftingRecipe.Serializer());
    public static final LycheeRecipeSerializer<BlockCrushingRecipe> BLOCK_CRUSHING = RecipeSerializers.register("block_crushing", new BlockCrushingRecipe.Serializer());
    public static final LycheeRecipeSerializer<LightningChannelingRecipe> LIGHTNING_CHANNELING = RecipeSerializers.register("lightning_channeling", new LightningChannelingRecipe.Serializer());
    public static final LycheeRecipeSerializer<ItemExplodingRecipe> ITEM_EXPLODING = RecipeSerializers.register("item_exploding", new ItemExplodingRecipe.Serializer());
    public static final LycheeRecipeSerializer<BlockExplodingRecipe> BLOCK_EXPLODING = RecipeSerializers.register("block_exploding", new BlockExplodingRecipe.Serializer());
    public static final LycheeRecipeSerializer<RandomBlockTickingRecipe> RANDOM_BLOCK_TICKING = RecipeSerializers.register("random_block_ticking", new RandomBlockTickingRecipe.Serializer());
    public static final LycheeRecipeSerializer<DripstoneRecipe> DRIPSTONE_DRIPPING = RecipeSerializers.register("dripstone_dripping", new DripstoneRecipe.Serializer());
    public static final RecipeSerializer<ShapedCraftingRecipe> CRAFTING = RecipeSerializers.register("crafting", new ShapedCraftingRecipe.Serializer());
    public static final LycheeRecipeSerializer<EntityTickingRecipe> ENTITY_TICKING = RecipeSerializers.register("entity_ticking", new EntityTickingRecipe.Serializer());

    public static <T extends RecipeSerializer<?>> T register(String id, T serializer) {
        return (T)((RecipeSerializer)Registry.register((Registry)BuiltInRegistries.RECIPE_SERIALIZER, (ResourceLocation)Lychee.id(id), serializer));
    }
}

