/*
 * Decompiled with CFR 0.152.
 */
package me.srrapero720.waterframes.mixin.impl;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import me.srrapero720.waterframes.DisplaysConfig;
import me.srrapero720.waterframes.WaterFrames;
import me.srrapero720.waterframes.common.block.entity.DisplayTile;
import net.minecraft.Util;
import net.minecraft.server.MinecraftServer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={MinecraftServer.class})
public class MinecraftServerMixin {
    @Unique
    private static long wf$lastWarnTime = 0L;
    @Unique
    private static long wf$lastMillisTime = 0L;
    @Unique
    private static long wf$timeStack = 0L;

    @WrapOperation(method={"runServer"}, at={@At(value="INVOKE", target="Lnet/minecraft/Util;getNanos()J", ordinal=0)})
    public long redirect$runServer$getMillis(Operation<Long> original) {
        wf$lastMillisTime = Util.getMillis();
        return (Long)original.call(new Object[0]);
    }

    @WrapOperation(method={"runServer"}, at={@At(value="INVOKE", target="Lnet/minecraft/Util;getNanos()J", ordinal=1)})
    public long redirect$runServer$getMillisWhile(Operation<Long> original) {
        if (!DisplaysConfig.useLagTickCorrection()) {
            return (Long)original.call(new Object[0]);
        }
        long millis = Util.getMillis();
        long time = millis - wf$lastMillisTime;
        if (time > 100L) {
            wf$timeStack += time;
        }
        if (wf$timeStack > 3000L) {
            DisplayTile.setLagTickTime(wf$timeStack);
            if (millis - wf$lastWarnTime > 15000L) {
                WaterFrames.LOGGER.warn("Server seems overloading, jumping {}ms or {} ticks", (Object)wf$timeStack, (Object)(wf$timeStack / 50L));
                wf$lastWarnTime = millis;
            }
            wf$timeStack %= 2000L;
        }
        wf$lastMillisTime = (Long)original.call(new Object[0]);
        return wf$lastMillisTime;
    }
}

