/*
 * Decompiled with CFR 0.152.
 */
package me.srrapero720.waterframes.common.block;

import com.mojang.serialization.MapCodec;
import me.srrapero720.waterframes.DisplaysRegistry;
import me.srrapero720.waterframes.common.block.DisplayBlock;
import me.srrapero720.waterframes.common.block.entity.ProjectorTile;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.server.permission.nodes.PermissionNode;
import team.creative.creativecore.common.util.math.base.Facing;
import team.creative.creativecore.common.util.math.box.AlignedBox;

@MethodsReturnNonnullByDefault
public class ProjectorBlock
extends DisplayBlock {
    public static final MapCodec<ProjectorBlock> CODEC = ProjectorBlock.simpleCodec(ProjectorBlock::new);

    public ProjectorBlock() {
    }

    public ProjectorBlock(BlockBehaviour.Properties p) {
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @Override
    public DirectionProperty getFacing() {
        return BlockStateProperties.HORIZONTAL_FACING;
    }

    @Override
    public PermissionNode<Boolean> getPermissionNode() {
        return DisplaysRegistry.PERM_DISPLAYS_INTERACT_PROJECTOR;
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.getValue((Property)this.getFacing());
        Facing facing = Facing.get((Direction)direction);
        AlignedBox box = new AlignedBox();
        box.maxY = 0.5f;
        float blockThickness = 0.25f;
        box.setMin(facing.axis, blockThickness);
        box.setMax(facing.axis, 1.0f - blockThickness);
        Facing clockWise = Facing.get((Direction)direction.getClockWise());
        box.setMin(clockWise.axis, 0.0625f);
        box.setMax(clockWise.axis, 0.9375f);
        return box.voxelShape();
    }

    @Override
    public void registerDefaultState(BlockState state) {
        super.registerDefaultState((BlockState)state.setValue((Property)VISIBLE, (Comparable)Boolean.valueOf(true)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition((StateDefinition.Builder<Block, BlockState>)builder.add(new Property[]{VISIBLE}));
    }

    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return new ProjectorTile(pPos, pState);
    }
}

