/*
 * Decompiled with CFR 0.152.
 */
package me.srrapero720.waterframes;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import me.srrapero720.waterframes.DisplaysRegistry;
import me.srrapero720.waterframes.WaterFrames;
import me.srrapero720.waterframes.common.block.DisplayBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.neoforged.neoforge.server.permission.nodes.PermissionNode;

public class DisplaysConfig {
    private static final Pattern HOSTS_PATTERN = Pattern.compile("^(?!-)([a-zA-Z0-9-]{1,63}\\.)+[a-zA-Z]{2,63}$");
    private static final ModConfigSpec.Builder SERVER = new ModConfigSpec.Builder();
    private static final ModConfigSpec.Builder CLIENT = new ModConfigSpec.Builder();
    private static final String[] WHITELIST = new String[]{"imgur.com", "gyazo.com", "prntscr.com", "tinypic.com", "puu.sh", "pinimg.com", "photobucket.com", "staticflickr.com", "flic.kr", "tenor.co", "tenor.com", "gfycat.com", "giphy.com", "gph.is", "gifbin.com", "i.redd.it", "media.tumblr.com", "twimg.com", "githubusercontent.com", "googleusercontent.com", "googleapis.com", "wikimedia.org", "ytimg.com", "youtube.com", "youtu.be", "twitch.tv", "twitter.com", "x.com", "soundcloud.com", "kick.com", "streamable.com", "srrapero720.me", "fbcdn.net", "drive.google.com"};
    private static final ModConfigSpec.DoubleValue maxWidth;
    private static final ModConfigSpec.DoubleValue maxHeight;
    private static final ModConfigSpec.IntValue maxRenderDistance;
    private static final ModConfigSpec.DoubleValue maxProjectionDistance;
    private static final ModConfigSpec.IntValue maxVolumeDistance;
    private static final ModConfigSpec.IntValue maxVolume;
    private static final ModConfigSpec.BooleanValue useMasterVolume;
    private static final ModConfigSpec.BooleanValue useVSEurekaCompat;
    private static final ModConfigSpec.BooleanValue useMultimedia;
    private static final ModConfigSpec.BooleanValue keepRendering;
    private static final ModConfigSpec.BooleanValue useLightsOnPlay;
    private static final ModConfigSpec.BooleanValue forceLightsOnPlay;
    private static final ModConfigSpec.BooleanValue useLagTickCorrection;
    private static final ModConfigSpec.BooleanValue useRedstone;
    private static final ModConfigSpec.BooleanValue useMasterModeOnRedstone;
    public static final ModConfigSpec.BooleanValue useExperimentalPlaylistMode;
    private static final ModConfigSpec.IntValue remoteDistance;
    private static final ModConfigSpec.BooleanValue usePermissionsAPI;
    private static final ModConfigSpec.BooleanValue useInAdventure;
    private static final ModConfigSpec.BooleanValue useInSurvival;
    private static final ModConfigSpec.BooleanValue useForAnyone;
    private static final ModConfigSpec.BooleanValue useBindingRemotes;
    private static final ModConfigSpec.BooleanValue useRemotes;
    private static final ModConfigSpec.BooleanValue useWhitelist;
    private static final ModConfigSpec.BooleanValue blackWhitelist;
    private static final ModConfigSpec.BooleanValue allowSaving;
    private static final ModConfigSpec.ConfigValue<List<? extends String>> whitelist;
    private static final ModConfigSpec.BooleanValue overrideServerConfig;
    private static final ModConfigSpec.BooleanValue clientUseMultimedia;
    private static final ModConfigSpec.BooleanValue clientKeepsRendering;
    private static final ModConfigSpec.BooleanValue clientShaderMode;
    private static final ModConfigSpec.BooleanValue forceDevMode;
    private static final ModConfigSpec SERVER_SPEC;
    private static final ModConfigSpec CLIENT_SPEC;

    public static void init(IEventBus bus, ModContainer container) {
        container.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)SERVER_SPEC);
        if (FMLLoader.getDist().isClient()) {
            container.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)CLIENT_SPEC);
        }
    }

    public static float maxWidth() {
        return (float)((Double)maxWidth.get()).doubleValue();
    }

    public static float maxHeight() {
        return (float)((Double)maxHeight.get()).doubleValue();
    }

    public static float maxWidth(float width) {
        return Math.min(width, DisplaysConfig.maxWidth());
    }

    public static float maxHeight(float height) {
        return Math.min(height, DisplaysConfig.maxHeight());
    }

    public static int maxRenDis() {
        return (Integer)maxRenderDistance.get();
    }

    public static int maxRenDis(int value) {
        return Math.min(value, DisplaysConfig.maxRenDis());
    }

    public static float maxProjDis() {
        return (float)((Double)maxProjectionDistance.get()).doubleValue();
    }

    public static float maxProjDis(float value) {
        return Math.min(value, DisplaysConfig.maxProjDis());
    }

    public static boolean keepsRendering() {
        return (Boolean)overrideServerConfig.get() != false ? (Boolean)clientKeepsRendering.get() : (Boolean)keepRendering.get();
    }

    public static boolean useLightOnPlay() {
        return (Boolean)useLightsOnPlay.get();
    }

    public static boolean forceLightOnPlay() {
        return (Boolean)forceLightsOnPlay.get();
    }

    public static boolean useLagTickCorrection() {
        return (Boolean)useLagTickCorrection.get();
    }

    public static int maxVolDis() {
        return (Integer)maxVolumeDistance.get();
    }

    public static int maxVolDis(int value) {
        return Math.min(value, DisplaysConfig.maxVolDis());
    }

    public static boolean useMasterVolume() {
        return (Boolean)useMasterVolume.get();
    }

    public static boolean vsEurekaCompat() {
        return (Boolean)useVSEurekaCompat.get();
    }

    public static int maxVol() {
        return (Integer)maxVolume.get();
    }

    public static int maxVol(int value) {
        return Math.max(Math.min(value, DisplaysConfig.maxVol()), 0);
    }

    public static boolean useMultimedia() {
        return (Boolean)overrideServerConfig.get() != false ? (Boolean)clientUseMultimedia.get() : (Boolean)useMultimedia.get();
    }

    public static boolean useRedstone() {
        return (Boolean)useRedstone.get();
    }

    public static boolean useMasterModeRedstone() {
        return DisplaysConfig.useRedstone() && (Boolean)useMasterModeOnRedstone.get() != false;
    }

    public static int maxRcDis() {
        return (Integer)remoteDistance.get();
    }

    public static boolean shaderMode() {
        return (Boolean)clientShaderMode.get();
    }

    public static void shaderMode(boolean value) {
        clientShaderMode.set((Object)value);
    }

    public static boolean useInAdv() {
        return (Boolean)useInAdventure.get();
    }

    public static boolean useInSurv() {
        return (Boolean)useInSurvival.get();
    }

    public static boolean useForAnyone() {
        return (Boolean)useForAnyone.get();
    }

    public static boolean useWhitelist() {
        return (Boolean)useWhitelist.get();
    }

    public static boolean useWhitelist(boolean state) {
        useWhitelist.set((Object)state);
        useWhitelist.save();
        return state;
    }

    public static boolean toggleWhitelist() {
        return DisplaysConfig.useWhitelist(!DisplaysConfig.useWhitelist());
    }

    public static void addOnWhitelist(String url) {
        Set<String> w = DisplaysConfig.mutableSet(((List)whitelist.get()).iterator());
        w.add(url);
        whitelist.set(new ArrayList(w));
        whitelist.save();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean removeOnWhitelist(String url) {
        Set w = DisplaysConfig.mutableSet(((List)whitelist.get()).iterator());
        boolean removed = false;
        try {
            boolean bl = removed = w.remove(url);
            return bl;
        }
        finally {
            if (removed) {
                whitelist.set(new ArrayList(w));
                whitelist.save();
            }
        }
    }

    public static boolean isWhiteListed(URI uri) {
        if (!DisplaysConfig.useWhitelist()) {
            return true;
        }
        String scheme = uri.getScheme();
        if (scheme == null) {
            return false;
        }
        if (scheme.equals("water")) {
            return true;
        }
        String host = uri.getHost();
        if (host == null) {
            return false;
        }
        for (String s : (List)whitelist.get()) {
            if (!host.endsWith("." + s) && !host.equals(s)) continue;
            return (Boolean)blackWhitelist.get() == false;
        }
        return (Boolean)blackWhitelist.get();
    }

    public static <T> Set<T> mutableSet(Iterator<T> it) {
        HashSet<T> list = new HashSet<T>();
        while (it.hasNext()) {
            list.add(it.next());
        }
        return list;
    }

    public static boolean canSave(Player player, String url) {
        boolean valid;
        URI uri = WaterFrames.createURI(url);
        boolean bl = valid = uri != null || url.isEmpty();
        if (((Boolean)usePermissionsAPI.get()).booleanValue()) {
            boolean canSave = DisplaysRegistry.getPermBoolean(player.getUUID(), DisplaysRegistry.PERM_DISPLAYS_EDIT);
            boolean canBypass = DisplaysRegistry.getPermBoolean(player.getUUID(), DisplaysRegistry.PERM_WHITELIST_BYPASS);
            boolean whitelisted = DisplaysConfig.isWhiteListed(uri);
            if (canSave && (whitelisted || canBypass)) {
                return valid;
            }
            return false;
        }
        boolean canSave = (Boolean)allowSaving.get();
        if (DisplaysConfig.isAdmin(player)) {
            return valid;
        }
        if (url.isEmpty()) {
            return true;
        }
        return valid && canSave && DisplaysConfig.isWhiteListed(uri);
    }

    public static boolean canInteractBlock(Player player, DisplayBlock block) {
        GameType gameType;
        if (((Boolean)usePermissionsAPI.get()).booleanValue()) {
            PermissionNode<Boolean> NODE = block.getPermissionNode();
            return DisplaysRegistry.getPermBoolean(player.getUUID(), DisplaysRegistry.PERM_DISPLAYS_INTERACT) || DisplaysRegistry.getPermBoolean(player.getUUID(), NODE);
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            v0 = serverPlayer.gameMode.getGameModeForPlayer();
        } else {
            v0 = gameType = Minecraft.getInstance().gameMode.getPlayerMode();
        }
        if (DisplaysConfig.isAdmin(player)) {
            return true;
        }
        if (!DisplaysConfig.useInSurv() && gameType.equals((Object)GameType.SURVIVAL)) {
            return false;
        }
        if (!DisplaysConfig.useInAdv() && gameType.equals((Object)GameType.ADVENTURE)) {
            return false;
        }
        return DisplaysConfig.useForAnyone();
    }

    public static boolean canInteractRemote(Player player) {
        if (((Boolean)usePermissionsAPI.get()).booleanValue()) {
            return DisplaysRegistry.getPermBoolean(player.getUUID(), DisplaysRegistry.PERM_REMOTE_INTERACT) || DisplaysConfig.isOwner(player);
        }
        if (DisplaysConfig.isAdmin(player)) {
            return true;
        }
        return (Boolean)useRemotes.get();
    }

    public static boolean canBindRemote(Player player) {
        if (((Boolean)usePermissionsAPI.get()).booleanValue()) {
            return DisplaysRegistry.getPermBoolean(player.getUUID(), DisplaysRegistry.PERM_REMOTE_BIND) || DisplaysConfig.isOwner(player);
        }
        if (DisplaysConfig.isAdmin(player)) {
            return true;
        }
        return (Boolean)useBindingRemotes.get();
    }

    public static boolean isAdmin(Player player) {
        Level level = player.level;
        boolean owner = DisplaysConfig.isOwner(player);
        if (owner) {
            return true;
        }
        if (level.isClientSide()) {
            IntegratedServer integrated = Minecraft.getInstance().getSingleplayerServer();
            if (integrated != null) {
                return integrated.isSingleplayerOwner(player.getGameProfile()) || player.hasPermissions(integrated.getOperatorUserPermissionLevel());
            }
            return player.hasPermissions(4);
        }
        return player.hasPermissions(4);
    }

    public static boolean isOwner(Player player) {
        String name = player.getGameProfile().getName();
        return name.equals("SrRaapero720") || name.equals("SrRapero720");
    }

    public static boolean isDevMode() {
        return !FMLLoader.isProduction() || (Boolean)forceDevMode.get() != false;
    }

    public static void setPlaylistMode(boolean v) {
        useExperimentalPlaylistMode.set((Object)v);
        useExperimentalPlaylistMode.save();
    }

    static {
        SERVER.comment("All configurations about rendering");
        SERVER.push("waterframes.rendering");
        maxWidth = SERVER.comment("Width limit of displays in blocks").defineInRange("maxWidth", 40.0, 1.0, 256.0);
        maxHeight = SERVER.comment("Height limit of displays in blocks").defineInRange("maxHeight", 40.0, 1.0, 256.0);
        maxRenderDistance = SERVER.comment("Max Radius of rendering distance in blocks").defineInRange("maxRenderDistance", 64, 4, 512);
        maxProjectionDistance = SERVER.comment("Max distance of projections in blocks").defineInRange("maxProjectionDistance", 64.0, 4.0, 512.0);
        keepRendering = SERVER.comment("Enables media processing and rendering, disabling it will not render nothing, you can still hear videos").define("keepRendering", true);
        SERVER.comment("Configuration related to multimedia sources like Videos or Music");
        SERVER.pop().push("multimedia");
        maxVolumeDistance = SERVER.comment("Max volume distance radius").defineInRange("maxVolumeDistance", 64, 8, 512);
        maxVolume = SERVER.comment(new String[]{"Max volume value", "values over 100 uses VLC \u00fcberVolume"}).defineInRange("maxVolume", 100, 10, 120);
        useMasterVolume = SERVER.comment("Makes Minecraft master volume affects waterframes volume").define("masterVolume", false);
        useVSEurekaCompat = SERVER.comment(new String[]{"Enables compatibility with VSEureka", "In case VS breaks something on their side, this option should stop client/server crashing", "Or if the audio isn't working, disable this option should help", "(This option is called VSEureka because valkirienskies is too long, and VS may be misleading)"}).define("vsEurekaCompat", true);
        SERVER.push("watermedia");
        useMultimedia = SERVER.comment("Enables VLC/FFMPEG usage for multimedia processing like videos and music (support added by WATERMeDIA)").define("enable", true);
        SERVER.comment("Configuration related to interactions with vanilla and modded features");
        SERVER.pop(2).push("block_behavior");
        useLightsOnPlay = SERVER.comment("Enable light feature on frames while is playing").define("lightOnPlay", true);
        forceLightsOnPlay = SERVER.comment(new String[]{"Forces light feature on frames while is playing", "Requires lightOnPlay be true"}).define("forceLightOnPlay", false);
        useLagTickCorrection = SERVER.comment(new String[]{"Enable lag tick time correction", "Helps when server is too laggy and playback is regressing in time", "Disable if causes problems"}).define("lagTickCorrection", true);
        SERVER.comment("Redstone interaction options");
        SERVER.push("redstone");
        useRedstone = SERVER.comment("Enable the feature").define("enable", true);
        useMasterModeOnRedstone = SERVER.comment("Redstone inputs forces paused playback and ignores any other control sources").define("masterMode", false);
        useExperimentalPlaylistMode = SERVER.comment("Experimental playlist mode, this will make the display to play a list of videos").define("experimentalPlaylistMode", false);
        SERVER.pop();
        SERVER.comment("Configuration related to remote control");
        SERVER.pop().push("remote_control");
        remoteDistance = SERVER.comment("Distance in blocks of RC range").defineInRange("distance", 32, 4, 256);
        SERVER.comment("Configurations related to permissions");
        SERVER.pop().push("permissions");
        usePermissionsAPI = SERVER.comment(new String[]{"Enables Permission API integration [(Neo)Forge only]", "(Neo)Forge provides its own permissions API compatible with permissions mods like Luckperms or FTB Ranks", "This config enables integrations and ignores all below settings"}).define("usePermissionsAPI", false);
        useInAdventure = SERVER.comment("Changes if players in Adventure mode can use displays").define("usableInAdventureMode", false);
        useInSurvival = SERVER.comment("Changes if players in Survival mode can use displays").define("usableInSurvivalMode", true);
        useForAnyone = SERVER.comment("Changes if any player can use displays, otherwise only admins can use it").define("usableForAnyone", true);
        allowSaving = SERVER.comment("Allow saving for anyone without OP permissions").define("allowSaving", true);
        useRemotes = SERVER.comment("Allow interacting (open gui) for all remotes").define("usableRemote", true);
        useBindingRemotes = SERVER.comment("Allow binding remotes on any display").define("usableRemoteBinding", true);
        SERVER.comment("Whitelist configuration: please stop bugging me with this :(");
        SERVER.push("whitelist");
        useWhitelist = SERVER.comment(new String[]{"Enables whitelist feature", "[WARNING]: THE AUTHOR OF THE MOD (SRRAPERO720) IS NOT RESPONSIBLE IF IN YOUR SERVER SOMEONE PUTS NSFW MEDIA", "WATERMEDIA HAVE SUPPORT FOR ADULT PAGES AND WHITELIST WAS DESIGNED TO PREVENT THAT", "MIMIMIMI THE KIDS, SHUT UP, I GIVE YOU THE OPTIONS ENABLED _BY DEFAULT_ TO PREVENT THAT"}).define("enable", true);
        blackWhitelist = SERVER.comment("Moves the whitelist into the darkside").define("blacklistMode", false);
        whitelist = SERVER.defineList("urls", Arrays.asList(WHITELIST), o -> HOSTS_PATTERN.matcher((String)o).find());
        SERVER.pop();
        SERVER.pop();
        CLIENT.push("waterframes");
        CLIENT.comment("Configurations to override server config");
        CLIENT.push("overrideConfig");
        overrideServerConfig = CLIENT.comment("Enables the option").define("enable", false);
        clientUseMultimedia = CLIENT.comment(new String[]{"Overrides 'waterframes.watermedia.enable' option", "Enables VLC/FFMPEG usage for multimedia processing (support added by WATERMeDIA)"}).define("useMultimedia", false);
        clientKeepsRendering = CLIENT.comment(new String[]{"overrides 'waterframes.rendering.keepRendering'", "Enables media processing and rendering, disabling it will not render nothing, you can still hear videos"}).define("keepRendering", false);
        clientShaderMode = CLIENT.comment(new String[]{"Enables compatibility with shaders", "This is not enabled by default because i am tired"}).define("shaderMode", false);
        forceDevMode = CLIENT.comment(new String[]{"WARNING: DO NOT CHANGE IT EXCEPT IF YOU KNOW WHAT ARE YOU DOING, TOGGLING IT ON MAY CAUSE CORRUPTIONS, UNEXPECTED BEHAVIORS OR WORLD DESTRUCTION", "forces WATERMeDIA and WATERFrAMES to run in developer mode", "This is was done for developers who has mods that causes compatibilities with waterframes (or watermedia)", "Let those modders test waterframes x incompatible mods (i see you stellarity owner)"}).define("forceDevMode", false);
        CLIENT.pop();
        CLIENT.pop();
        CLIENT_SPEC = CLIENT.build();
        SERVER_SPEC = SERVER.build();
    }
}

