/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.recipe;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.crafting.ICustomIngredient;
import snownee.kiwi.recipe.AlternativesIngredient;

public class AlternativesIngredientBuilder {
    List<Ingredient> ingredients = Lists.newArrayList();

    public static AlternativesIngredientBuilder of() {
        return new AlternativesIngredientBuilder();
    }

    public AlternativesIngredientBuilder add(Ingredient ingredient) {
        this.ingredients.add(ingredient);
        return this;
    }

    public AlternativesIngredientBuilder add(ItemLike itemLike) {
        this.ingredients.add(Ingredient.of((ItemLike[])new ItemLike[]{itemLike}));
        return this;
    }

    public AlternativesIngredientBuilder add(TagKey<Item> tag) {
        this.ingredients.add(Ingredient.of(tag));
        return this;
    }

    public AlternativesIngredientBuilder add(ICustomIngredient ingredient) {
        this.add(ingredient.toVanilla());
        return this;
    }

    public AlternativesIngredientBuilder add(String tagOrItem) {
        if (tagOrItem.startsWith("#")) {
            this.add((TagKey<Item>)TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.parse((String)tagOrItem.substring(1))));
        } else {
            Item item = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)tagOrItem));
            Preconditions.checkState((item != Items.AIR ? 1 : 0) != 0);
            this.add((ItemLike)item);
        }
        return this;
    }

    public AlternativesIngredient build() {
        ArrayList list = Lists.newArrayListWithExpectedSize((int)this.ingredients.size());
        for (Ingredient ingredient : this.ingredients) {
            list.add((JsonElement)Ingredient.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)ingredient).result().orElseThrow());
        }
        return new AlternativesIngredient(list);
    }
}

