/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createqualityoflife.statue.animation;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import fr.iglee42.createqualityoflife.packets.SyncAnimationsConfigPacket;
import fr.iglee42.createqualityoflife.statue.animation.StatueAnimation;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.createmod.catnip.platform.CatnipServices;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.UUIDUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import org.jetbrains.annotations.NotNull;

public class PublishedAnimationsManager
extends SavedData {
    public static final StreamCodec<FriendlyByteBuf, List<PublishedAnimation>> STREAM_CODEC = StreamCodec.of((buf, list) -> {
        buf.writeInt(list.size());
        for (PublishedAnimation anim : list) {
            PublishedAnimation.STREAM_CODEC.encode(buf, (Object)anim);
        }
    }, buf -> {
        int size = buf.readInt();
        ArrayList<PublishedAnimation> list = new ArrayList<PublishedAnimation>(size);
        for (int i = 0; i < size; ++i) {
            list.add((PublishedAnimation)PublishedAnimation.STREAM_CODEC.decode(buf));
        }
        return list;
    });
    public static List<PublishedAnimation> CLIENT_ANIMATIONS = new ArrayList<PublishedAnimation>();
    private final List<PublishedAnimation> animations = new ArrayList<PublishedAnimation>();

    public PublishedAnimationsManager() {
    }

    public PublishedAnimationsManager(CompoundTag tag, HolderLookup.Provider provider) {
        ListTag list = tag.getList("animations", 10);
        list.stream().map(CompoundTag.class::cast).forEach(ct -> this.animations.add((PublishedAnimation)PublishedAnimation.CODEC.parse(new Dynamic((DynamicOps)NbtOps.INSTANCE, ct)).getOrThrow()));
        this.setDirty();
    }

    @NotNull
    public CompoundTag save(CompoundTag tag, HolderLookup.Provider provider) {
        ListTag list = new ListTag();
        this.animations.forEach(a -> list.add((Object)((Tag)PublishedAnimation.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, a).getOrThrow())));
        tag.put("animations", (Tag)list);
        return tag;
    }

    @Nonnull
    public static PublishedAnimationsManager get(Level level) {
        if (level.isClientSide) {
            throw new RuntimeException("You can't access to client side!");
        }
        DimensionDataStorage storage = ((ServerLevel)level).getDataStorage();
        return (PublishedAnimationsManager)storage.computeIfAbsent(new SavedData.Factory(PublishedAnimationsManager::new, PublishedAnimationsManager::new, DataFixTypes.LEVEL), "createqol_published_animations");
    }

    public void publishAnimation(UUID publisher, String name, StatueAnimation animation) {
        this.animations.add(new PublishedAnimation(publisher, UUID.randomUUID(), name, animation));
        this.setDirty();
    }

    public void tick() {
        if (this.isDirty()) {
            CatnipServices.NETWORK.sendToAllClients((CustomPacketPayload)new SyncAnimationsConfigPacket(this.animations));
        }
    }

    public void deleteAnimation(UUID animation) {
        this.animations.removeIf(a -> a.id().equals(animation));
        this.setDirty();
    }

    public record PublishedAnimation(UUID publisher, UUID id, String name, StatueAnimation animation) {
        public static final Codec<PublishedAnimation> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)UUIDUtil.CODEC.fieldOf("publisher").forGetter(PublishedAnimation::publisher), (App)UUIDUtil.CODEC.fieldOf("id").forGetter(PublishedAnimation::id), (App)Codec.STRING.fieldOf("name").forGetter(PublishedAnimation::name), (App)StatueAnimation.CODEC.fieldOf("animation").forGetter(PublishedAnimation::animation)).apply((Applicative)instance, PublishedAnimation::new));
        public static final StreamCodec<FriendlyByteBuf, PublishedAnimation> STREAM_CODEC = StreamCodec.composite((StreamCodec)UUIDUtil.STREAM_CODEC, PublishedAnimation::publisher, (StreamCodec)UUIDUtil.STREAM_CODEC, PublishedAnimation::id, (StreamCodec)ByteBufCodecs.STRING_UTF8, PublishedAnimation::name, StatueAnimation.STREAM_CODEC, PublishedAnimation::animation, PublishedAnimation::new);
    }
}

