/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createqualityoflife.statue;

import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.simibubi.create.AllItems;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.ScrollValueHandler;
import fr.iglee42.createqualityoflife.CreateQOLLang;
import fr.iglee42.createqualityoflife.registries.ModEntityDataSerializers;
import fr.iglee42.createqualityoflife.registries.ModEntityTypes;
import fr.iglee42.createqualityoflife.registries.ModItems;
import fr.iglee42.createqualityoflife.statue.StatueMenu;
import fr.iglee42.createqualityoflife.statue.animation.StatueAnimation;
import fr.iglee42.createqualityoflife.statue.animation.StatueAnimationFrame;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Rotations;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class Statue
extends LivingEntity {
    public static final float DEFAULT_SCALE = 1.0f;
    public static final Rotations DEFAULT_ENTITY_ROTATIONS = new Rotations(0.0f, 0.0f, 0.0f);
    private static final Rotations DEFAULT_HEAD_POSE = new Rotations(0.0f, 0.0f, 0.0f);
    private static final Rotations DEFAULT_BODY_POSE = new Rotations(0.0f, 0.0f, 0.0f);
    private static final Rotations DEFAULT_LEFT_ARM_POSE = new Rotations(-10.0f, 0.0f, -10.0f);
    private static final Rotations DEFAULT_RIGHT_ARM_POSE = new Rotations(-15.0f, 0.0f, 10.0f);
    private static final Rotations DEFAULT_LEFT_LEG_POSE = new Rotations(-1.0f, 0.0f, -1.0f);
    private static final Rotations DEFAULT_RIGHT_LEG_POSE = new Rotations(1.0f, 0.0f, 1.0f);
    private static final EntityDimensions MARKER_DIMENSIONS = EntityDimensions.fixed((float)0.0f, (float)0.0f);
    private static final EntityDimensions BABY_DIMENSIONS = EntityType.ARMOR_STAND.getDimensions().scale(0.5f).withEyeHeight(0.9875f);
    public static final EntityDataAccessor<Boolean> DATA_INVULNERABLE = SynchedEntityData.defineId(Statue.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Byte> DATA_CLIENT_FLAGS = SynchedEntityData.defineId(Statue.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    public static final EntityDataAccessor<Rotations> DATA_HEAD_POSE = SynchedEntityData.defineId(Statue.class, (EntityDataSerializer)EntityDataSerializers.ROTATIONS);
    public static final EntityDataAccessor<Rotations> DATA_BODY_POSE = SynchedEntityData.defineId(Statue.class, (EntityDataSerializer)EntityDataSerializers.ROTATIONS);
    public static final EntityDataAccessor<Rotations> DATA_LEFT_ARM_POSE = SynchedEntityData.defineId(Statue.class, (EntityDataSerializer)EntityDataSerializers.ROTATIONS);
    public static final EntityDataAccessor<Rotations> DATA_RIGHT_ARM_POSE = SynchedEntityData.defineId(Statue.class, (EntityDataSerializer)EntityDataSerializers.ROTATIONS);
    public static final EntityDataAccessor<Rotations> DATA_LEFT_LEG_POSE = SynchedEntityData.defineId(Statue.class, (EntityDataSerializer)EntityDataSerializers.ROTATIONS);
    public static final EntityDataAccessor<Rotations> DATA_RIGHT_LEG_POSE = SynchedEntityData.defineId(Statue.class, (EntityDataSerializer)EntityDataSerializers.ROTATIONS);
    public static final EntityDataAccessor<Rotations> DATA_GLOBAL_ROTATIONS = SynchedEntityData.defineId(Statue.class, (EntityDataSerializer)EntityDataSerializers.ROTATIONS);
    public static final EntityDataAccessor<Byte> DATA_PLAYER_SKIN_CUSTOMISATION = SynchedEntityData.defineId(Statue.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    public static final EntityDataAccessor<Optional<UUID>> DATA_OWNER = SynchedEntityData.defineId(Statue.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);
    public static final EntityDataAccessor<Optional<ResolvableProfile>> DATA_PROFILE = SynchedEntityData.defineId(Statue.class, (EntityDataSerializer)((EntityDataSerializer)ModEntityDataSerializers.RESOLVABLE_PROFILE_ENTITY_DATA_SERIALIZER.value()));
    public static final EntityDataAccessor<Float> DATA_SCALE = SynchedEntityData.defineId(Statue.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    public static final EntityDataAccessor<Optional<StatueAnimation>> DATA_ANIMATION = SynchedEntityData.defineId(Statue.class, (EntityDataSerializer)((EntityDataSerializer)ModEntityDataSerializers.ANIMATION_ENTITY_DATA_SERIALIZER.get()));
    public static final EntityDataAccessor<Integer> DATA_ANIMATION_PROGRESS = SynchedEntityData.defineId(Statue.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Boolean> DATA_ANIMATION_REVERSING = SynchedEntityData.defineId(Statue.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> DATA_ANIMATION_PLAYING = SynchedEntityData.defineId(Statue.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Integer> DATA_SKIN = SynchedEntityData.defineId(Statue.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final Predicate<Entity> RIDABLE_MINECARTS = p_31582_ -> p_31582_ instanceof AbstractMinecart && ((AbstractMinecart)p_31582_).canBeRidden();
    private final NonNullList<ItemStack> handItems = NonNullList.withSize((int)2, (Object)ItemStack.EMPTY);
    private final NonNullList<ItemStack> armorItems = NonNullList.withSize((int)4, (Object)ItemStack.EMPTY);
    private boolean invisible;
    public long lastHit;
    private Rotations headPose = DEFAULT_HEAD_POSE;
    private Rotations bodyPose = DEFAULT_BODY_POSE;
    private Rotations leftArmPose = DEFAULT_LEFT_ARM_POSE;
    private Rotations rightArmPose = DEFAULT_RIGHT_ARM_POSE;
    private Rotations leftLegPose = DEFAULT_LEFT_LEG_POSE;
    private Rotations rightLegPose = DEFAULT_RIGHT_LEG_POSE;
    public float entityScaleO = 1.0f;
    public Rotations entityRotationsO = DEFAULT_ENTITY_ROTATIONS;

    public Statue(EntityType<? extends LivingEntity> p_31553_, Level p_31554_) {
        super(p_31553_, p_31554_);
    }

    public Statue(Level p_31556_, double p_31557_, double p_31558_, double p_31559_) {
        this((EntityType<? extends LivingEntity>)((EntityType)ModEntityTypes.STATUE.get()), p_31556_);
        this.setPos(p_31557_, p_31558_, p_31559_);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Statue.createLivingAttributes().add(Attributes.STEP_HEIGHT, 0.0);
    }

    public void baseTick() {
        super.baseTick();
        this.entityScaleO = this.getEntityScale();
        this.entityRotationsO = this.getEntityRotations();
    }

    public void refreshDimensions() {
        double d0 = this.getX();
        double d1 = this.getY();
        double d2 = this.getZ();
        super.refreshDimensions();
        this.setPos(d0, d1, d2);
    }

    private boolean hasPhysics() {
        return !this.isMarker() && !this.isNoGravity();
    }

    public boolean isEffectiveAi() {
        return super.isEffectiveAi() && this.hasPhysics();
    }

    protected void defineSynchedData(SynchedEntityData.Builder p_326283_) {
        super.defineSynchedData(p_326283_);
        p_326283_.define(DATA_INVULNERABLE, (Object)false);
        p_326283_.define(DATA_CLIENT_FLAGS, (Object)0);
        p_326283_.define(DATA_HEAD_POSE, (Object)DEFAULT_HEAD_POSE);
        p_326283_.define(DATA_BODY_POSE, (Object)DEFAULT_BODY_POSE);
        p_326283_.define(DATA_LEFT_ARM_POSE, (Object)DEFAULT_LEFT_ARM_POSE);
        p_326283_.define(DATA_RIGHT_ARM_POSE, (Object)DEFAULT_RIGHT_ARM_POSE);
        p_326283_.define(DATA_LEFT_LEG_POSE, (Object)DEFAULT_LEFT_LEG_POSE);
        p_326283_.define(DATA_RIGHT_LEG_POSE, (Object)DEFAULT_RIGHT_LEG_POSE);
        p_326283_.define(DATA_GLOBAL_ROTATIONS, (Object)DEFAULT_ENTITY_ROTATIONS);
        p_326283_.define(DATA_PLAYER_SKIN_CUSTOMISATION, (Object)Statue.getAllModelParts());
        p_326283_.define(DATA_PROFILE, Optional.empty());
        p_326283_.define(DATA_OWNER, Optional.empty());
        p_326283_.define(DATA_SCALE, (Object)Float.valueOf(1.0f));
        p_326283_.define(DATA_ANIMATION, Optional.empty());
        p_326283_.define(DATA_ANIMATION_PROGRESS, (Object)0);
        p_326283_.define(DATA_ANIMATION_REVERSING, (Object)false);
        p_326283_.define(DATA_ANIMATION_PLAYING, (Object)false);
        p_326283_.define(DATA_SKIN, (Object)0);
    }

    private static byte getAllModelParts() {
        byte value = 0;
        for (PlayerModelPart modelPart : PlayerModelPart.values()) {
            value = (byte)(value | modelPart.getMask());
        }
        return value;
    }

    public Iterable<ItemStack> getHandSlots() {
        return this.handItems;
    }

    public Iterable<ItemStack> getArmorSlots() {
        return this.armorItems;
    }

    public ItemStack getItemBySlot(EquipmentSlot slot) {
        switch (slot.getType()) {
            case HAND: {
                return (ItemStack)this.handItems.get(slot.getIndex());
            }
            case HUMANOID_ARMOR: {
                return (ItemStack)this.armorItems.get(slot.getIndex());
            }
        }
        return ItemStack.EMPTY;
    }

    public boolean canUseSlot(EquipmentSlot p_326077_) {
        return p_326077_ != EquipmentSlot.BODY;
    }

    public void setItemSlot(EquipmentSlot p_31584_, ItemStack p_31585_) {
        this.verifyEquippedItem(p_31585_);
        switch (p_31584_.getType()) {
            case HAND: {
                this.onEquipItem(p_31584_, (ItemStack)this.handItems.set(p_31584_.getIndex(), (Object)p_31585_), p_31585_);
                break;
            }
            case HUMANOID_ARMOR: {
                this.onEquipItem(p_31584_, (ItemStack)this.armorItems.set(p_31584_.getIndex(), (Object)p_31585_), p_31585_);
            }
        }
    }

    public boolean canTakeItem(ItemStack p_31638_) {
        EquipmentSlot equipmentslot = this.getEquipmentSlotForItem(p_31638_);
        return this.getItemBySlot(equipmentslot).isEmpty();
    }

    public void addAdditionalSaveData(CompoundTag nbt) {
        super.addAdditionalSaveData(nbt);
        ListTag listtag = new ListTag();
        for (ItemStack itemstack : this.armorItems) {
            listtag.add((Object)itemstack.saveOptional((HolderLookup.Provider)this.registryAccess()));
        }
        nbt.put("ArmorItems", (Tag)listtag);
        ListTag listtag1 = new ListTag();
        for (ItemStack itemstack1 : this.handItems) {
            listtag1.add((Object)itemstack1.saveOptional((HolderLookup.Provider)this.registryAccess()));
        }
        nbt.put("HandItems", (Tag)listtag1);
        nbt.putBoolean("Invisible", this.isInvisible());
        nbt.putBoolean("Small", this.isSmall());
        nbt.putBoolean("SlimArms", this.isSlimArms());
        nbt.putBoolean("ShowArms", this.isShowArms());
        nbt.putFloat("Scale", this.getEntityScale());
        if (this.isMarker()) {
            nbt.putBoolean("Marker", this.isMarker());
        }
        this.getOwner().ifPresent(owner -> nbt.putUUID("Owner", owner));
        nbt.put("Pose", (Tag)this.writePose());
        nbt.putByte("SkinParts", ((Byte)this.entityData.get(DATA_PLAYER_SKIN_CUSTOMISATION)).byteValue());
        ((Optional)this.entityData.get(DATA_PROFILE)).ifPresent(resolvableProfile -> nbt.put("Profile", (Tag)ResolvableProfile.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, resolvableProfile).getOrThrow()));
        nbt.put("Rotations", (Tag)this.getEntityRotations().save());
        nbt.putBoolean("Invulnerable", this.isInvulnerable());
        ((Optional)this.entityData.get(DATA_ANIMATION)).ifPresent(animation -> nbt.put("Animation", (Tag)StatueAnimation.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, animation).getOrThrow()));
        nbt.putInt("AnimationProgress", this.getAnimationProgress());
        nbt.putBoolean("AnimationReversing", this.isAnimationReversing());
        nbt.putBoolean("AnimationPlaying", this.isAnimationPlaying());
        nbt.putInt("Skin", this.getSkin());
    }

    public void readAdditionalSaveData(CompoundTag nbt) {
        super.readAdditionalSaveData(nbt);
        if (nbt.contains("ArmorItems", 9)) {
            ListTag listtag = nbt.getList("ArmorItems", 10);
            for (int i = 0; i < this.armorItems.size(); ++i) {
                CompoundTag compoundtag = listtag.getCompound(i);
                this.armorItems.set(i, (Object)ItemStack.parseOptional((HolderLookup.Provider)this.registryAccess(), (CompoundTag)compoundtag));
            }
        }
        if (nbt.contains("HandItems", 9)) {
            ListTag listtag1 = nbt.getList("HandItems", 10);
            for (int j = 0; j < this.handItems.size(); ++j) {
                CompoundTag compoundtag2 = listtag1.getCompound(j);
                this.handItems.set(j, (Object)ItemStack.parseOptional((HolderLookup.Provider)this.registryAccess(), (CompoundTag)compoundtag2));
            }
        }
        this.setInvisible(nbt.getBoolean("Invisible"));
        this.setSmall(nbt.getBoolean("Small"));
        this.setShowArms(nbt.getBoolean("ShowArms"));
        this.setSlimArms(nbt.getBoolean("SlimArms"));
        this.setMarker(nbt.getBoolean("Marker"));
        this.setEntityScale(nbt.getFloat("Scale"));
        Optional<Object> owner = Optional.empty();
        if (nbt.contains("Owner")) {
            owner = Optional.of(nbt.getUUID("Owner"));
        }
        this.setOwner(owner.orElse(null));
        this.noPhysics = !this.hasPhysics();
        CompoundTag compoundtag1 = nbt.getCompound("Pose");
        this.readPose(compoundtag1);
        this.entityData.set(DATA_PLAYER_SKIN_CUSTOMISATION, (Object)nbt.getByte("SkinParts"));
        Optional<Dynamic> optional = Optional.empty();
        if (nbt.contains("Profile", 10)) {
            optional = Optional.of(new Dynamic((DynamicOps)NbtOps.INSTANCE, (Object)nbt.get("Profile")));
        }
        if (optional.isEmpty()) {
            this.setProfile(null);
        } else {
            optional.map(arg_0 -> ((Codec)ResolvableProfile.CODEC).parse(arg_0)).flatMap(dataResult -> dataResult.resultOrPartial(string -> {})).ifPresent(this::setProfile);
        }
        if (nbt.contains("Rotations", 9)) {
            Rotations entityRotations = new Rotations(nbt.getList("Rotations", 5));
            this.setEntityRotations(entityRotations.getX(), entityRotations.getY(), entityRotations.getZ());
            this.entityRotationsO = this.getEntityRotations();
        }
        if (nbt.contains("Invulnerable")) {
            this.setInvulnerable(nbt.getBoolean("Invulnerable"));
        }
        Optional<Dynamic> animationOptional = Optional.empty();
        if (nbt.contains("Animation", 10)) {
            animationOptional = Optional.of(new Dynamic((DynamicOps)NbtOps.INSTANCE, (Object)nbt.get("Animation")));
        }
        if (animationOptional.isEmpty()) {
            this.setAnimation(null);
        } else {
            animationOptional.map(arg_0 -> StatueAnimation.CODEC.parse(arg_0)).flatMap(dataResult -> dataResult.resultOrPartial(s -> System.out.println((String)s))).ifPresent(this::setAnimation);
        }
        this.setAnimationProgress(nbt.getInt("AnimationProgress"));
        this.setAnimationReversing(nbt.getBoolean("AnimationReversing"));
        this.setAnimationPlaying(nbt.getBoolean("AnimationPlaying"));
        this.setSkin(nbt.getInt("Skin"));
    }

    public void setSkin(int skin) {
        this.entityData.set(DATA_SKIN, (Object)skin);
    }

    public int getSkin() {
        return (Integer)this.entityData.get(DATA_SKIN);
    }

    public void setAnimation(StatueAnimation statueAnimation) {
        this.entityData.set(DATA_ANIMATION, Optional.ofNullable(statueAnimation));
    }

    public Optional<StatueAnimation> getAnimation() {
        return (Optional)this.entityData.get(DATA_ANIMATION);
    }

    public int getAnimationProgress() {
        return (Integer)this.entityData.get(DATA_ANIMATION_PROGRESS);
    }

    public void setAnimationProgress(int progress) {
        this.entityData.set(DATA_ANIMATION_PROGRESS, (Object)progress);
    }

    public boolean isAnimationReversing() {
        return (Boolean)this.entityData.get(DATA_ANIMATION_REVERSING);
    }

    public void setAnimationReversing(boolean reversing) {
        this.entityData.set(DATA_ANIMATION_REVERSING, (Object)reversing);
    }

    public boolean isAnimationPlaying() {
        return (Boolean)this.entityData.get(DATA_ANIMATION_PLAYING);
    }

    public void setAnimationPlaying(boolean playing) {
        this.entityData.set(DATA_ANIMATION_PLAYING, (Object)playing);
    }

    private void readPose(CompoundTag p_31658_) {
        ListTag listtag = p_31658_.getList("Head", 5);
        this.setHeadPose(listtag.isEmpty() ? DEFAULT_HEAD_POSE : new Rotations(listtag));
        ListTag listtag1 = p_31658_.getList("Body", 5);
        this.setBodyPose(listtag1.isEmpty() ? DEFAULT_BODY_POSE : new Rotations(listtag1));
        ListTag listtag2 = p_31658_.getList("LeftArm", 5);
        this.setLeftArmPose(listtag2.isEmpty() ? DEFAULT_LEFT_ARM_POSE : new Rotations(listtag2));
        ListTag listtag3 = p_31658_.getList("RightArm", 5);
        this.setRightArmPose(listtag3.isEmpty() ? DEFAULT_RIGHT_ARM_POSE : new Rotations(listtag3));
        ListTag listtag4 = p_31658_.getList("LeftLeg", 5);
        this.setLeftLegPose(listtag4.isEmpty() ? DEFAULT_LEFT_LEG_POSE : new Rotations(listtag4));
        ListTag listtag5 = p_31658_.getList("RightLeg", 5);
        this.setRightLegPose(listtag5.isEmpty() ? DEFAULT_RIGHT_LEG_POSE : new Rotations(listtag5));
    }

    private CompoundTag writePose() {
        CompoundTag compoundtag = new CompoundTag();
        if (!DEFAULT_HEAD_POSE.equals((Object)this.headPose)) {
            compoundtag.put("Head", (Tag)this.headPose.save());
        }
        if (!DEFAULT_BODY_POSE.equals((Object)this.bodyPose)) {
            compoundtag.put("Body", (Tag)this.bodyPose.save());
        }
        if (!DEFAULT_LEFT_ARM_POSE.equals((Object)this.leftArmPose)) {
            compoundtag.put("LeftArm", (Tag)this.leftArmPose.save());
        }
        if (!DEFAULT_RIGHT_ARM_POSE.equals((Object)this.rightArmPose)) {
            compoundtag.put("RightArm", (Tag)this.rightArmPose.save());
        }
        if (!DEFAULT_LEFT_LEG_POSE.equals((Object)this.leftLegPose)) {
            compoundtag.put("LeftLeg", (Tag)this.leftLegPose.save());
        }
        if (!DEFAULT_RIGHT_LEG_POSE.equals((Object)this.rightLegPose)) {
            compoundtag.put("RightLeg", (Tag)this.rightLegPose.save());
        }
        return compoundtag;
    }

    public float getEntityScale() {
        return ((Float)this.entityData.get(DATA_SCALE)).floatValue();
    }

    public void setEntityScale(float scale) {
        this.entityData.set(DATA_SCALE, (Object)Float.valueOf(scale));
    }

    public boolean isPushable() {
        return false;
    }

    protected void doPush(Entity p_31564_) {
    }

    protected void pushEntities() {
        for (Entity entity : this.level().getEntities((Entity)this, this.getBoundingBox(), RIDABLE_MINECARTS)) {
            if (!(this.distanceToSqr(entity) <= 0.2)) continue;
            entity.push((Entity)this);
        }
    }

    public InteractionResult interactAt(Player player, Vec3 clickedPos, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        if (this.isMarker() || itemstack.is(Items.NAME_TAG)) {
            return InteractionResult.PASS;
        }
        if (player.isSpectator()) {
            return InteractionResult.SUCCESS;
        }
        if (player.level().isClientSide) {
            return InteractionResult.CONSUME;
        }
        if (this.isInvulnerable() && this.hasOwner() && !player.getUUID().equals(this.getOwner().get()) && !player.isCreative()) {
            player.displayClientMessage((Component)CreateQOLLang.translateDirect("statue.locked", new Object[0]).withStyle(ChatFormatting.RED), true);
            return InteractionResult.FAIL;
        }
        if (player.getItemInHand(hand).is(Items.BREAD) && player.getItemInHand(hand).getHoverName().getString().equals("OuiOuiBaguetteUwU")) {
            if (this.getSkin() == 0) {
                this.setSkin(1);
                return InteractionResult.SUCCESS;
            }
            if (this.getSkin() == 1) {
                this.setSkin(0);
                return InteractionResult.SUCCESS;
            }
        }
        if (player.getItemInHand(hand).is((Holder)AllItems.WRENCH) && this.getAnimation().isPresent()) {
            if (player.isCrouching()) {
                this.setAnimationProgress(0);
                this.setAnimationPlaying(true);
            } else {
                this.setAnimationPlaying(!this.isAnimationPlaying());
            }
            ScrollValueHandler.wrenchCog.bump(30.0);
        } else {
            EquipmentSlot slot;
            if (player.isCrouching()) {
                player.openMenu(new MenuProvider(){

                    @NotNull
                    public Component getDisplayName() {
                        return Statue.this.getDisplayName();
                    }

                    @NotNull
                    public AbstractContainerMenu createMenu(int i, Inventory inventory, Player player) {
                        return new StatueMenu(i, player.getInventory(), Statue.this);
                    }
                }, buf -> buf.writeInt(this.getId()));
                return InteractionResult.SUCCESS_NO_ITEM_USED;
            }
            EquipmentSlot equipmentslot = this.getEquipmentSlotForItem(itemstack);
            if (itemstack.isEmpty() ? this.swapItem(slot = this.getClickedSlot(clickedPos), ItemStack.EMPTY) : this.swapItem(equipmentslot, itemstack)) {
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    private boolean swapItem(EquipmentSlot slot, ItemStack stack) {
        ItemStack stackInSlot = this.getItemBySlot(slot);
        if (!stackInSlot.isEmpty()) {
            this.setItemSlot(slot, stack);
            return true;
        }
        if (!stack.isEmpty()) {
            this.setItemSlot(slot, stack.copyWithCount(1));
            return true;
        }
        return false;
    }

    public void setInvulnerable(boolean invulnerable) {
        super.setInvulnerable(invulnerable);
        this.entityData.set(DATA_INVULNERABLE, (Object)invulnerable);
    }

    public boolean isInvulnerable() {
        return (Boolean)this.entityData.get(DATA_INVULNERABLE);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private EquipmentSlot getClickedSlot(Vec3 p_31660_) {
        EquipmentSlot equipmentslot = EquipmentSlot.MAINHAND;
        boolean flag = this.isSmall();
        double d0 = p_31660_.y / (double)(this.getScale() * this.getAgeScale());
        EquipmentSlot equipmentslot1 = EquipmentSlot.FEET;
        if (d0 >= 0.1) {
            double d = flag ? 0.8 : 0.45;
            if (d0 < 0.1 + d && this.hasItemInSlot(equipmentslot1)) {
                return EquipmentSlot.FEET;
            }
        }
        double d = flag ? 0.3 : 0.0;
        if (d0 >= 0.9 + d) {
            double d2 = flag ? 1.0 : 0.7;
            if (d0 < 0.9 + d2 && this.hasItemInSlot(EquipmentSlot.CHEST)) {
                return EquipmentSlot.CHEST;
            }
        }
        if (d0 >= 0.4) {
            double d3 = flag ? 1.0 : 0.8;
            if (d0 < 0.4 + d3 && this.hasItemInSlot(EquipmentSlot.LEGS)) {
                return EquipmentSlot.LEGS;
            }
        }
        if (d0 >= 1.6 && this.hasItemInSlot(EquipmentSlot.HEAD)) {
            return EquipmentSlot.HEAD;
        }
        if (this.hasItemInSlot(EquipmentSlot.MAINHAND)) return equipmentslot;
        if (!this.hasItemInSlot(EquipmentSlot.OFFHAND)) return equipmentslot;
        return EquipmentSlot.OFFHAND;
    }

    public boolean hurt(DamageSource p_31579_, float p_31580_) {
        if (this.isRemoved()) {
            return false;
        }
        Level level = this.level();
        if (level instanceof ServerLevel) {
            Player player;
            ServerPlayer player2;
            ServerLevel serverlevel = (ServerLevel)level;
            if (p_31579_.is(DamageTypeTags.BYPASSES_INVULNERABILITY)) {
                this.kill();
                return false;
            }
            Entity entity = p_31579_.getEntity();
            if (entity instanceof ServerPlayer && !(player2 = (ServerPlayer)entity).isCreative() && this.isInvulnerable() && this.hasOwner() && !this.getOwner().get().equals(player2.getUUID())) {
                return false;
            }
            if (this.isInvulnerableTo(p_31579_) || this.invisible || this.isMarker()) {
                return false;
            }
            if (p_31579_.is(DamageTypeTags.IS_EXPLOSION)) {
                this.brokenByAnything(serverlevel, p_31579_);
                this.kill();
                return false;
            }
            if (p_31579_.is(DamageTypeTags.IGNITES_ARMOR_STANDS)) {
                if (this.isOnFire()) {
                    this.causeDamage(serverlevel, p_31579_, 0.15f);
                } else {
                    this.igniteForSeconds(5.0f);
                }
                return false;
            }
            if (p_31579_.is(DamageTypeTags.BURNS_ARMOR_STANDS) && this.getHealth() > 0.5f) {
                this.causeDamage(serverlevel, p_31579_, 4.0f);
                return false;
            }
            boolean flag1 = p_31579_.is(DamageTypeTags.CAN_BREAK_ARMOR_STAND);
            boolean flag = p_31579_.is(DamageTypeTags.ALWAYS_KILLS_ARMOR_STANDS);
            if (!flag1 && !flag) {
                return false;
            }
            Entity entity2 = p_31579_.getEntity();
            if (entity2 instanceof Player) {
                player = (Player)entity2;
                if (!player.getAbilities().mayBuild) {
                    return false;
                }
            }
            if ((entity2 = p_31579_.getEntity()) instanceof Player && (player = (Player)entity2).getMainHandItem().is((Holder)AllItems.WRENCH)) {
                this.playBrokenSound();
                if (!p_31579_.isCreativePlayer()) {
                    this.brokenByPlayer(serverlevel, p_31579_);
                }
                this.showBreakingParticles();
                this.kill();
                return true;
            }
            if (p_31579_.isCreativePlayer()) {
                this.playBrokenSound();
                this.showBreakingParticles();
                this.kill();
                return true;
            }
            long i = serverlevel.getGameTime();
            if (i - this.lastHit > 5L && !flag) {
                serverlevel.broadcastEntityEvent((Entity)this, (byte)32);
                this.gameEvent((Holder)GameEvent.ENTITY_DAMAGE, p_31579_.getEntity());
                this.lastHit = i;
            } else {
                this.brokenByPlayer(serverlevel, p_31579_);
                this.showBreakingParticles();
                this.kill();
            }
            return true;
        }
        return false;
    }

    public void handleEntityEvent(byte p_31568_) {
        if (p_31568_ == 32) {
            if (this.level().isClientSide) {
                this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), SoundEvents.ARMOR_STAND_HIT, this.getSoundSource(), 0.3f, 1.0f, false);
                this.lastHit = this.level().getGameTime();
            }
        } else {
            super.handleEntityEvent(p_31568_);
        }
    }

    public boolean shouldRenderAtSqrDistance(double p_31574_) {
        double d0 = this.getBoundingBox().getSize() * 4.0;
        if (Double.isNaN(d0) || d0 == 0.0) {
            d0 = 4.0;
        }
        return p_31574_ < (d0 *= 64.0) * d0;
    }

    private void showBreakingParticles() {
        if (this.level() instanceof ServerLevel) {
            ((ServerLevel)this.level()).sendParticles((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, Blocks.OAK_PLANKS.defaultBlockState()), this.getX(), this.getY(0.6666666666666666), this.getZ(), 10, (double)(this.getBbWidth() / 4.0f), (double)(this.getBbHeight() / 4.0f), (double)(this.getBbWidth() / 4.0f), 0.05);
        }
    }

    private void causeDamage(ServerLevel p_348633_, DamageSource p_31649_, float p_31650_) {
        float f = this.getHealth();
        if ((f -= p_31650_) <= 0.5f) {
            this.brokenByAnything(p_348633_, p_31649_);
            this.kill();
        } else {
            this.setHealth(f);
            this.gameEvent((Holder)GameEvent.ENTITY_DAMAGE, p_31649_.getEntity());
        }
    }

    private void brokenByPlayer(ServerLevel p_348677_, DamageSource p_31647_) {
        ItemStack itemstack = new ItemStack((ItemLike)ModItems.STATUE.get());
        itemstack.set(DataComponents.CUSTOM_NAME, (Object)this.getCustomName());
        Block.popResource((Level)this.level(), (BlockPos)this.blockPosition(), (ItemStack)itemstack);
        this.brokenByAnything(p_348677_, p_31647_);
    }

    private void brokenByAnything(ServerLevel p_348553_, DamageSource p_31654_) {
        this.playBrokenSound();
        this.dropAllDeathLoot(p_348553_, p_31654_);
    }

    private void playBrokenSound() {
        this.level().playSound(null, this.getX(), this.getY(), this.getZ(), AllSoundEvents.CARDBOARD_SWORD.getMainEvent(), this.getSoundSource(), 1.0f, 0.5f);
    }

    protected float tickHeadTurn(float p_31644_, float p_31645_) {
        this.yBodyRotO = this.yRotO;
        this.yBodyRot = this.getYRot();
        return 0.0f;
    }

    public void travel(Vec3 p_31656_) {
        if (this.hasPhysics()) {
            super.travel(p_31656_);
        }
    }

    public void setYBodyRot(float p_31670_) {
        this.yBodyRotO = this.yRotO = p_31670_;
        this.yHeadRotO = this.yHeadRot = p_31670_;
    }

    public void setYHeadRot(float p_31668_) {
        this.yBodyRotO = this.yRotO = p_31668_;
        this.yHeadRotO = this.yHeadRot = p_31668_;
    }

    public void tick() {
        Rotations rotations5;
        Rotations rotations4;
        Rotations rotations3;
        Rotations rotations2;
        Rotations rotations1;
        super.tick();
        Rotations rotations = (Rotations)this.entityData.get(DATA_HEAD_POSE);
        if (!this.headPose.equals((Object)rotations)) {
            this.setHeadPose(rotations);
        }
        if (!this.bodyPose.equals((Object)(rotations1 = (Rotations)this.entityData.get(DATA_BODY_POSE)))) {
            this.setBodyPose(rotations1);
        }
        if (!this.leftArmPose.equals((Object)(rotations2 = (Rotations)this.entityData.get(DATA_LEFT_ARM_POSE)))) {
            this.setLeftArmPose(rotations2);
        }
        if (!this.rightArmPose.equals((Object)(rotations3 = (Rotations)this.entityData.get(DATA_RIGHT_ARM_POSE)))) {
            this.setRightArmPose(rotations3);
        }
        if (!this.leftLegPose.equals((Object)(rotations4 = (Rotations)this.entityData.get(DATA_LEFT_LEG_POSE)))) {
            this.setLeftLegPose(rotations4);
        }
        if (!this.rightLegPose.equals((Object)(rotations5 = (Rotations)this.entityData.get(DATA_RIGHT_LEG_POSE)))) {
            this.setRightLegPose(rotations5);
        }
        if (this.level().isClientSide) {
            return;
        }
        this.tickAnimation();
    }

    public void tickAnimation() {
        this.getAnimation().ifPresent(animation -> {
            if (this.isAnimationPlaying()) {
                if (this.getAnimationProgress() < animation.getDuration() && !this.isAnimationReversing()) {
                    this.setAnimationProgress(this.getAnimationProgress() + 1);
                } else if (this.getAnimationProgress() > 0 && this.isAnimationReversing()) {
                    this.setAnimationProgress(this.getAnimationProgress() - 1);
                } else if (this.getAnimationProgress() >= animation.getDuration()) {
                    if (animation.canBeRevert()) {
                        this.setAnimationReversing(true);
                    } else {
                        this.setAnimationProgress(animation.isLooping() ? 0 : this.getAnimationProgress());
                        this.setAnimationPlaying(animation.isLooping());
                    }
                } else if (this.getAnimationProgress() <= 0) {
                    this.setAnimationReversing(false);
                    this.setAnimationPlaying(animation.isLooping());
                }
                if (animation.getFrameForProgress(this.getAnimationProgress()) != null) {
                    StatueAnimationFrame frame = animation.getFrameForProgress(this.getAnimationProgress());
                    if (animation.getNextFrame(frame) == null) {
                        this.setEntityRotations(frame.getGlobal().getXRot(), frame.getGlobal().getYRot(), frame.getGlobal().getZRot());
                        this.setHeadPose(frame.getHead().toRotation());
                        this.setLeftArmPose(frame.getLeftArm().toRotation());
                        this.setRightArmPose(frame.getRightArm().toRotation());
                        this.setLeftLegPose(frame.getLeftLeg().toRotation());
                        this.setRightLegPose(frame.getRightLeg().toRotation());
                    } else {
                        StatueAnimationFrame nextFrame = animation.getNextFrame(frame);
                        float t = (float)(this.getAnimationProgress() - frame.getTick()) / (float)(animation.getNextFrame(frame).getTick() - frame.getTick());
                        Rotations globalPart = frame.getGlobal().toRotation();
                        Rotations nextGlobalPart = nextFrame.getGlobal().toRotation();
                        this.setEntityRotations(Mth.lerp((float)t, (float)globalPart.getX(), (float)nextGlobalPart.getX()), Mth.lerp((float)t, (float)globalPart.getY(), (float)nextGlobalPart.getY()), Mth.lerp((float)t, (float)globalPart.getZ(), (float)nextGlobalPart.getZ()));
                        Rotations headPart = frame.getHead().toRotation();
                        Rotations nextHeadPart = nextFrame.getHead().toRotation();
                        this.setHeadPose(new Rotations(Mth.lerp((float)t, (float)headPart.getX(), (float)nextHeadPart.getX()), Mth.lerp((float)t, (float)headPart.getY(), (float)nextHeadPart.getY()), Mth.lerp((float)t, (float)headPart.getZ(), (float)nextHeadPart.getZ())));
                        Rotations leftArmPart = frame.getLeftArm().toRotation();
                        Rotations nextLeftArmPart = nextFrame.getLeftArm().toRotation();
                        this.setLeftArmPose(new Rotations(Mth.lerp((float)t, (float)leftArmPart.getX(), (float)nextLeftArmPart.getX()), Mth.lerp((float)t, (float)leftArmPart.getY(), (float)nextLeftArmPart.getY()), Mth.lerp((float)t, (float)leftArmPart.getZ(), (float)nextLeftArmPart.getZ())));
                        Rotations rightArmPart = frame.getRightArm().toRotation();
                        Rotations nextRightArmPart = nextFrame.getRightArm().toRotation();
                        this.setRightArmPose(new Rotations(Mth.lerp((float)t, (float)rightArmPart.getX(), (float)nextRightArmPart.getX()), Mth.lerp((float)t, (float)rightArmPart.getY(), (float)nextRightArmPart.getY()), Mth.lerp((float)t, (float)rightArmPart.getZ(), (float)nextRightArmPart.getZ())));
                        Rotations leftLegPart = frame.getLeftLeg().toRotation();
                        Rotations nextLeftLegPart = nextFrame.getLeftLeg().toRotation();
                        this.setLeftLegPose(new Rotations(Mth.lerp((float)t, (float)leftLegPart.getX(), (float)nextLeftLegPart.getX()), Mth.lerp((float)t, (float)leftLegPart.getY(), (float)nextLeftLegPart.getY()), Mth.lerp((float)t, (float)leftLegPart.getZ(), (float)nextLeftLegPart.getZ())));
                        Rotations rightLegPart = frame.getRightLeg().toRotation();
                        Rotations nextRightLegPart = nextFrame.getRightLeg().toRotation();
                        this.setRightLegPose(new Rotations(Mth.lerp((float)t, (float)rightLegPart.getX(), (float)nextRightLegPart.getX()), Mth.lerp((float)t, (float)rightLegPart.getY(), (float)nextRightLegPart.getY()), Mth.lerp((float)t, (float)rightLegPart.getZ(), (float)nextRightLegPart.getZ())));
                    }
                }
            }
        });
    }

    protected void updateInvisibilityStatus() {
        this.setInvisible(this.invisible);
    }

    public void setInvisible(boolean p_31663_) {
        this.invisible = p_31663_;
        super.setInvisible(p_31663_);
    }

    public boolean isBaby() {
        return this.isSmall();
    }

    public void kill() {
        this.remove(Entity.RemovalReason.KILLED);
        this.gameEvent((Holder)GameEvent.ENTITY_DIE);
    }

    public boolean ignoreExplosion(Explosion p_312813_) {
        return this.isInvisible();
    }

    public PushReaction getPistonPushReaction() {
        return this.isMarker() ? PushReaction.IGNORE : super.getPistonPushReaction();
    }

    public boolean isIgnoringBlockTriggers() {
        return this.isMarker();
    }

    public void setSmall(boolean p_31604_) {
        this.entityData.set(DATA_CLIENT_FLAGS, (Object)this.setBit((Byte)this.entityData.get(DATA_CLIENT_FLAGS), 1, p_31604_));
    }

    public boolean isSmall() {
        return ((Byte)this.entityData.get(DATA_CLIENT_FLAGS) & 1) != 0;
    }

    public void setShowArms(boolean p_31676_) {
        this.entityData.set(DATA_CLIENT_FLAGS, (Object)this.setBit((Byte)this.entityData.get(DATA_CLIENT_FLAGS), 4, p_31676_));
    }

    public boolean isShowArms() {
        return ((Byte)this.entityData.get(DATA_CLIENT_FLAGS) & 4) != 0;
    }

    public void setSlimArms(boolean p_31676_) {
        this.entityData.set(DATA_CLIENT_FLAGS, (Object)this.setBit((Byte)this.entityData.get(DATA_CLIENT_FLAGS), 8, p_31676_));
    }

    public boolean isSlimArms() {
        return ((Byte)this.entityData.get(DATA_CLIENT_FLAGS) & 8) != 0;
    }

    public void setMarker(boolean p_31682_) {
        this.entityData.set(DATA_CLIENT_FLAGS, (Object)this.setBit((Byte)this.entityData.get(DATA_CLIENT_FLAGS), 16, p_31682_));
    }

    public boolean isMarker() {
        return ((Byte)this.entityData.get(DATA_CLIENT_FLAGS) & 0x10) != 0;
    }

    private byte setBit(byte value, int mask, boolean status) {
        value = status ? (byte)(value | mask) : (byte)(value & ~mask);
        return value;
    }

    public void setOwner(UUID owner) {
        this.entityData.set(DATA_OWNER, owner == null ? Optional.empty() : Optional.of(owner));
    }

    public boolean hasOwner() {
        return this.getOwner().isPresent();
    }

    public Optional<UUID> getOwner() {
        return (Optional)this.entityData.get(DATA_OWNER);
    }

    public void setHeadPose(Rotations p_31598_) {
        this.headPose = p_31598_;
        this.entityData.set(DATA_HEAD_POSE, (Object)p_31598_);
    }

    public void setBodyPose(Rotations p_31617_) {
        this.bodyPose = p_31617_;
        this.entityData.set(DATA_BODY_POSE, (Object)p_31617_);
    }

    public void setLeftArmPose(Rotations p_31624_) {
        this.leftArmPose = p_31624_;
        this.entityData.set(DATA_LEFT_ARM_POSE, (Object)p_31624_);
    }

    public void setRightArmPose(Rotations p_31629_) {
        this.rightArmPose = p_31629_;
        this.entityData.set(DATA_RIGHT_ARM_POSE, (Object)p_31629_);
    }

    public void setLeftLegPose(Rotations p_31640_) {
        this.leftLegPose = p_31640_;
        this.entityData.set(DATA_LEFT_LEG_POSE, (Object)p_31640_);
    }

    public void setRightLegPose(Rotations p_31652_) {
        this.rightLegPose = p_31652_;
        this.entityData.set(DATA_RIGHT_LEG_POSE, (Object)p_31652_);
    }

    public Rotations getHeadPose() {
        return this.headPose;
    }

    public Rotations getBodyPose() {
        return this.bodyPose;
    }

    public Rotations getLeftArmPose() {
        return this.leftArmPose;
    }

    public Rotations getRightArmPose() {
        return this.rightArmPose;
    }

    public Rotations getLeftLegPose() {
        return this.leftLegPose;
    }

    public Rotations getRightLegPose() {
        return this.rightLegPose;
    }

    public boolean isPickable() {
        return super.isPickable() && !this.isMarker();
    }

    public boolean skipAttackInteraction(Entity p_31687_) {
        return p_31687_ instanceof Player && !this.level().mayInteract((Player)p_31687_, this.blockPosition());
    }

    public HumanoidArm getMainArm() {
        return HumanoidArm.RIGHT;
    }

    public LivingEntity.Fallsounds getFallSounds() {
        return new LivingEntity.Fallsounds(SoundEvents.ARMOR_STAND_FALL, SoundEvents.ARMOR_STAND_FALL);
    }

    @Nullable
    protected SoundEvent getHurtSound(DamageSource p_31636_) {
        return SoundEvents.ARMOR_STAND_HIT;
    }

    @Nullable
    protected SoundEvent getDeathSound() {
        return SoundEvents.ARMOR_STAND_BREAK;
    }

    public void thunderHit(ServerLevel p_31576_, LightningBolt p_31577_) {
    }

    public boolean isAffectedByPotions() {
        return false;
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> p_31602_) {
        if (DATA_CLIENT_FLAGS.equals(p_31602_)) {
            this.refreshDimensions();
            this.blocksBuilding = !this.isMarker();
        }
        super.onSyncedDataUpdated(p_31602_);
    }

    public boolean attackable() {
        return false;
    }

    public EntityDimensions getDefaultDimensions(Pose p_31587_) {
        return this.getDimensionsMarker(this.isMarker());
    }

    private EntityDimensions getDimensionsMarker(boolean p_31684_) {
        if (p_31684_) {
            return MARKER_DIMENSIONS;
        }
        return this.isBaby() ? BABY_DIMENSIONS : this.getType().getDimensions();
    }

    public boolean isPartShown(PlayerModelPart part) {
        return ((Byte)this.getEntityData().get(DATA_PLAYER_SKIN_CUSTOMISATION) & part.getMask()) == part.getMask();
    }

    public void setPartVisibility(PlayerModelPart modelPart, boolean visible) {
        this.entityData.set(DATA_PLAYER_SKIN_CUSTOMISATION, (Object)this.setBit((Byte)this.entityData.get(DATA_PLAYER_SKIN_CUSTOMISATION), modelPart.getMask(), visible));
    }

    public Vec3 getLightProbePosition(float p_31665_) {
        if (this.isMarker()) {
            AABB aabb = this.getDimensionsMarker(false).makeBoundingBox(this.position());
            BlockPos blockpos = this.blockPosition();
            int i = Integer.MIN_VALUE;
            for (BlockPos blockpos1 : BlockPos.betweenClosed((BlockPos)BlockPos.containing((double)aabb.minX, (double)aabb.minY, (double)aabb.minZ), (BlockPos)BlockPos.containing((double)aabb.maxX, (double)aabb.maxY, (double)aabb.maxZ))) {
                int j = Math.max(this.level().getBrightness(LightLayer.BLOCK, blockpos1), this.level().getBrightness(LightLayer.SKY, blockpos1));
                if (j == 15) {
                    return Vec3.atCenterOf((Vec3i)blockpos1);
                }
                if (j <= i) continue;
                i = j;
                blockpos = blockpos1.immutable();
            }
            return Vec3.atCenterOf((Vec3i)blockpos);
        }
        return super.getLightProbePosition(p_31665_);
    }

    public Optional<ResolvableProfile> getProfile() {
        return (Optional)this.entityData.get(DATA_PROFILE);
    }

    public void setProfile(@Nullable ResolvableProfile resolvableProfile) {
        this.entityData.set(DATA_PROFILE, Optional.ofNullable(resolvableProfile));
        if (resolvableProfile != null && !resolvableProfile.isResolved()) {
            resolvableProfile.resolve().thenAcceptAsync(newResolvableProfile -> this.entityData.set(DATA_PROFILE, Optional.of(newResolvableProfile)), SkullBlockEntity.CHECKED_MAIN_THREAD_EXECUTOR);
        }
    }

    public ItemStack getPickResult() {
        return new ItemStack((ItemLike)ModItems.STATUE.get());
    }

    public boolean canBeSeenByAnyone() {
        return !this.isInvisible() && !this.isMarker();
    }

    public static EntityType.Builder<?> build(EntityType.Builder<?> builder) {
        EntityType.Builder<?> entityBuilder = builder;
        return entityBuilder.sized(0.5f, 1.975f);
    }

    public float getEntityXRotation() {
        return this.getEntityRotations().getX();
    }

    public Rotations getEntityRotations() {
        Rotations rotations = (Rotations)this.entityData.get(DATA_GLOBAL_ROTATIONS);
        return new Rotations(rotations.getX() - 180.0f, rotations.getY() - 180.0f, rotations.getZ() - 180.0f);
    }

    public float getEntityZRotation() {
        return this.getEntityRotations().getZ();
    }

    public void setEntityXRotation(float rotationX) {
        this.setEntityRotations(rotationX, this.getYRot(), this.getEntityZRotation());
    }

    public void setEntityZRotation(float rotationZ) {
        this.setEntityRotations(this.getEntityXRotation(), this.getYRot(), rotationZ);
    }

    public void setEntityRotations(float rotationX, float rotationY, float rotationZ) {
        rotationX = Mth.clamp((float)(rotationX + 180.0f), (float)0.0f, (float)360.0f);
        rotationY = Mth.clamp((float)(rotationY + 180.0f), (float)0.0f, (float)360.0f);
        rotationZ = Mth.clamp((float)(rotationZ + 180.0f), (float)0.0f, (float)360.0f);
        this.entityData.set(DATA_GLOBAL_ROTATIONS, (Object)new Rotations(rotationX, rotationY, rotationZ));
    }

    public float getYRot() {
        return this.getEntityRotations().getY();
    }

    public void setYRot(float p_146923_) {
        this.setEntityRotations(this.getEntityXRotation(), p_146923_, this.getEntityZRotation());
    }
}

