/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createqualityoflife.client.screens.widgets.entries;

import fr.iglee42.createqualityoflife.client.screens.ArmorConfigScreen;
import fr.iglee42.createqualityoflife.client.screens.widgets.ArmorConfigScreenList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import net.createmod.catnip.lang.FontHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;

public class ValueEntry<T>
extends ArmorConfigScreenList.LabeledEntry {
    protected T value;
    protected DataComponentType<?> component;
    protected boolean editable = true;
    protected List<String> commentLines = new ArrayList<String>(List.of("."));

    public ValueEntry(String label, T value, DataComponentType<?> component, String ... comments) {
        super(label);
        this.value = value;
        this.component = component;
        this.labelTooltip.add(Component.literal((String)label).withStyle(ChatFormatting.WHITE));
        this.commentLines.addAll(Arrays.stream(comments).toList());
        this.labelTooltip.addAll(this.commentLines.stream().map(s -> s.equals(".") ? " " : s).map(Component::literal).flatMap(stc -> FontHelper.cutTextComponent((Component)stc, (FontHelper.Palette)FontHelper.Palette.GRAY_AND_RED).stream()).toList());
    }

    @Override
    public void setEditable(boolean b) {
        this.editable = b;
        this.labelTooltip.clear();
        this.labelTooltip.add(this.label.getComponent().copy().withStyle(ChatFormatting.WHITE));
        this.labelTooltip.addAll(this.commentLines.stream().map(s -> s.equals(".") ? " " : s).map(Component::literal).flatMap(stc -> FontHelper.cutTextComponent((Component)stc, (FontHelper.Palette)FontHelper.Palette.GRAY_AND_RED).stream()).toList());
        if (!b) {
            this.labelTooltip.add(Component.literal((String)"Disabled by the config").withStyle(ChatFormatting.RED));
        }
    }

    @Override
    public void render(GuiGraphics graphics, int index, int y, int x, int width, int height, int mouseX, int mouseY, boolean p_230432_9_, float partialTicks) {
        super.render(graphics, index, y, x, width, height, mouseX, mouseY, p_230432_9_, partialTicks);
    }

    @Override
    protected int getLabelWidth(int totalWidth) {
        return (int)((float)totalWidth * 0.4f) + 30;
    }

    public void setValue(@Nonnull T value) {
        this.value = value;
        this.onValueChange(value);
    }

    @Nonnull
    public T getValue() {
        return this.value;
    }

    public void onReset() {
        this.onValueChange(this.getValue());
    }

    public void onValueChange() {
        this.onValueChange(this.getValue());
    }

    public void onValueChange(T newValue) {
        List<Integer> armors = ((ArmorConfigScreen)Minecraft.getInstance().screen).getArmors();
        int selected = ((ArmorConfigScreen)Minecraft.getInstance().screen).getSelectedItem();
        Minecraft.getInstance().player.getInventory().getArmor(armors.get(selected).intValue()).set(this.component, this.value);
    }

    protected void bumpCog() {
        this.bumpCog(10.0f);
    }

    protected void bumpCog(float force) {
        ArmorConfigScreen.cogSpin.bump(3, (double)force);
    }

    public DataComponentType<?> getComponent() {
        return this.component;
    }

    public boolean isEditable() {
        return this.editable;
    }
}

