/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createqualityoflife.client.screens.tabs;

import com.mojang.authlib.properties.PropertyMap;
import com.simibubi.create.AllItems;
import com.simibubi.create.foundation.gui.widget.IconButton;
import com.simibubi.create.foundation.gui.widget.Label;
import com.simibubi.create.foundation.utility.CreateLang;
import fr.iglee42.createqualityoflife.CreateQOLLang;
import fr.iglee42.createqualityoflife.client.screens.ConfigureStatueScreen;
import fr.iglee42.createqualityoflife.client.screens.tabs.StatueTab;
import fr.iglee42.createqualityoflife.registries.ModGuiTextures;
import fr.iglee42.createqualityoflife.registries.ModIcons;
import fr.iglee42.createqualityoflife.statue.Statue;
import fr.iglee42.createqualityoflife.statue.StatueRenderer;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.createmod.catnip.gui.element.ScreenElement;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringUtil;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.item.component.ResolvableProfile;

public class SkinStatueTab
extends StatueTab {
    public static final int SKIN_Y = -12;
    private EditBox playerSkinTextBox;
    private int lastInputSkinBox;
    private List<IconButton> partsButtons;
    private List<Label> partsLabels;
    private IconButton capeButton;

    public SkinStatueTab(int index, ConfigureStatueScreen parent) {
        super(index, AllItems.GOGGLES.asItem(), parent, "statue.skinTab");
    }

    @Override
    public void initWidgets(int x, int y) {
        this.playerSkinTextBox = new EditBox(Minecraft.getInstance().font, x + 4, y + -12 + 5, 119, 20, (Component)Component.empty());
        Optional<ResolvableProfile> profile = this.getExampleStatue().getProfile();
        profile.ifPresent(rp -> this.playerSkinTextBox.setValue(rp.gameProfile().getName()));
        this.playerSkinTextBox.setResponder(s -> {
            this.lastInputSkinBox = 100;
        });
        this.playerSkinTextBox.setMaxLength(16);
        this.playerSkinTextBox.setBordered(false);
        this.playerSkinTextBox.setTextColor(0xFFFFFF);
        this.playerSkinTextBox.setFocused(false);
        this.playerSkinTextBox.setHint((Component)Component.literal((String)"Player Name"));
        this.playerSkinTextBox.setFilter(StringUtil::isValidPlayerName);
        this.partsButtons = new ArrayList<IconButton>();
        this.partsLabels = new ArrayList<Label>();
        this.addPartWidget(x, y, PlayerModelPart.CAPE, (ScreenElement)ModIcons.I_CAPE_OFF);
        this.addPartWidget(x, y, PlayerModelPart.HAT, (ScreenElement)ModIcons.I_HAT);
        this.addPartWidget(x, y, PlayerModelPart.JACKET, (ScreenElement)ModIcons.I_JACKET);
        this.addPartWidget(x, y, PlayerModelPart.LEFT_SLEEVE, (ScreenElement)ModIcons.I_LEFT_SLEEVE);
        this.addPartWidget(x, y, PlayerModelPart.RIGHT_SLEEVE, (ScreenElement)ModIcons.I_RIGHT_SLEEVE);
        this.addPartWidget(x, y, PlayerModelPart.LEFT_PANTS_LEG, (ScreenElement)ModIcons.I_LEFT_PANTS);
        this.addPartWidget(x, y, PlayerModelPart.RIGHT_PANTS_LEG, (ScreenElement)ModIcons.I_RIGHT_PANTS);
    }

    private void addPartWidget(int x, int y, PlayerModelPart part, ScreenElement icon) {
        Predicate<Statue> isPartActive = s -> s.isPartShown(part);
        int index = this.partsButtons.size();
        y = y + -12 - 2 + (index + 1) * 22;
        ArrayList<Object> tip = new ArrayList<Object>();
        tip.add(part.getName());
        tip.add(CreateLang.translateDirect((String)"gui.schematicannon.optionDisabled", (Object[])new Object[0]).withStyle(ChatFormatting.RED));
        ArrayList<MutableComponent> tipEnabled = new ArrayList<MutableComponent>(tip);
        tipEnabled.set(1, CreateLang.translateDirect((String)"gui.schematicannon.optionEnabled", (Object[])new Object[0]).withStyle(ChatFormatting.DARK_GREEN));
        IconButton btn = new IconButton(x + 2, y, icon);
        if (part == PlayerModelPart.CAPE) {
            btn.setIcon((ScreenElement)(isPartActive.test(this.getExampleStatue()) ? ModIcons.I_CAPE_ON : ModIcons.I_CAPE_OFF));
            this.capeButton = btn;
        }
        btn.withCallback(() -> {
            this.getExampleStatue().setPartVisibility(part, !isPartActive.test(this.getExampleStatue()));
            btn.green = isPartActive.test(this.getExampleStatue());
            btn.getToolTip().clear();
            btn.getToolTip().addAll(isPartActive.test(this.getExampleStatue()) ? tipEnabled : tip);
            if (part == PlayerModelPart.CAPE) {
                btn.setIcon((ScreenElement)(isPartActive.test(this.getExampleStatue()) ? ModIcons.I_CAPE_ON : ModIcons.I_CAPE_OFF));
            }
            this.getParent().sendUpdatePacket();
        });
        btn.green = isPartActive.test(this.getExampleStatue());
        btn.getToolTip().clear();
        btn.getToolTip().addAll(isPartActive.test(this.getExampleStatue()) ? tipEnabled : tip);
        Label label = new Label(x + 24, y + 5, part.getName());
        label.text = part.getName();
        Optional<ResourceLocation> texture = StatueRenderer.getPlayerProfileTexture(this.getExampleStatue()).map(PlayerSkin::capeTexture);
        if (part == PlayerModelPart.CAPE && texture.isEmpty()) {
            btn.active = false;
            btn.getToolTip().clear();
            btn.getToolTip().add(CreateQOLLang.translateDirect("statue.noCape", new Object[0]));
            btn.getToolTip().add(CreateQOLLang.translateDirect("statue.noCape1", new Object[0]));
        }
        this.partsButtons.add(btn);
        this.partsLabels.add(label);
    }

    @Override
    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partial, int x, int y) {
        if (this.lastInputSkinBox > 0) {
            --this.lastInputSkinBox;
        }
        if (this.lastInputSkinBox == 0) {
            String value = this.playerSkinTextBox.getValue();
            ResolvableProfile resolvableProfile = value.isEmpty() ? null : new ResolvableProfile(Optional.of(value), Optional.empty(), new PropertyMap());
            this.getExampleStatue().setProfile(resolvableProfile);
            this.lastInputSkinBox = -1;
            Optional<ResourceLocation> texture = StatueRenderer.getPlayerProfileTexture(this.getExampleStatue()).map(PlayerSkin::capeTexture);
            if (this.capeButton != null) {
                this.capeButton.active = texture.isPresent();
            }
            this.getParent().sendUpdatePacket();
        }
        ModGuiTextures.TEXT_BOX.render(graphics, x + 2, y + -12);
    }

    @Override
    public void forEachWidgets(Consumer<AbstractWidget> function) {
        function.accept((AbstractWidget)this.playerSkinTextBox);
        this.partsButtons.forEach(function);
        this.partsLabels.forEach(function);
    }

    @Override
    public void onQuit() {
        String value = this.playerSkinTextBox.getValue();
        ResolvableProfile resolvableProfile = value.isEmpty() ? null : new ResolvableProfile(Optional.of(value), Optional.empty(), new PropertyMap());
        this.getExampleStatue().setProfile(resolvableProfile);
    }
}

