/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createqualityoflife.client.screens;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.kinetics.simpleRelays.CogWheelBlock;
import fr.iglee42.createqualityoflife.client.screens.widgets.ArmorConfigScreenList;
import fr.iglee42.createqualityoflife.client.screens.widgets.ItemConfigButton;
import fr.iglee42.createqualityoflife.client.screens.widgets.entries.BooleanEntry;
import fr.iglee42.createqualityoflife.client.screens.widgets.entries.EnumEntry;
import fr.iglee42.createqualityoflife.client.screens.widgets.entries.ValueEntry;
import fr.iglee42.createqualityoflife.config.CreateQOLConfigs;
import fr.iglee42.createqualityoflife.items.ShadowRadianceChestplate;
import fr.iglee42.createqualityoflife.registries.ModArmorMaterials;
import fr.iglee42.createqualityoflife.registries.ModDataComponents;
import fr.iglee42.createqualityoflife.utils.ArmorRenderType;
import fr.iglee42.createqualityoflife.utils.PreferredRender;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.createmod.catnip.animation.Force;
import net.createmod.catnip.animation.PhysicalFloat;
import net.createmod.catnip.gui.AbstractSimiScreen;
import net.createmod.catnip.gui.UIRenderHelper;
import net.createmod.catnip.gui.element.DelegatedStencilElement;
import net.createmod.catnip.gui.element.GuiGameElement;
import net.createmod.catnip.theme.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class ArmorConfigScreen
extends AbstractSimiScreen {
    public static final PhysicalFloat cogSpin = PhysicalFloat.create().withLimit(10.0f).withDrag(0.3).addForce((Force)new Force.Static(0.2f));
    public static DelegatedStencilElement shadowElement = new DelegatedStencilElement((graphics, x, y, alpha) -> ArmorConfigScreen.renderCog(graphics), (graphics, x, y, alpha) -> graphics.fill(-200, -200, 200, 200, 0x60000000));
    protected ArmorConfigScreenList list;
    protected int listWidth;
    private int selectedItem = -1;
    private List<Integer> armors;

    protected void init() {
        super.init();
        this.listWidth = Math.min(this.width - 80, 300);
        int yCenter = this.height / 2;
        int listL = this.width / 2 - this.listWidth / 2;
        int listR = this.width / 2 + this.listWidth / 2;
        this.list = new ArmorConfigScreenList(this.minecraft, this.listWidth, this.height - 80, 35, 40, this);
        this.list.setX(listL);
        this.addRenderableWidget((GuiEventListener)this.list);
        this.armors = new ArrayList<Integer>();
        Minecraft.getInstance().player.getInventory().armor.forEach(it -> {
            if (!(it.getItem() instanceof ArmorItem)) {
                return;
            }
            if (((ArmorItem)it.getItem()).getMaterial().equals(ModArmorMaterials.SHADOW_RADIANCE)) {
                this.armors.add(Minecraft.getInstance().player.getInventory().armor.indexOf(it));
            }
        });
        this.armors = this.armors.reversed();
        for (int index = 0; index < this.armors.size(); ++index) {
            int finalIndex = index;
            this.addRenderableWidget((GuiEventListener)new ItemConfigButton(listL - 24, 35 + this.list.getHeight() / 2 + (index - 2) * 30, btn -> this.onSelectedChange(finalIndex), finalIndex).showing(Minecraft.getInstance().player.getInventory().getArmor(this.armors.get(index).intValue())));
        }
    }

    public void tick() {
        super.tick();
        cogSpin.tick();
        this.children().stream().filter(w -> w instanceof ItemConfigButton).forEach(btn -> ((ItemConfigButton)((Object)btn)).setActive(((ItemConfigButton)((Object)btn)).getIndex() != this.selectedItem));
        this.list.children().stream().filter(e -> e instanceof ValueEntry).map(e -> (ValueEntry)((Object)e)).forEach(entry -> {
            boolean flag;
            if (entry.getComponent().equals(ModDataComponents.HELMET_GOGGLES)) {
                if (!((Boolean)CreateQOLConfigs.server().helmetHaveGoggles.get()).booleanValue() && entry.isEditable()) {
                    ((BooleanEntry)((Object)entry)).setValue(false);
                }
                entry.setEditable((Boolean)CreateQOLConfigs.server().helmetHaveGoggles.get());
            }
            if (entry.getComponent().equals(ModDataComponents.BACKTANK_FANS)) {
                if (!((Boolean)CreateQOLConfigs.server().propellerAllowed.get()).booleanValue() && entry.isEditable()) {
                    ((BooleanEntry)((Object)entry)).setValue(false);
                }
                flag = this.list.children().stream().noneMatch(e -> {
                    BooleanEntry oEntry;
                    return e instanceof BooleanEntry && (oEntry = (BooleanEntry)((Object)((Object)e))).getComponent().equals(ModDataComponents.BACKTANK_ELYTRA_STATE) && (Boolean)oEntry.getValue() != false;
                });
                entry.setEditable((Boolean)CreateQOLConfigs.server().propellerAllowed.get() != false && flag);
            }
            if (entry.getComponent().equals(ModDataComponents.BACKTANK_HOVER)) {
                if (!(((Boolean)CreateQOLConfigs.server().hoverAllowed.get()).booleanValue() && ((Boolean)CreateQOLConfigs.server().propellerAllowed.get()).booleanValue() || !entry.isEditable())) {
                    ((BooleanEntry)((Object)entry)).setValue(false);
                }
                entry.setEditable((Boolean)CreateQOLConfigs.server().propellerAllowed.get() != false && (Boolean)CreateQOLConfigs.server().hoverAllowed.get() != false);
            }
            if (entry.getComponent().equals(ModDataComponents.BACKTANK_ELYTRA_STATE)) {
                if (!((Boolean)CreateQOLConfigs.server().elytraAllowed.get()).booleanValue() && entry.isEditable()) {
                    ((BooleanEntry)((Object)entry)).setValue(false);
                }
                flag = this.list.children().stream().noneMatch(e -> {
                    BooleanEntry oEntry;
                    return e instanceof BooleanEntry && (oEntry = (BooleanEntry)((Object)((Object)e))).getComponent().equals(ModDataComponents.BACKTANK_FANS) && (Boolean)oEntry.getValue() != false;
                });
                entry.setEditable((Boolean)CreateQOLConfigs.server().elytraAllowed.get() != false && flag);
            }
            if (entry.getComponent().equals(ModDataComponents.ARMOR_EFFECT)) {
                if (!((Boolean)CreateQOLConfigs.server().armorEffects.get()).booleanValue() && entry.isEditable()) {
                    ((BooleanEntry)((Object)entry)).setValue(false);
                }
                entry.setEditable((Boolean)CreateQOLConfigs.server().armorEffects.get());
            }
            if (entry.getComponent().equals(ModDataComponents.BOOTS_DIVING)) {
                if (!((Boolean)CreateQOLConfigs.server().bootsDiving.get()).booleanValue() && entry.isEditable()) {
                    ((BooleanEntry)((Object)entry)).setValue(false);
                }
                entry.setEditable((Boolean)CreateQOLConfigs.server().bootsDiving.get());
            }
            if (entry.getComponent().equals(ModDataComponents.BOOTS_LAVA)) {
                if (!((Boolean)CreateQOLConfigs.server().bootsLavaWalking.get()).booleanValue() && entry.isEditable()) {
                    ((BooleanEntry)((Object)entry)).setValue(false);
                }
                entry.setEditable((Boolean)CreateQOLConfigs.server().bootsLavaWalking.get());
            }
        });
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
    }

    protected void renderWindowBackground(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        graphics.fill(0, 0, this.width, this.height, -1339544524);
        shadowElement.at((float)this.width * 0.5f, (float)this.height * 0.5f, 0.0f).render(graphics);
        super.renderWindowBackground(graphics, mouseX, mouseY, partialTicks);
    }

    protected void prepareFrame() {
        UIRenderHelper.swapAndBlitColor((RenderTarget)this.minecraft.getMainRenderTarget(), (RenderTarget)UIRenderHelper.framebuffer);
        RenderSystem.clear((int)1280, (boolean)Minecraft.ON_OSX);
    }

    protected void endFrame() {
        UIRenderHelper.swapAndBlitColor((RenderTarget)UIRenderHelper.framebuffer, (RenderTarget)this.minecraft.getMainRenderTarget());
    }

    protected void renderWindow(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        int x = this.width / 2;
        graphics.drawCenteredString(this.minecraft.font, "Configure Shadow Radiance Armor", x, 15, ((Color)UIRenderHelper.COLOR_TEXT.getFirst()).getRGB());
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        cogSpin.bump(3, -scrollY * 5.0);
        return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
    }

    public boolean isPauseScreen() {
        return false;
    }

    protected static void renderCog(GuiGraphics graphics) {
        float partialTicks = Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(false);
        PoseStack poseStack = graphics.pose();
        poseStack.pushPose();
        poseStack.translate(-100.0f, 100.0f, -100.0f);
        poseStack.scale(200.0f, 200.0f, 1.0f);
        GuiGameElement.of((BlockState)((BlockState)AllBlocks.LARGE_COGWHEEL.getDefaultState().setValue((Property)CogWheelBlock.AXIS, (Comparable)Direction.Axis.Y))).rotateBlock(22.5, (double)cogSpin.getValue(partialTicks), 22.5).render(graphics);
        poseStack.popPose();
    }

    public List<Integer> getArmors() {
        return this.armors;
    }

    public int getSelectedItem() {
        return this.selectedItem;
    }

    public void onSelectedChange(int index) {
        this.selectedItem = index;
        this.list.children().clear();
        if (this.selectedItem == -1) {
            return;
        }
        ItemStack armor = Minecraft.getInstance().player.getInventory().getArmor(this.armors.get(this.selectedItem).intValue());
        switch (((ArmorItem)armor.getItem()).getType()) {
            case HELMET: {
                this.list.children().add(new BooleanEntry("Enable Goggles", (Boolean)armor.getOrDefault(ModDataComponents.HELMET_GOGGLES, (Object)true), ModDataComponents.HELMET_GOGGLES, "Should engineer's goggle's information be displayed"));
                break;
            }
            case CHESTPLATE: {
                this.list.children().add(new BooleanEntry("Enable Custom Arms", (Boolean)armor.getOrDefault(ModDataComponents.BACKTANK_ARMS, (Object)true), ModDataComponents.BACKTANK_ARMS, "Should the player's arms be replaced with the armor in first person"));
                if (ShadowRadianceChestplate.hasPropeller(armor)) {
                    this.list.children().add(new BooleanEntry("Enable Fan", (Boolean)armor.getOrDefault(ModDataComponents.BACKTANK_FANS, (Object)true), ModDataComponents.BACKTANK_FANS, "Activate the propeller on the backtank", "_Can't be enabled if the elytra are enabled_"));
                    this.list.children().add(new BooleanEntry("Enable Hover", (Boolean)armor.getOrDefault(ModDataComponents.BACKTANK_HOVER, (Object)false), ModDataComponents.BACKTANK_HOVER, "Activate the hover mode"));
                }
                if (ShadowRadianceChestplate.hasElytra(armor)) {
                    this.list.children().add(new BooleanEntry("Enable Elytra", (Boolean)armor.getOrDefault(ModDataComponents.BACKTANK_ELYTRA_STATE, (Object)false), ModDataComponents.BACKTANK_ELYTRA_STATE, "Activate the elytra on the backtank", "_Can't be enabled if the fan is enabled_"));
                }
                this.list.children().add(new EnumEntry(this, "Preferred Render", (Enum)armor.getOrDefault(ModDataComponents.PREFERRED_RENDER, (Object)PreferredRender.BOTH), ModDataComponents.PREFERRED_RENDER, new String[]{"Define how the additions should be rendered.", "\"Elytra\" renders only the elytra", "\"Backtank\" renders only the backtank"}){

                    @Override
                    protected void cycleValue(int direction) {
                        List<Integer> armors = ((ArmorConfigScreen)Minecraft.getInstance().screen).getArmors();
                        int selected = ((ArmorConfigScreen)Minecraft.getInstance().screen).getSelectedItem();
                        ArmorItem item = (ArmorItem)Minecraft.getInstance().player.getInventory().getArmor(armors.get(selected).intValue()).getItem();
                        PreferredRender e = (PreferredRender)((Object)this.getValue());
                        PreferredRender[] options = (PreferredRender[])Arrays.stream(PreferredRender.values()).filter(it -> it.canBeSelected(item)).toArray(PreferredRender[]::new);
                        e = options[Math.floorMod(e.ordinal() + direction, options.length)];
                        this.setValue(e);
                        this.bumpCog((float)direction * 15.0f);
                    }
                });
                break;
            }
            case BOOTS: {
                this.list.children().add(new BooleanEntry("Enable Diving", (Boolean)armor.getOrDefault(ModDataComponents.BOOTS_DIVING, (Object)false), ModDataComponents.BOOTS_DIVING, "Enable diving, which makes the player descends quicker in liquids"));
                this.list.children().add(new BooleanEntry("Enable Lava Walking", (Boolean)armor.getOrDefault(ModDataComponents.BOOTS_LAVA, (Object)true), ModDataComponents.BOOTS_LAVA, "Enable walking under lava, which makes the player walks normally under lava"));
                this.list.children().add(new BooleanEntry("Enable Belt Blocking", (Boolean)armor.getOrDefault(ModDataComponents.BOOTS_BELT, (Object)true), ModDataComponents.BOOTS_BELT, "You won't be pushed by belt if enabled"));
                break;
            }
        }
        MobEffect effect = switch (((ArmorItem)armor.getItem()).getType()) {
            case ArmorItem.Type.BOOTS -> (MobEffect)MobEffects.JUMP.value();
            case ArmorItem.Type.LEGGINGS -> (MobEffect)MobEffects.MOVEMENT_SPEED.value();
            case ArmorItem.Type.CHESTPLATE -> (MobEffect)MobEffects.DAMAGE_BOOST.value();
            case ArmorItem.Type.HELMET -> (MobEffect)MobEffects.NIGHT_VISION.value();
            default -> (MobEffect)MobEffects.DIG_SLOWDOWN.value();
        };
        this.list.children().add(new BooleanEntry("Apply Potion Effect", (Boolean)armor.getOrDefault(ModDataComponents.ARMOR_EFFECT, (Object)true), ModDataComponents.ARMOR_EFFECT, "Enable the potion effect granted by the armor piece", "For this piece, the effect is " + Component.translatable((String)effect.getDescriptionId()).getString()));
        this.list.children().add(new EnumEntry(this, "Render Type", (Enum)armor.getOrDefault(ModDataComponents.ARMOR_RENDER_TYPE, (Object)ArmorRenderType.ALL), ModDataComponents.ARMOR_RENDER_TYPE, new String[]{"Define how the armor piece should be rendered.", "\"Armor only\" renders only the armor", "\"Addition only\" renders only the additions (E.g. Backtank, Goggles)"}){

            @Override
            protected void cycleValue(int direction) {
                List<Integer> armors = ((ArmorConfigScreen)Minecraft.getInstance().screen).getArmors();
                int selected = ((ArmorConfigScreen)Minecraft.getInstance().screen).getSelectedItem();
                ArmorItem item = (ArmorItem)Minecraft.getInstance().player.getInventory().getArmor(armors.get(selected).intValue()).getItem();
                ArmorRenderType e = (ArmorRenderType)((Object)this.getValue());
                ArmorRenderType[] options = (ArmorRenderType[])Arrays.stream(ArmorRenderType.values()).filter(it -> it.canBeSelected(item)).toArray(ArmorRenderType[]::new);
                e = options[Math.floorMod(e.ordinal() + direction, options.length)];
                this.setValue(e);
                this.bumpCog((float)direction * 15.0f);
            }
        });
    }

    public void resize(Minecraft p_96575_, int p_96576_, int p_96577_) {
        super.resize(p_96575_, p_96576_, p_96577_);
        this.selectedItem = -1;
    }
}

