/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createqualityoflife.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.simibubi.create.AllItems;
import com.simibubi.create.AllPartialModels;
import fr.iglee42.createqualityoflife.config.CreateQOLConfigs;
import fr.iglee42.createqualityoflife.registries.ModDataComponents;
import fr.iglee42.createqualityoflife.registries.ModItems;
import fr.iglee42.createqualityoflife.utils.ArmorRenderType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class GoggleArmorLayer<T extends LivingEntity, M extends EntityModel<T>>
extends RenderLayer<T, M> {
    public GoggleArmorLayer(RenderLayerParent<T, M> renderer) {
        super(renderer);
    }

    public void render(PoseStack ms, MultiBufferSource buffer, int light, LivingEntity entity, float yaw, float pitch, float pt, float p_117356_, float p_117357_, float p_117358_) {
        if (entity.getPose() == Pose.SLEEPING) {
            return;
        }
        if (!ModItems.SHADOW_RADIANCE_HELMET.isIn(entity.getItemBySlot(EquipmentSlot.HEAD))) {
            return;
        }
        if (!((ArmorRenderType)((Object)entity.getItemBySlot(EquipmentSlot.HEAD).getOrDefault(ModDataComponents.ARMOR_RENDER_TYPE, (Object)ArmorRenderType.ALL))).shouldRenderAddition()) {
            return;
        }
        if (!((Boolean)CreateQOLConfigs.server().helmetHaveGoggles.get()).booleanValue()) {
            return;
        }
        if (!((Boolean)entity.getItemBySlot(EquipmentSlot.HEAD).getOrDefault(ModDataComponents.HELMET_GOGGLES, (Object)true)).booleanValue()) {
            return;
        }
        EntityModel entityModel = this.getParentModel();
        if (!(entityModel instanceof HumanoidModel)) {
            return;
        }
        HumanoidModel model = (HumanoidModel)entityModel;
        ItemStack stack = new ItemStack((ItemLike)AllItems.GOGGLES.get());
        ms.pushPose();
        ms.translate((double)model.head.x / 16.0, (double)model.head.y / 16.0, (double)model.head.z / 16.0);
        ms.mulPose(Axis.YP.rotation(model.head.yRot));
        ms.mulPose(Axis.XP.rotation(model.head.xRot));
        if (model.young) {
            if (model.scaleHead) {
                float f = 1.5f / model.babyHeadScale;
                ms.scale(f, f, f);
            }
            ms.translate(0.0, (double)(model.babyYHeadOffset / 16.0f), (double)(model.babyZHeadOffset / 16.0f));
        }
        ms.translate(0.0, -0.3, -0.045);
        ms.mulPose(Axis.ZP.rotationDegrees(180.0f));
        ms.scale(0.625f, 0.625f, 0.625f);
        Minecraft.getInstance().getItemRenderer().render(stack, ItemDisplayContext.HEAD, false, ms, buffer, light, OverlayTexture.NO_OVERLAY, AllPartialModels.GOGGLES.get());
        ms.popPose();
    }

    public static void registerOnAll(EntityRenderDispatcher renderManager) {
        for (EntityRenderer renderer : renderManager.getSkinMap().values()) {
            GoggleArmorLayer.registerOn(renderer);
        }
        for (EntityRenderer renderer : renderManager.renderers.values()) {
            GoggleArmorLayer.registerOn(renderer);
        }
    }

    public static void registerOn(EntityRenderer<?> entityRenderer) {
        if (!(entityRenderer instanceof LivingEntityRenderer)) {
            return;
        }
        LivingEntityRenderer livingRenderer = (LivingEntityRenderer)entityRenderer;
        if (!(livingRenderer.getModel() instanceof HumanoidModel)) {
            return;
        }
        GoggleArmorLayer layer = new GoggleArmorLayer(livingRenderer);
        livingRenderer.addLayer(layer);
    }
}

