/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.create_d2d.register;

import dev.lopyluna.create_d2d.DesiresCreate;
import net.createmod.catnip.lang.Lang;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;

public class DesiresTags {
    public static <T> TagKey<T> optionalTag(Registry<T> registry, ResourceLocation id) {
        return TagKey.create((ResourceKey)registry.key(), (ResourceLocation)id);
    }

    public static <T> TagKey<T> commonTag(Registry<T> registry, String path) {
        return DesiresTags.optionalTag(registry, ResourceLocation.fromNamespaceAndPath((String)"c", (String)path));
    }

    public static <T> TagKey<T> modTag(Registry<T> registry, String path) {
        return DesiresTags.optionalTag(registry, DesiresCreate.loc(path));
    }

    public static TagKey<Block> commonBlockTag(String path) {
        return DesiresTags.commonTag(BuiltInRegistries.BLOCK, path);
    }

    public static TagKey<Item> commonItemTag(String path) {
        return DesiresTags.commonTag(BuiltInRegistries.ITEM, path);
    }

    public static TagKey<Fluid> commonFluidTag(String path) {
        return DesiresTags.commonTag(BuiltInRegistries.FLUID, path);
    }

    public static TagKey<Block> modBlockTag(String path) {
        return DesiresTags.modTag(BuiltInRegistries.BLOCK, path);
    }

    public static TagKey<Item> modItemTag(String path) {
        return DesiresTags.modTag(BuiltInRegistries.ITEM, path);
    }

    public static TagKey<Fluid> modFluidTag(String path) {
        return DesiresTags.modTag(BuiltInRegistries.FLUID, path);
    }

    public static void init() {
        BlockTags.init();
        ItemTags.init();
    }

    public static enum BlockTags {
        DYED_BLOCKS,
        ARTIFICIAL_ORE_GENERATOR,
        ORE_GENERATOR,
        WEAK_FURNACE,
        STRONG_FURNACE,
        SUPER_STRONG_FURNACE;

        public final TagKey<Block> tag;
        public final boolean alwaysDatagen;

        private BlockTags() {
            this(NameSpace.MOD);
        }

        private BlockTags(NameSpace namespace) {
            this(namespace, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private BlockTags(NameSpace namespace, String path) {
            this(namespace, path, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private BlockTags(NameSpace namespace, boolean optional, boolean alwaysDatagen) {
            this(namespace, null, optional, alwaysDatagen);
        }

        private BlockTags(NameSpace namespace, String path, boolean optional, boolean alwaysDatagen) {
            ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)namespace.id, (String)(path == null ? Lang.asId((String)this.name()) : path));
            this.tag = optional ? DesiresTags.optionalTag(BuiltInRegistries.BLOCK, id) : net.minecraft.tags.BlockTags.create((ResourceLocation)id);
            this.alwaysDatagen = alwaysDatagen;
        }

        public boolean is(Block block) {
            return block.builtInRegistryHolder().is(this.tag);
        }

        public boolean is(ItemStack stack) {
            BlockItem blockItem;
            Item item;
            return stack != null && (item = stack.getItem()) instanceof BlockItem && this.is((blockItem = (BlockItem)item).getBlock());
        }

        public boolean is(ItemLike item) {
            BlockItem blockItem;
            return item instanceof BlockItem && this.is((blockItem = (BlockItem)item).getBlock());
        }

        public boolean is(BlockState state) {
            return state.is(this.tag);
        }

        public boolean is(TagKey<Block> tag) {
            return tag == this.tag;
        }

        private static void init() {
        }
    }

    public static enum ItemTags {
        DYED_BLOCKS,
        PALETTE_BLOCKS;

        public final TagKey<Item> tag;
        public final boolean alwaysDatagen;

        private ItemTags() {
            this(NameSpace.MOD);
        }

        private ItemTags(NameSpace namespace) {
            this(namespace, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private ItemTags(NameSpace namespace, String path) {
            this(namespace, path, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private ItemTags(NameSpace namespace, boolean optional, boolean alwaysDatagen) {
            this(namespace, null, optional, alwaysDatagen);
        }

        private ItemTags(NameSpace namespace, String path, boolean optional, boolean alwaysDatagen) {
            ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)namespace.id, (String)(path == null ? Lang.asId((String)this.name()) : path));
            this.tag = optional ? DesiresTags.optionalTag(BuiltInRegistries.ITEM, id) : net.minecraft.tags.ItemTags.create((ResourceLocation)id);
            this.alwaysDatagen = alwaysDatagen;
        }

        public boolean matches(Item item) {
            return item.builtInRegistryHolder().is(this.tag);
        }

        public boolean matches(ItemStack stack) {
            return stack.is(this.tag);
        }

        private static void init() {
        }
    }

    public static enum NameSpace {
        MOD("create_d2d", false, true),
        COMMON("c"),
        CREATE("create");

        public final String id;
        public final boolean optionalDefault;
        public final boolean alwaysDatagenDefault;

        private NameSpace(String id) {
            this(id, true, false);
        }

        private NameSpace(String id, boolean optionalDefault, boolean alwaysDatagenDefault) {
            this.id = id;
            this.optionalDefault = optionalDefault;
            this.alwaysDatagenDefault = alwaysDatagenDefault;
        }
    }
}

